/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.legokaraide;

import ch.karatojava.editor.AbstractEditor;
import ch.karatojava.editor.EditorListenerSupport;
import ch.karatojava.util.Configuration;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public class LegoSettingsEditor
extends AbstractEditor {
    public static final String NQC_PATH_PROPERTY = "NQC_PATH";
    public static final String NQC_COM_PORT_PROPERTY = "NQC_COM_PORT";
    public static final String TURN_TIME_LEFT_PROPERTY = "TURN_TIME_LEFT";
    public static final String TURN_TIME_RIGHT_PROPERTY = "TURN_TIME_RIGHT";
    public static final String MOVE_TIME_PROPERTY = "MOVE_TIME";
    public static final String RCX_CHECK_WAIT_TIME_PROPERTY = "RCX_CHECK_WAIT_TIME";
    public static final String RCX_TURN_TIME_RIGHT_GO_PROPERTY = "RCX_TURN_TIME_RIGHT_GO";
    public static final String RCX_TURN_TIME_RIGHT_BACK_PROPERTY = "RCX_TURN_TIME_RIGHT_BACK";
    public static final String RCX_TURN_TIME_LEFT_GO_PROPERTY = "RCX_TURN_TIME_LEFT_GO";
    public static final String RCX_TURN_TIME_LEFT_BACK_PROPERTY = "RCX_TURN_TIME_LEFT_BACK";
    public static final String LIGHT_SENSITY_RCX_PROPERTY = "LIGHT_SENSITY_RCX";
    public static final String LIGHT_SENSITY_RCX_MOVE_PROPERTY = "LIGHT_SENSITY_RCX_MOVE";
    public static final String LIGHT_SENSITY_GROUND_PROPERTY = "LIGHT_SENSITY_GROUND";
    protected Properties properties;
    protected boolean modified;

    public LegoSettingsEditor() {
        this.doNewFile();
    }

    public void setValue(String string, int n) {
        this.setValue(string, Integer.toString(n));
    }

    public void setValue(String string, String string2) {
        this.properties.setProperty(string, string2);
        this.modified = true;
        this.listenerSupport.fireModifiedContent();
    }

    public int getValue(String string) {
        return Integer.parseInt(this.properties.getProperty(string));
    }

    public String getStringValue(String string) {
        return this.properties.getProperty(string);
    }

    @Override
    protected void doSave(OutputStream outputStream) throws Exception {
        this.properties.store(outputStream, "LegoSettings");
    }

    @Override
    protected void doSetContent(Object object) {
        this.properties = (Properties)object;
    }

    @Override
    protected void doNewFile() {
        try {
            this.properties = new Properties();
            this.properties.load(this.getClass().getResourceAsStream("/kappsresources/legokara/standardlegosettings.properties"));
        }
        catch (IOException iOException) {
            throw new RuntimeException("LegoSettingsEditor.doNewFile: INTERNAL ERROR. DEFAULT SETTINGS NOT FOUND. \n" + iOException.getMessage());
        }
    }

    protected void checkNumericalValue(Properties properties, String string) throws Exception {
        int n = Integer.parseInt(properties.getProperty(string));
        int n2 = Configuration.getInstance().getInt("karamodel/legokara/settings/min/" + string);
        int n3 = Configuration.getInstance().getInt("karamodel/legokara/settings/max/" + string);
        if (n < n2 || n > n3) {
            throw new Exception(Configuration.getInstance().getFormatString("language/$language/legokara/errors/illegalpropertyvalue", new String[]{string, "" + n, "" + n2, "" + n3}));
        }
    }

    @Override
    public Object create(InputStream inputStream) throws Exception {
        Properties properties = new Properties();
        properties.load(inputStream);
        this.checkNumericalValue(properties, TURN_TIME_LEFT_PROPERTY);
        this.checkNumericalValue(properties, TURN_TIME_RIGHT_PROPERTY);
        this.checkNumericalValue(properties, MOVE_TIME_PROPERTY);
        this.checkNumericalValue(properties, RCX_CHECK_WAIT_TIME_PROPERTY);
        this.checkNumericalValue(properties, RCX_TURN_TIME_RIGHT_GO_PROPERTY);
        this.checkNumericalValue(properties, RCX_TURN_TIME_RIGHT_BACK_PROPERTY);
        this.checkNumericalValue(properties, RCX_TURN_TIME_LEFT_GO_PROPERTY);
        this.checkNumericalValue(properties, RCX_TURN_TIME_LEFT_BACK_PROPERTY);
        this.checkNumericalValue(properties, LIGHT_SENSITY_RCX_PROPERTY);
        this.checkNumericalValue(properties, LIGHT_SENSITY_RCX_MOVE_PROPERTY);
        this.checkNumericalValue(properties, LIGHT_SENSITY_GROUND_PROPERTY);
        return properties;
    }

    @Override
    public Object getContent() {
        return this.properties;
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    @Override
    public void resetModified() {
        this.modified = false;
    }

    public EditorListenerSupport getEditorListenerSupport() {
        return this.listenerSupport;
    }
}

