/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.legokaraide;

import ch.karatojava.kapps.actorfsm.ActorTypeInterface;
import ch.karatojava.kapps.actorfsm.CommandTypeInterface;
import ch.karatojava.kapps.actorfsm.SensorTypeInterface;
import ch.karatojava.kapps.actorfsm.State;
import ch.karatojava.kapps.actorfsm.StateMachine;
import ch.karatojava.kapps.actorfsm.Transition;
import ch.karatojava.util.Configuration;
import ch.karatojava.util.StreamStringReader;

public class LegoCompiler {
    protected SensorTypeInterface[] sensors;
    protected String[] nqcSensorNames;
    protected SensorTypeInterface wallFrontSensor;
    protected SensorTypeInterface wallLeftSensor;
    protected SensorTypeInterface wallRightSensor;
    protected SensorTypeInterface groundSensor;

    public LegoCompiler(ActorTypeInterface actorTypeInterface) {
        this.wallFrontSensor = this.getSensorByName(actorTypeInterface, "treeFront");
        this.wallLeftSensor = this.getSensorByName(actorTypeInterface, "treeLeft");
        this.wallRightSensor = this.getSensorByName(actorTypeInterface, "treeRight");
        this.groundSensor = this.getSensorByName(actorTypeInterface, "onLeaf");
        this.sensors = new SensorTypeInterface[]{this.wallFrontSensor, this.wallRightSensor, this.wallLeftSensor, this.groundSensor};
        this.nqcSensorNames = new String[]{"wallfront", "wallright", "wallleft", "ispainted"};
    }

    public SensorTypeInterface getSensorByName(ActorTypeInterface actorTypeInterface, String string) {
        SensorTypeInterface[] sensorTypeInterfaceArray = actorTypeInterface.getSensors();
        for (int i = 0; i < sensorTypeInterfaceArray.length; ++i) {
            if (!sensorTypeInterfaceArray[i].getName().equals(string)) continue;
            return sensorTypeInterfaceArray[i];
        }
        return null;
    }

    public CommandTypeInterface getCommandByName(ActorTypeInterface actorTypeInterface, String string) {
        CommandTypeInterface[] commandTypeInterfaceArray = actorTypeInterface.getCommands();
        for (int i = 0; i < commandTypeInterfaceArray.length; ++i) {
            if (!commandTypeInterfaceArray[i].getName().equals(string)) continue;
            return commandTypeInterfaceArray[i];
        }
        return null;
    }

    protected int getSensorValue(Transition transition, SensorTypeInterface sensorTypeInterface) {
        int n = 0;
        if (transition.getFrom().usesSensor(sensorTypeInterface)) {
            n = transition.getSensorInput(sensorTypeInterface);
        }
        return n;
    }

    public String compile(StateMachine stateMachine) throws Exception {
        if (stateMachine.getStartState() == null) {
            throw new Exception(Configuration.getInstance().getString("language/$language/legokara/errors/nostartstate"));
        }
        State[] stateArray = stateMachine.getStates();
        String string = this.commonCode();
        string = string + "task FSM()\n";
        string = string + "{\n";
        string = string + "  state = " + stateMachine.indexOf(stateMachine.getStartState()) + ";\n";
        string = string + "  while (state != 0)\n";
        string = string + "  {\n";
        for (int i = 1; i < stateArray.length; ++i) {
            int n;
            string = string + "    if (state == " + i + ")" + "\n";
            string = string + "    {\n";
            Transition[] transitionArray = stateArray[i].getTransitions();
            boolean bl = false;
            boolean[] blArray = new boolean[this.sensors.length];
            for (n = 0; n < transitionArray.length; ++n) {
                for (int j = 0; j < this.sensors.length; ++j) {
                    int n2 = j;
                    blArray[n2] = blArray[n2] | this.getSensorValue(transitionArray[n], this.sensors[j]) != 0;
                    bl |= blArray[j];
                }
            }
            if (bl) {
                string = string + "      start SendIR;\n";
                string = string + "      checksensor(" + (blArray[0] ? 1 : 0) + "," + (blArray[1] ? 1 : 0) + "," + (blArray[2] ? 1 : 0) + "," + (blArray[3] ? 1 : 0) + ");" + "\n";
                string = string + "      stop SendIR;\n";
            }
            for (n = 0; n < transitionArray.length; ++n) {
                String string2 = "";
                if (bl) {
                    for (int j = 0; j < this.sensors.length; ++j) {
                        if (this.getSensorValue(transitionArray[n], this.sensors[j]) == 0) continue;
                        if (j > 0 && !string2.equals("")) {
                            string2 = string2 + " && ";
                        }
                        string2 = string2 + "(" + this.nqcSensorNames[j] + " == " + transitionArray[n].getSensorInput(this.sensors[j]) + ")";
                    }
                }
                if (string2.equals("")) {
                    string2 = "true";
                }
                string = string + "      if (" + string2 + ")" + "\n";
                string = string + "      {";
                CommandTypeInterface[] commandTypeInterfaceArray = transitionArray[n].getCommands();
                for (int j = 0; j < commandTypeInterfaceArray.length; ++j) {
                    string = commandTypeInterfaceArray[j].getName().equals("move") ? string + "start SendIR; move(); stop SendIR; " : string + commandTypeInterfaceArray[j].getName() + "(); ";
                }
                string = string + "state = " + stateMachine.indexOf(transitionArray[n].getTo()) + "; ";
                string = string + "continue;}\n";
            }
            string = string + "    }\n";
        }
        string = string + "  }\n";
        string = string + "  stop FSM;\n";
        string = string + "}\n";
        return string;
    }

    protected String commonCode() throws Exception {
        return StreamStringReader.readString(this.getClass().getResourceAsStream("/kappsresources/legokara/nqccode/code.nqc"));
    }
}

