/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.karaide.worldio;

import ch.karatojava.kapps.karaide.Kara;
import ch.karatojava.kapps.karaide.worldio.XmlKara;
import ch.karatojava.kapps.karaide.worldio.XmlKaraList;
import ch.karatojava.kapps.karaide.worldio.XmlObstaclePoints;
import ch.karatojava.kapps.karaide.worldio.XmlPaintedfieldPoints;
import ch.karatojava.kapps.karaide.worldio.XmlPoint;
import ch.karatojava.kapps.karaide.worldio.XmlStreetList;
import ch.karatojava.kapps.karaide.worldio.XmlWallPoints;
import ch.karatojava.kapps.karaide.worldio.XmlWorld;
import ch.karatojava.kapps.karaide.worldobjects.LEAF;
import ch.karatojava.kapps.world.World;
import ch.karatojava.kapps.world.WorldField;
import ch.karatojava.kapps.world.WorldObjectInterface;
import ch.karatojava.kapps.world.editor.io.WorldOutputterInterface;
import ch.karatojava.util.Configuration;
import java.io.OutputStream;
import java.util.List;
import javax.xml.bind.JAXBContext;

public class WorldOutputter
implements WorldOutputterInterface {
    private static WorldOutputter instance;
    public static String version;

    protected WorldOutputter() {
    }

    public static WorldOutputterInterface getInstance() {
        if (instance == null) {
            instance = new WorldOutputter();
        }
        return instance;
    }

    @Override
    public void outputWorld(World world, OutputStream outputStream) throws Exception {
        WorldField worldField;
        XmlWorld xmlWorld = new XmlWorld();
        xmlWorld.setSizex(world.getSizeX());
        xmlWorld.setSizey(world.getSizeY());
        xmlWorld.setVersion(version);
        XmlPaintedfieldPoints xmlPaintedfieldPoints = new XmlPaintedfieldPoints();
        XmlWallPoints xmlWallPoints = new XmlWallPoints();
        XmlObstaclePoints xmlObstaclePoints = new XmlObstaclePoints();
        XmlKaraList xmlKaraList = new XmlKaraList();
        XmlStreetList xmlStreetList = new XmlStreetList();
        List<WorldField> list = world.getObjectFieldsVector();
        for (int i = 0; i < list.size(); ++i) {
            worldField = list.get(i);
            WorldObjectInterface[] worldObjectInterfaceArray = worldField.getStack();
            for (int j = 0; j < worldObjectInterfaceArray.length; ++j) {
                Object object;
                WorldObjectInterface worldObjectInterface = worldObjectInterfaceArray[j];
                if (worldObjectInterface == null) continue;
                int n = worldObjectInterface.getType();
                if (n == 1) {
                    object = new XmlPoint();
                    ((XmlPoint)object).setX(worldField.getX());
                    ((XmlPoint)object).setY(worldField.getY());
                    xmlWallPoints.getXmlPoint().add((XmlPoint)object);
                    continue;
                }
                if (n == 4) {
                    object = new XmlPoint();
                    ((XmlPoint)object).setX(worldField.getX());
                    ((XmlPoint)object).setY(worldField.getY());
                    xmlObstaclePoints.getXmlPoint().add((XmlPoint)object);
                    continue;
                }
                if (n == 2) {
                    object = new XmlPoint();
                    ((XmlPoint)object).setX(worldField.getX());
                    ((XmlPoint)object).setY(worldField.getY());
                    ((XmlPoint)object).setType(((LEAF)worldObjectInterface).getLeafType());
                    xmlPaintedfieldPoints.getXmlPoint().add((XmlPoint)object);
                    continue;
                }
                if (n != 8) continue;
                object = new XmlKara();
                ((XmlKara)object).setX(worldField.getX());
                ((XmlKara)object).setY(worldField.getY());
                ((XmlKara)object).setName(((Kara)worldObjectInterface).getIdentity());
                ((XmlKara)object).setDirection(((Kara)worldObjectInterface).getDirection());
                xmlKaraList.getXmlKara().add((XmlKara)object);
            }
        }
        xmlWorld.setXmlPaintedfieldPoints(xmlPaintedfieldPoints);
        xmlWorld.setXmlObstaclePoints(xmlObstaclePoints);
        xmlWorld.setXmlKaraList(xmlKaraList);
        xmlWorld.setXmlWallPoints(xmlWallPoints);
        xmlWorld.setXmlStreetList(xmlStreetList);
        JAXBContext jAXBContext = JAXBContext.newInstance((String)"ch.karatojava.kapps.karaide.worldio");
        worldField = jAXBContext.createMarshaller();
        worldField.setProperty("jaxb.formatted.output", Boolean.TRUE);
        worldField.marshal(xmlWorld, outputStream);
    }

    static {
        version = "KaraX 1.0 " + Configuration.getInstance().getString("karamodel/$karamodel/savefiletype");
    }
}

