/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.karaide.worldio;

import ch.karatojava.kapps.karaide.Kara;
import ch.karatojava.kapps.karaide.KaraException;
import ch.karatojava.kapps.karaide.worldio.WorldOutputter;
import ch.karatojava.kapps.karaide.worldio.XmlKara;
import ch.karatojava.kapps.karaide.worldio.XmlPoint;
import ch.karatojava.kapps.karaide.worldio.XmlWorld;
import ch.karatojava.kapps.karaide.worldobjects.LEAF;
import ch.karatojava.kapps.karaide.worldobjects.MUSHROOM;
import ch.karatojava.kapps.karaide.worldobjects.TREE;
import ch.karatojava.kapps.world.World;
import ch.karatojava.kapps.world.WorldInternalException;
import ch.karatojava.kapps.world.editor.io.WorldBuilderInterface;
import ch.karatojava.util.Configuration;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;

public class WorldBuilder
implements WorldBuilderInterface {
    private static WorldBuilder instance;

    protected WorldBuilder() {
    }

    @Override
    public World buildWorld(InputStream inputStream) throws Exception {
        try {
            int n;
            JAXBContext jAXBContext = JAXBContext.newInstance((String)"ch.karatojava.kapps.karaide.worldio");
            Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
            XmlWorld xmlWorld = (XmlWorld)unmarshaller.unmarshal(inputStream);
            String string = xmlWorld.getVersion();
            if (!string.equalsIgnoreCase(WorldOutputter.version)) {
                String[] stringArray = new String[]{string, WorldOutputter.version};
                throw new KaraException("language/$language/iomessages/wrongversion", stringArray);
            }
            int n2 = xmlWorld.getSizex();
            if (!World.sizeOk(n2, n = xmlWorld.getSizey())) {
                throw new Exception("Invalid world size (" + n2 + ", " + n + ")");
            }
            World world = new World(n2, n);
            this.addKaras(world, xmlWorld.getXmlKaraList().getXmlKara());
            this.addMushrooms(world, xmlWorld.getXmlObstaclePoints().getXmlPoint());
            this.addLeafs(world, xmlWorld.getXmlPaintedfieldPoints().getXmlPoint());
            this.addTrees(world, xmlWorld.getXmlWallPoints().getXmlPoint());
            return world;
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string == null) {
                string = "";
            }
            String string2 = MessageFormat.format(Configuration.getInstance().getString("language/$language/iomessages/error"), string);
            throw new Exception(string2);
        }
    }

    protected void checkCoordinate(World world, int n, int n2) throws Exception {
        if (!world.coordinateOk(n, n2)) {
            throw new Exception("Invalid coordinate (" + n + ", " + n2 + ")");
        }
    }

    protected void addMushrooms(World world, List list) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            XmlPoint xmlPoint = (XmlPoint)list.get(i);
            int n = xmlPoint.getX();
            int n2 = xmlPoint.getY();
            this.checkCoordinate(world, n, n2);
            if (!world.canPutObjectAt(MUSHROOM.getInstance(), n, n2)) {
                throw new Exception("Invalid mushroom / other object combination.");
            }
            world.putObjectAt(MUSHROOM.getInstance(), n, n2);
        }
    }

    protected void addTrees(World world, List list) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            XmlPoint xmlPoint = (XmlPoint)list.get(i);
            int n = xmlPoint.getX();
            int n2 = xmlPoint.getY();
            this.checkCoordinate(world, n, n2);
            if (!world.canPutObjectAt(TREE.getInstance(), n, n2)) {
                throw new Exception("Invalid tree / other object combination.");
            }
            world.putObjectAt(TREE.getInstance(), n, n2);
        }
    }

    protected void addLeafs(World world, List list) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            XmlPoint xmlPoint = (XmlPoint)list.get(i);
            int n = xmlPoint.getX();
            int n2 = xmlPoint.getY();
            this.checkCoordinate(world, n, n2);
            if (!world.canPutObjectAt(LEAF.getInstance(), n, n2)) {
                throw new Exception("Invalid leaf / other object combination.");
            }
            if (xmlPoint.getType() != null) {
                if (!LEAF.isValidLeafType(xmlPoint.getType())) {
                    throw new Exception("Invalid leaf type (" + xmlPoint.getType() + ")");
                }
                world.putObjectAt(LEAF.getInstance(xmlPoint.getType()), n, n2);
                continue;
            }
            world.putObjectAt(LEAF.getInstance(), n, n2);
        }
    }

    protected void addKaras(World world, List list) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            Kara kara;
            XmlKara xmlKara = (XmlKara)list.get(i);
            int n = xmlKara.getX();
            int n2 = xmlKara.getY();
            this.checkCoordinate(world, n, n2);
            if (Kara.getKara(xmlKara.getName()) != null) {
                kara = (Kara)Kara.getKara(xmlKara.getName()).clone();
                int n3 = xmlKara.getDirection();
                if (!Kara.isLegalDirection(n3)) {
                    throw new Exception("Invalid direction " + n3);
                }
                kara.setDirection(n3);
                if (!world.canPutObjectAt(kara, n, n2)) {
                    throw new Exception("Invalid kara / other object combination.");
                }
            } else {
                throw new WorldInternalException("language/$language/iomessages/invalidactorname");
            }
            world.putObjectAt(kara, n, n2);
        }
    }

    public static WorldBuilderInterface getInstance() {
        if (instance == null) {
            instance = new WorldBuilder();
        }
        return instance;
    }
}

