/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.karaide;

import ch.karatojava.kapps.actorfsm.ActorTypeInterface;
import ch.karatojava.kapps.actorfsm.CommandTypeInterface;
import ch.karatojava.kapps.actorfsm.SensorTypeInterface;
import ch.karatojava.kapps.karaide.CommandType;
import ch.karatojava.kapps.karaide.Kara;
import ch.karatojava.kapps.karaide.SensorType;
import ch.karatojava.util.Configuration;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class KaraActorType
implements ActorTypeInterface {
    protected CommandType[] commands;
    protected List<SensorTypeInterface> sensors;
    protected Hashtable<String, CommandType> commandNames;
    protected Hashtable<String, Integer> systemSensorIndices;
    protected List<SensorTypeInterface> systemSensors;
    protected static KaraActorType instance;

    protected KaraActorType() {
        this.createCommands();
        this.createSensors();
    }

    public static KaraActorType getInstance() {
        if (instance == null) {
            instance = new KaraActorType();
        }
        return instance;
    }

    @Override
    public SensorTypeInterface[] getSensors() {
        SensorTypeInterface[] sensorTypeInterfaceArray = new SensorTypeInterface[this.sensors.size()];
        for (int i = 0; i < this.sensors.size(); ++i) {
            sensorTypeInterfaceArray[i] = this.sensors.get(i);
        }
        return sensorTypeInterfaceArray;
    }

    @Override
    public SensorTypeInterface[] getSystemSensors() {
        SensorTypeInterface[] sensorTypeInterfaceArray = new SensorTypeInterface[this.systemSensors.size()];
        for (int i = 0; i < this.systemSensors.size(); ++i) {
            sensorTypeInterfaceArray[i] = this.systemSensors.get(i);
        }
        return sensorTypeInterfaceArray;
    }

    public Class getKaraActorClass() {
        return Kara.class;
    }

    @Override
    public CommandTypeInterface[] getCommands() {
        return (CommandTypeInterface[])this.commands.clone();
    }

    public CommandTypeInterface getCommand(String string) {
        return this.commandNames.get(string);
    }

    @Override
    public boolean addSystemSensor(String string) {
        if (this.systemSensorIndices.containsKey(string)) {
            int n = this.systemSensorIndices.get(string);
            this.sensors.add(this.systemSensors.get(n));
            return true;
        }
        return false;
    }

    @Override
    public void addSensorTypeInterface(SensorTypeInterface sensorTypeInterface) {
        if (!this.sensors.contains(sensorTypeInterface)) {
            this.sensors.add(sensorTypeInterface);
        }
    }

    @Override
    public void removeSensorTypeInterface(SensorTypeInterface sensorTypeInterface) {
        this.sensors.remove(sensorTypeInterface);
    }

    @Override
    public void removeAllSensors() {
        this.sensors = new ArrayList<SensorTypeInterface>();
    }

    @Override
    public void resetSensors() {
        this.sensors = new ArrayList<SensorTypeInterface>();
        for (int i = 0; i < this.systemSensors.size(); ++i) {
            this.sensors.add(this.systemSensors.get(i));
        }
    }

    protected void createCommands() {
        String string = Configuration.getInstance().getString("karamodel/$karamodel/commands");
        List<String> list = Configuration.split(string, ",");
        this.commandNames = new Hashtable();
        this.commands = new CommandType[list.size()];
        for (int i = 0; i < this.commands.length; ++i) {
            this.commands[i] = new CommandType(list.get(i));
            this.commandNames.put(this.commands[i].getName(), this.commands[i]);
        }
    }

    protected void createSensors() {
        String string = Configuration.getInstance().getString("karamodel/$karamodel/sensors");
        List<String> list = Configuration.split(string, ",");
        this.systemSensorIndices = new Hashtable();
        this.systemSensors = new ArrayList<SensorTypeInterface>();
        this.sensors = new ArrayList<SensorTypeInterface>();
        for (int i = 0; i < list.size(); ++i) {
            SensorType sensorType = new SensorType(list.get(i));
            sensorType.setIdentifier(sensorType.getName());
            this.sensors.add(sensorType);
            this.systemSensors.add(sensorType);
            this.systemSensorIndices.put(sensorType.getName(), new Integer(i));
        }
    }
}

