/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.karaide;

import ch.karatojava.kapps.karaide.KaraException;
import ch.karatojava.kapps.karaide.worldobjects.LEAF;
import ch.karatojava.kapps.karaide.worldobjects.MUSHROOM;
import ch.karatojava.kapps.karaide.worldobjects.TREE;
import ch.karatojava.kapps.world.World;
import ch.karatojava.kapps.world.WorldField;
import ch.karatojava.kapps.world.WorldObject;
import ch.karatojava.kapps.world.WorldObjectInterface;
import ch.karatojava.util.Configuration;
import java.awt.Image;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.ImageIcon;

public class Kara
extends WorldObject {
    protected int x;
    protected int y;
    protected int direction = 3;
    protected World world = null;
    protected String identity;
    protected int integerIdentifier = -1;
    protected ImageIcon paintedImage;
    protected ImageIcon[] karaImages;
    protected static Hashtable<String, Kara> karaIdentities = new Hashtable();
    protected static List<Kara> karas = new ArrayList<Kara>();

    public Kara(String string) {
        this.identity = string;
        this.type = 8;
        this.createKaraImages();
    }

    public Kara(String string, int n) {
        this(string);
        this.integerIdentifier = n;
    }

    public Kara(Kara kara) {
        this(kara.identity, kara.integerIdentifier);
        this.direction = kara.direction;
        this.x = kara.x;
        this.y = kara.y;
        this.guiID = kara.guiID;
        this.clientProperties = kara.clientProperties;
    }

    public Object clone() {
        return new Kara(this);
    }

    public Image[] getKaraImages() {
        Image[] imageArray = new Image[this.karaImages.length];
        for (int i = 0; i < this.karaImages.length; ++i) {
            imageArray[i] = this.karaImages[i].getImage();
        }
        return imageArray;
    }

    public ImageIcon[] getKaraImageIcons() {
        return (ImageIcon[])this.karaImages.clone();
    }

    @Override
    public int getGUIID() {
        return this.guiID + this.direction;
    }

    public ImageIcon getPaintedImage() {
        if (this.paintedImage == null) {
            this.paintedImage = Configuration.getInstance().getImageIcon("schemes/ladybugscheme/" + this.identity + "/paintedicon");
        }
        return this.paintedImage;
    }

    protected void createKaraImages() {
        String[] stringArray = this.getKaraImageKeys();
        this.karaImages = new ImageIcon[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.karaImages[i] = Configuration.getInstance().getImageIcon(stringArray[i]);
        }
    }

    public final String[] getKaraImageKeys() {
        return new String[]{"schemes/ladybugscheme/" + this.identity + "/north", "schemes/ladybugscheme/" + this.identity + "/west", "schemes/ladybugscheme/" + this.identity + "/south", "schemes/ladybugscheme/" + this.identity + "/east"};
    }

    @Override
    public boolean canCombineWith(WorldObjectInterface worldObjectInterface) {
        boolean bl = worldObjectInterface.getType() != 1 && worldObjectInterface.getType() != 4 && worldObjectInterface.getType() != 8;
        return bl;
    }

    @Override
    public boolean equals(WorldObjectInterface worldObjectInterface) {
        boolean bl = worldObjectInterface != null && worldObjectInterface.getType() == this.getType() && this.getIdentity().equals(((Kara)worldObjectInterface).getIdentity());
        return bl;
    }

    @Override
    public WorldObjectInterface mergeWith(WorldObjectInterface worldObjectInterface) {
        return null;
    }

    @Override
    public WorldObjectInterface detach(WorldObjectInterface worldObjectInterface) {
        return null;
    }

    @Override
    public WorldObjectInterface cloneWorldObject() {
        return new Kara(this);
    }

    @Override
    public synchronized void setObjectPosition(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    @Override
    public synchronized void setObjectWorld(World world) {
        Kara kara = Kara.findKaraInWorld(world, this.identity);
        if (kara != null && kara != this) {
            world.removeObjectAt(kara, kara.getPosition().x, kara.getPosition().y);
        }
        this.world = world;
    }

    @Override
    public void removedFromWorld() {
        this.world = null;
        this.x = -1;
        this.y = -1;
    }

    public static Kara findKaraInWorld(World world, String string) {
        List<WorldField> list = world.getObjectFieldsVector();
        for (WorldField worldField : list) {
            Kara kara = (Kara)worldField.getObjectByType(8);
            if (kara == null || !kara.getIdentity().equalsIgnoreCase(string)) continue;
            return kara;
        }
        return null;
    }

    public static void addKaraPrototype(Kara kara) {
        karaIdentities.put(kara.getIdentity(), kara);
        karas.add(kara);
    }

    public static Kara[] getKaras() {
        Kara[] karaArray = new Kara[karas.size()];
        for (int i = 0; i < karaArray.length; ++i) {
            karaArray[i] = karas.get(i);
        }
        return karaArray;
    }

    public static Kara getKara(String string) {
        return karaIdentities.get(string);
    }

    public static boolean isLegalDirection(int n) {
        return n >= 0 && n <= 3;
    }

    public synchronized void setDirection(int n) {
        this.direction = n;
        if (this.world != null) {
            this.world.fireWorldObjectChangedEvent(this);
        }
    }

    public synchronized void setPosition(int n, int n2) {
        int n3 = this.x;
        int n4 = this.y;
        this.x = n;
        this.y = n2;
        this.world.moveObjectAt(this, n3, n4, n, n2);
    }

    public synchronized World getWorld() {
        return this.world;
    }

    public synchronized Point getPosition() {
        return new Point(this.x, this.y);
    }

    public synchronized int getDirection() {
        return this.direction;
    }

    public String getIdentity() {
        return this.identity;
    }

    public int getIntegerIdentifier() {
        return this.integerIdentifier;
    }

    public synchronized boolean onLeaf() {
        return this.world.isObjectOfTypeAt(LEAF.getInstance(), this.x, this.y);
    }

    public synchronized boolean timeSensor(Object[] objectArray) {
        Integer n = (Integer)objectArray[0];
        return n.intValue() == this.world.getWorldTime();
    }

    public synchronized boolean treeFront() {
        return this.world.isObjectOfTypeAt(TREE.getInstance(), this.nextX(), this.nextY());
    }

    public synchronized boolean treeLeft() {
        return this.world.isObjectOfTypeAt(TREE.getInstance(), this.nextX(this.x, (this.direction + 1) % 4), this.nextY(this.y, (this.direction + 1) % 4));
    }

    public synchronized boolean treeRight() {
        return this.world.isObjectOfTypeAt(TREE.getInstance(), this.nextX(this.x, (this.direction + 3) % 4), this.nextY(this.y, (this.direction + 3) % 4));
    }

    public synchronized boolean mushroomFront() {
        return this.world.isObjectOfTypeAt(MUSHROOM.getInstance(), this.nextX(), this.nextY());
    }

    public synchronized boolean karafront() {
        return this.world.isObjectOfTypeAt(this, this.nextX(), this.nextY());
    }

    public synchronized void turnLeft() {
        int n = (this.direction + 1) % 4;
        this.setDirection(n);
    }

    public synchronized void turnRight() {
        int n = (this.direction + 3) % 4;
        this.setDirection(n);
    }

    public synchronized void move() throws KaraException {
        this.assertCanMove();
        int n = this.nextX();
        int n2 = this.nextY();
        if (this.mushroomFront()) {
            this.world.moveObjectAt(MUSHROOM.getInstance(), n, n2, this.nextX(n, this.direction), this.nextY(n2, this.direction));
        }
        int n3 = this.x;
        int n4 = this.y;
        this.x = n;
        this.y = n2;
        this.world.moveObjectAt(this, n3, n4, this.x, this.y);
    }

    public synchronized void putLeaf() throws KaraException {
        if (this.world.isObjectOfTypeAt(LEAF.getInstance(), this.x, this.y)) {
            String[] stringArray = new String[]{Configuration.getInstance().getString("schemes/ladybugscheme/" + this.getIdentity() + "/description/$language")};
            throw new KaraException("language/$language/kawomodel/karaexception/alreadypainted", stringArray, (ImageIcon)this.getClientProperty("imageicon"));
        }
        this.world.putObjectAt(LEAF.getInstance(this.integerIdentifier), this.x, this.y);
    }

    public synchronized void removeLeaf() throws KaraException {
        if (!this.world.isObjectOfTypeAt(LEAF.getInstance(), this.x, this.y)) {
            String[] stringArray = new String[]{Configuration.getInstance().getString("schemes/ladybugscheme/" + this.getIdentity() + "/description/$language")};
            throw new KaraException("language/$language/kawomodel/karaexception/notpainted", stringArray, (ImageIcon)this.getClientProperty("imageicon"));
        }
        this.world.removeObjectOfSameTypeAt(LEAF.getInstance(), this.x, this.y);
    }

    public boolean isVisibleToKara(int n, int n2) {
        if (this.x == n && this.y == n2) {
            return true;
        }
        if (n == this.nextX() && n2 == this.nextY()) {
            boolean bl = this.world.isObjectOfTypeAt(MUSHROOM.getInstance(), n, n2);
            boolean bl2 = this.world.isObjectAt(TREE.getInstance(), n, n2);
            return bl || bl2;
        }
        if (n == this.nextX(this.x, (this.direction + 1) % 4) && n2 == this.nextY(this.y, (this.direction + 1) % 4)) {
            return this.world.isObjectAt(TREE.getInstance(), n, n2);
        }
        if (n == this.nextX(this.x, (this.direction + 3) % 4) && n2 == this.nextY(this.y, (this.direction + 3) % 4)) {
            return this.world.isObjectAt(TREE.getInstance(), n, n2);
        }
        return false;
    }

    protected int scale(int n) {
        return ((n & 2) >> 1) * 2 - 1;
    }

    protected int nextX() {
        return (this.direction & 1) == 1 ? (this.x + this.scale(this.direction) + this.world.getSizeX()) % this.world.getSizeX() : this.x;
    }

    protected int nextX(int n, int n2) {
        return (n2 & 1) == 1 ? (n + this.scale(n2) + this.world.getSizeX()) % this.world.getSizeX() : n;
    }

    protected int nextY() {
        return (this.direction & 1) == 0 ? (this.y + this.scale(this.direction) + this.world.getSizeY()) % this.world.getSizeY() : this.y;
    }

    protected int nextY(int n, int n2) {
        return (n2 & 1) == 0 ? (n + this.scale(n2) + this.world.getSizeY()) % this.world.getSizeY() : n;
    }

    protected synchronized void assertCanMove() throws KaraException {
        int n;
        int n2;
        int n3 = this.nextX();
        int n4 = this.nextY();
        String[] stringArray = new String[]{Configuration.getInstance().getString("schemes/ladybugscheme/" + this.getIdentity() + "/description/$language")};
        if (this.world.isObjectOfTypeAt(this, n3, n4)) {
            throw new KaraException("language/$language/kawomodel/karaexception/karainfront", stringArray, (ImageIcon)this.getClientProperty("imageicon"));
        }
        if (this.world.isObjectOfTypeAt(TREE.getInstance(), n3, n4)) {
            throw new KaraException("language/$language/kawomodel/karaexception/wallinfront", stringArray, (ImageIcon)this.getClientProperty("imageicon"));
        }
        if (this.world.isObjectOfTypeAt(MUSHROOM.getInstance(), n3, n4) && (this.world.isObjectOfTypeAt(this, n2 = this.nextX(n3, this.direction), n = this.nextY(n4, this.direction)) || this.world.isObjectOfTypeAt(TREE.getInstance(), n2, n) || this.world.isObjectOfTypeAt(MUSHROOM.getInstance(), n2, n))) {
            throw new KaraException("language/$language/kawomodel/karaexception/cantmoveobject", stringArray, (ImageIcon)this.getClientProperty("imageicon"));
        }
    }

    public String toString() {
        return "K" + this.hashCode();
    }
}

