/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.actorfsm.editor.statetableeditor;

import ch.karatojava.kapps.actorfsm.SensorTypeInterface;
import ch.karatojava.kapps.actorfsm.Transition;
import ch.karatojava.kapps.actorfsm.editor.statetableeditor.StateTableEditor;
import ch.karatojava.kapps.actorfsm.editor.statetableeditor.TransitionRow;
import ch.karatojava.util.Configuration;
import ch.karatojava.util.GuiFactory;
import ch.karatojava.util.gui.rieditor.DefaultRowUi;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;

public class TransitionRowUi
extends DefaultRowUi {
    private static final long serialVersionUID = 1L;
    public static final int DELETE_BUTTON_WIDTH = 14;
    protected static final EmptyBorder DELETE_BUTTON_BORDER = new EmptyBorder(0, 2, 2, 3);
    protected Vector nextStateNames;
    protected JComboBox nextStateName;
    protected Transition transition;
    private JLabel[] labels;
    protected int highlightedCommand;
    protected boolean updatingNextStateName;
    protected MouseAdapter sensorListener = new MouseAdapter(){
        private JLabel label;

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.label = (JLabel)mouseEvent.getSource();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.label.contains(mouseEvent.getPoint())) {
                SensorTypeInterface sensorTypeInterface = (SensorTypeInterface)this.label.getClientProperty(TransitionRowUi.SENSOR_PROPERTY);
                int n = TransitionRowUi.this.transition.getSensorInput(sensorTypeInterface);
                n = (n + 4) % 3;
                TransitionRowUi.this.transition.setSensorInput(sensorTypeInterface, n);
                this.label.setIcon(VALUE_ICONS[n]);
            }
            this.label = null;
        }
    };
    protected ActionListener deleteListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TransitionRowUi.this.getRow().getRowItemModel().removeRow(TransitionRowUi.this.getRow());
        }
    };
    protected static final ImageIcon[] VALUE_ICONS = new ImageIcon[3];
    protected static final String SENSOR_PROPERTY = "sensor property";

    public TransitionRowUi(TransitionRow transitionRow, Vector vector) {
        super(transitionRow);
        this.nextStateNames = vector;
        this.highlightedCommand = -2;
    }

    public void updateNextStateName() {
        this.updatingNextStateName = true;
        this.nextStateName.setModel(new DefaultComboBoxModel(this.nextStateNames));
        this.nextStateName.setSelectedItem(this.transition.getTo().getName());
        this.updatingNextStateName = false;
    }

    public void updateSensorValues() {
        for (int i = 0; i < this.labels.length; ++i) {
            SensorTypeInterface sensorTypeInterface = (SensorTypeInterface)this.labels[i].getClientProperty(SENSOR_PROPERTY);
            int n = this.transition.getSensorInput(sensorTypeInterface);
            this.labels[i].setIcon(VALUE_ICONS[n]);
        }
    }

    public void highlight(int n) {
        if (this.highlightedCommand != n) {
            this.checkDehighlightCommand();
            if (n >= 0) {
                JComponent jComponent = (JComponent)((Object)this.getItemUi(n));
                jComponent.setOpaque(true);
                jComponent.setBackground(StateTableEditor.COMMAND_HIGHLIGHT_COLOR);
                this.setOpaque(true);
                this.setBackground(StateTableEditor.TRANSITION_HIGHLIGHT_COLOR);
            } else if (n == -1) {
                this.setOpaque(true);
                this.setBackground(StateTableEditor.TRANSITION_HIGHLIGHT_COLOR);
            }
            this.highlightedCommand = n;
        }
    }

    private void checkDehighlightCommand() {
        if (this.highlightedCommand >= 0) {
            JComponent jComponent = (JComponent)((Object)this.getItemUi(this.highlightedCommand));
            jComponent.setOpaque(false);
            jComponent.setBackground(this.getParent().getBackground());
        }
        this.highlightedCommand = -2;
    }

    public void dehighlight() {
        this.checkDehighlightCommand();
        this.setOpaque(false);
        this.setBackground(this.getParent().getBackground());
    }

    protected JComponent createDeleteButton() {
        JButton jButton = new JButton(Configuration.getInstance().getImageIcon("icons/rowdelete"));
        jButton.addActionListener(this.deleteListener);
        jButton.setBorder(DELETE_BUTTON_BORDER);
        jButton.setContentAreaFilled(false);
        jButton.setAlignmentY(1.0f);
        return jButton;
    }

    @Override
    protected Component[] createHeaderComponents() {
        this.transition = ((TransitionRow)this.getRow()).getTransition();
        SensorTypeInterface[] sensorTypeInterfaceArray = this.transition.getFrom().getSensors();
        this.labels = new JLabel[sensorTypeInterfaceArray.length];
        Component[] componentArray = new Component[1 + sensorTypeInterfaceArray.length * 3];
        componentArray[0] = this.createDeleteButton();
        for (int i = 0; i < this.labels.length; ++i) {
            this.labels[i] = new JLabel(VALUE_ICONS[this.transition.getSensorInput(sensorTypeInterfaceArray[i])]);
            this.labels[i].addMouseListener(this.sensorListener);
            this.labels[i].putClientProperty(SENSOR_PROPERTY, sensorTypeInterfaceArray[i]);
            int n = sensorTypeInterfaceArray[i].getIcon().getIconWidth();
            int n2 = VALUE_ICONS[0].getIconWidth();
            int n3 = 1 + (n - n2) / 2;
            int n4 = n3 + (n - n2) % 2;
            Dimension dimension = new Dimension(n3, 0);
            Dimension dimension2 = new Dimension(n4, 0);
            componentArray[1 + 3 * i + 0] = Box.createRigidArea(dimension);
            componentArray[1 + 3 * i + 1] = this.labels[i];
            componentArray[1 + 3 * i + 2] = Box.createRigidArea(dimension2);
        }
        return componentArray;
    }

    @Override
    protected Component[] createFooterComponents() {
        this.nextStateName = new JComboBox(this.nextStateNames);
        this.nextStateName.setSelectedItem(this.transition.getTo().getName());
        this.nextStateName.setMinimumSize(StateTableEditor.MAX_NEXT_STATE_SIZE);
        this.nextStateName.setPreferredSize(StateTableEditor.MAX_NEXT_STATE_SIZE);
        this.nextStateName.setMaximumSize(StateTableEditor.MAX_NEXT_STATE_SIZE);
        this.nextStateName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                if (!TransitionRowUi.this.updatingNextStateName && (string = (String)TransitionRowUi.this.nextStateName.getSelectedItem()) != null) {
                    TransitionRowUi.this.transition.setTo(TransitionRowUi.this.transition.getFrom().getStateMachine().getState(string));
                }
            }
        });
        return new Component[]{this.nextStateName};
    }

    static {
        if (GuiFactory.instanceCreated()) {
            TransitionRowUi.VALUE_ICONS[0] = GuiFactory.getInstance().createImageIcon("icons/statetable/dontcare");
            TransitionRowUi.VALUE_ICONS[1] = GuiFactory.getInstance().createImageIcon("icons/statetable/one");
            TransitionRowUi.VALUE_ICONS[2] = GuiFactory.getInstance().createImageIcon("icons/statetable/zero");
        }
    }
}

