/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.actorfsm.editor.statetableeditor;

import ch.karatojava.kapps.actorfsm.ActorFsmListener;
import ch.karatojava.kapps.actorfsm.ActorTypeInterface;
import ch.karatojava.kapps.actorfsm.CommandTypeInterface;
import ch.karatojava.kapps.actorfsm.SensorTypeInterface;
import ch.karatojava.kapps.actorfsm.State;
import ch.karatojava.kapps.actorfsm.StateMachine;
import ch.karatojava.kapps.actorfsm.Transition;
import ch.karatojava.kapps.actorfsm.editor.ActorFsmEditorUiFactory;
import ch.karatojava.kapps.actorfsm.editor.UpdateState;
import ch.karatojava.kapps.actorfsm.editor.statetableeditor.CommandItem;
import ch.karatojava.kapps.actorfsm.editor.statetableeditor.CommandsPanel;
import ch.karatojava.kapps.actorfsm.editor.statetableeditor.StateEditorUiFactory;
import ch.karatojava.kapps.actorfsm.editor.statetableeditor.StateRowItemModel;
import ch.karatojava.kapps.actorfsm.editor.statetableeditor.TransitionRow;
import ch.karatojava.kapps.actorfsm.editor.statetableeditor.TransitionRowUi;
import ch.karatojava.util.gui.FixedJTabbedPane;
import ch.karatojava.util.gui.dndpanel.DndPanel;
import ch.karatojava.util.gui.rieditor.AbstractRowItemUiFactory;
import ch.karatojava.util.gui.rieditor.RowItemEditor;
import ch.karatojava.util.gui.rieditor.RowItemModelInterface;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class StateTableEditor
extends DndPanel {
    private static final long serialVersionUID = 1L;
    public static final Color TABBED_PANE_UNSELECTED_COLOR = new Color(200, 200, 200);
    protected static final int MAX_POOL_SIZE = 5;
    public static final Dimension MAX_NEXT_STATE_SIZE = new Dimension(110, 32);
    public static final Color TRANSITION_HIGHLIGHT_COLOR = new Color(240, 240, 150);
    public static final Color COMMAND_HIGHLIGHT_COLOR = new Color(255, 170, 100);
    protected static final String TABBED_INDEX_PROPERTY = "tabbed pane index property; associates row item editor with the index of the tabbed pane in which it is displayed";
    protected ActorFsmListener fsmListener = new ActorFsmListener.Adapter(){

        @Override
        public void stateMachineClear(StateMachine stateMachine) {
            StateTableEditor.this.removeAllStates();
        }

        @Override
        public void stateAdded(State state) {
            StateTableEditor.this.addState(StateTableEditor.this.tabbedPane.getTabCount(), state);
        }

        @Override
        public void stateRemoved(State state, State state2) {
            StateTableEditor.this.removeState(state);
        }

        @Override
        public void transitionAdded(Transition transition) {
            if (!StateTableEditor.this.updateState.isViewModelUpdated()) {
                State state = transition.getFrom();
                int n = state.indexOf(transition);
                StateRowItemModel stateRowItemModel = StateTableEditor.this.stateRowItemModels.get(state);
                TransitionRow transitionRow = new TransitionRow(stateRowItemModel, transition, StateTableEditor.this.updateState);
                StateTableEditor.this.updateState.setDataModelState(true);
                stateRowItemModel.addRow(transitionRow, n);
                StateTableEditor.this.updateState.setDataModelState(false);
            }
        }

        @Override
        public void transitionRemoved(Transition transition, int n) {
            if (!StateTableEditor.this.updateState.isViewModelUpdated()) {
                StateTableEditor.this.updateState.setDataModelState(true);
                State state = transition.getFrom();
                StateRowItemModel stateRowItemModel = StateTableEditor.this.stateRowItemModels.get(state);
                stateRowItemModel.removeRow(stateRowItemModel.get(n));
                StateTableEditor.this.updateState.setDataModelState(false);
            }
        }

        @Override
        public void setDescription(State state) {
        }

        @Override
        public void setName(State state, String string) {
            RowItemEditor rowItemEditor = StateTableEditor.this.getRowItemEditor(state);
            StateTableEditor.this.nextStateNames.remove(string);
            StateTableEditor.this.addNextStateName(state.getName());
            if (!state.isFinalState()) {
                int n = StateTableEditor.this.getTabIndex(rowItemEditor);
                StateTableEditor.this.tabbedPane.setTitleAt(n, "  " + state.getName() + "  ");
            }
        }

        @Override
        public void setSensors(State state) {
            int n = StateTableEditor.this.getTabIndex(StateTableEditor.this.getRowItemEditor(state));
            StateTableEditor.this.removeState(state);
            StateTableEditor.this.addState(n, state);
            StateTableEditor.this.setSelectedState(state);
        }

        protected TransitionRowUi getTransitionRowUi(Transition transition) {
            State state = transition.getFrom();
            int n = state.indexOf(transition);
            RowItemEditor rowItemEditor = StateTableEditor.this.getRowItemEditor(state);
            return (TransitionRowUi)rowItemEditor.getRowUi(n);
        }

        @Override
        public void transitionInputChanged(Transition transition, SensorTypeInterface sensorTypeInterface, int n) {
            if (!StateTableEditor.this.updateState.isViewModelUpdated()) {
                StateTableEditor.this.updateState.setDataModelState(true);
                this.getTransitionRowUi(transition).updateSensorValues();
                StateTableEditor.this.updateState.setDataModelState(false);
            }
        }

        @Override
        public void transitionToChanged(Transition transition, State state) {
            if (!StateTableEditor.this.updateState.isViewModelUpdated()) {
                StateTableEditor.this.updateState.setDataModelState(true);
                this.getTransitionRowUi(transition).updateNextStateName();
                StateTableEditor.this.updateState.setDataModelState(false);
            }
        }

        protected TransitionRow getTransitionRow(Transition transition) {
            State state = transition.getFrom();
            int n = state.indexOf(transition);
            StateRowItemModel stateRowItemModel = StateTableEditor.this.stateRowItemModels.get(state);
            return (TransitionRow)stateRowItemModel.get(n);
        }

        @Override
        public void transitionCommandAdded(Transition transition, int n) {
            if (!StateTableEditor.this.updateState.isViewModelUpdated()) {
                StateTableEditor.this.updateState.setDataModelState(true);
                TransitionRow transitionRow = this.getTransitionRow(transition);
                transitionRow.addItem(new CommandItem(transition.getCommand(n), transitionRow), n);
                StateTableEditor.this.updateState.setDataModelState(false);
            }
        }

        @Override
        public void transitionCommandRemoved(Transition transition, CommandTypeInterface commandTypeInterface, int n) {
            if (!StateTableEditor.this.updateState.isViewModelUpdated()) {
                StateTableEditor.this.updateState.setDataModelState(true);
                TransitionRow transitionRow = this.getTransitionRow(transition);
                transitionRow.removeItem(transitionRow.get(n));
                StateTableEditor.this.updateState.setDataModelState(false);
            }
        }

        @Override
        public void transitionCommandsSet(Transition transition) {
            if (!StateTableEditor.this.updateState.isViewModelUpdated()) {
                StateTableEditor.this.updateState.setDataModelState(true);
                TransitionRow transitionRow = this.getTransitionRow(transition);
                int n = transition.size();
                for (int i = 0; i < n; ++i) {
                    transitionRow.addItem(new CommandItem(transition.getCommand(i), transitionRow));
                }
                StateTableEditor.this.updateState.setDataModelState(false);
            }
        }
    };
    protected ChangeListener tabbedPaneChangeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            StateTableEditor.this.setSelectedState(StateTableEditor.this.getSelectedState());
        }
    };
    protected TransitionRowUi highlightRowUi;
    protected UpdateState updateState;
    protected StateMachine stateMachine;
    protected JTabbedPane tabbedPane;
    protected AbstractRowItemUiFactory.Clipboard clipboard;
    protected Vector<String> nextStateNames;
    protected Hashtable<State, StateRowItemModel> stateRowItemModels;
    protected ChangeListener changeListener;
    protected ArrayList<StateEditorUiFactory> factoryPool;
    protected Hashtable<State, StateEditorUiFactory> currentFactories;
    protected State selectedState;
    protected ActorFsmEditorUiFactory uiFactory;

    public StateTableEditor(ActorFsmEditorUiFactory actorFsmEditorUiFactory, ActorTypeInterface actorTypeInterface) {
        this.uiFactory = actorFsmEditorUiFactory;
        CommandsPanel commandsPanel = new CommandsPanel(actorTypeInterface);
        this.addThisMouseInputListener(commandsPanel);
        this.tabbedPane = new FixedJTabbedPane();
        this.setLayout(new BorderLayout());
        this.add((Component)commandsPanel, "West");
        this.add((Component)this.tabbedPane, "Center");
        this.clipboard = new AbstractRowItemUiFactory.Clipboard();
        this.updateState = new UpdateState();
        this.nextStateNames = new Vector();
        this.stateRowItemModels = new Hashtable();
        this.factoryPool = new ArrayList();
        this.currentFactories = new Hashtable();
    }

    protected void removeAllStates() {
        this.remove(this.tabbedPane);
        this.tabbedPane = new FixedJTabbedPane();
        this.tabbedPane.addChangeListener(this.changeListener);
        this.tabbedPane.addChangeListener(this.tabbedPaneChangeListener);
        this.add((Component)this.tabbedPane, "Center");
        if (this.stateMachine != null) {
            State[] stateArray = this.stateMachine.getStates();
            for (int i = 0; i < stateArray.length; ++i) {
                if (stateArray[i].isFinalState()) continue;
                this.poolFactory(stateArray[i]);
            }
        }
        this.nextStateNames.clear();
        this.stateRowItemModels.clear();
    }

    protected void addNextStateName(String string) {
        this.nextStateNames.add(string);
        Enumeration<StateRowItemModel> enumeration = this.stateRowItemModels.elements();
        while (enumeration.hasMoreElements()) {
            StateRowItemModel stateRowItemModel = enumeration.nextElement();
            RowItemEditor rowItemEditor = stateRowItemModel.getRowItemEditor();
            int n = rowItemEditor.rowCount();
            for (int i = 0; i < n; ++i) {
                TransitionRowUi transitionRowUi = (TransitionRowUi)rowItemEditor.getRowUi(i);
                transitionRowUi.updateNextStateName();
            }
        }
    }

    protected void updateTabbedIndexProperties() {
        int n = this.tabbedPane.getTabCount();
        for (int i = 0; i < n; ++i) {
            JScrollPane jScrollPane = (JScrollPane)this.tabbedPane.getComponentAt(i);
            RowItemEditor rowItemEditor = (RowItemEditor)jScrollPane.getViewport().getView();
            rowItemEditor.putClientProperty(TABBED_INDEX_PROPERTY, new Integer(i));
        }
    }

    protected void poolFactory(State state) {
        StateEditorUiFactory stateEditorUiFactory = this.currentFactories.remove(state);
        if (this.factoryPool.size() < 5) {
            this.factoryPool.add(stateEditorUiFactory);
        }
    }

    protected StateEditorUiFactory createFactory(State state) {
        StateEditorUiFactory stateEditorUiFactory;
        if (this.factoryPool.size() > 0) {
            stateEditorUiFactory = this.factoryPool.remove(0);
            stateEditorUiFactory.setState(state);
        } else {
            stateEditorUiFactory = this.uiFactory.createStateEditorUiFactory(state, this.nextStateNames, this.clipboard);
        }
        this.currentFactories.put(state, stateEditorUiFactory);
        return stateEditorUiFactory;
    }

    protected void addState(int n, State state) {
        String string = state.getName();
        this.addNextStateName(string);
        if (!state.isFinalState()) {
            StateEditorUiFactory stateEditorUiFactory = this.createFactory(state);
            RowItemEditor rowItemEditor = new RowItemEditor(stateEditorUiFactory);
            StateRowItemModel stateRowItemModel = new StateRowItemModel(state, this.updateState);
            rowItemEditor.setRowItemModel(stateRowItemModel);
            stateEditorUiFactory.setRowItemEditor(rowItemEditor);
            this.addThisMouseInputListener(rowItemEditor);
            this.addThisMouseInputListenerToChildren(rowItemEditor);
            JScrollPane jScrollPane = new JScrollPane(rowItemEditor);
            this.tabbedPane.add((Component)jScrollPane, n);
            this.tabbedPane.setTitleAt(n, "  " + string + "  ");
            this.stateRowItemModels.put(state, stateRowItemModel);
            this.updateTabbedIndexProperties();
            this.setSelectedState(state);
        }
    }

    protected void removeState(State state) {
        RowItemEditor rowItemEditor = this.getRowItemEditor(state);
        int n = this.tabbedPane.getTabCount();
        for (int i = 0; i < n; ++i) {
            JScrollPane jScrollPane = (JScrollPane)this.tabbedPane.getComponentAt(i);
            Component component = jScrollPane.getViewport().getView();
            if (component != rowItemEditor) continue;
            this.tabbedPane.remove(jScrollPane);
            break;
        }
        if (this.selectedState == state) {
            this.selectedState = null;
        }
        this.nextStateNames.remove(state.getName());
        this.stateRowItemModels.remove(state);
        this.poolFactory(state);
        this.updateTabbedIndexProperties();
        this.tabbedPane.setSelectedIndex(-1);
    }

    public void setStateMachine(StateMachine stateMachine) {
        this.removeAllStates();
        this.clipboard.setClipboardRow(null);
        this.stateMachine = stateMachine;
        stateMachine.addActorFsmListener(this.fsmListener);
        State[] stateArray = stateMachine.getStates();
        int n = 0;
        for (int i = 0; i < stateArray.length; ++i) {
            this.addState(n, stateArray[i]);
            if (stateArray[i].isFinalState()) continue;
            ++n;
        }
    }

    public void setSelectedState(State state) {
        if (state != null && !state.isFinalState()) {
            RowItemModelInterface rowItemModelInterface;
            if (state != this.selectedState && (rowItemModelInterface = (RowItemModelInterface)this.stateRowItemModels.get(state)) != null) {
                int n = this.getTabIndex(rowItemModelInterface.getRowItemEditor());
                System.out.println("state=" + state.getName());
                System.out.println("tabIndex=" + n);
                System.out.println(" tabbedPane.getSelectedIndex()=" + this.tabbedPane.getSelectedIndex());
                if (n < this.tabbedPane.getTabCount() && n != this.tabbedPane.getSelectedIndex()) {
                    this.tabbedPane.setSelectedIndex(n);
                }
                this.selectedState = state;
            }
        } else {
            this.tabbedPane.setSelectedIndex(-1);
            this.selectedState = null;
        }
    }

    public State getSelectedState() {
        JScrollPane jScrollPane = (JScrollPane)this.tabbedPane.getSelectedComponent();
        if (jScrollPane != null) {
            RowItemEditor rowItemEditor = (RowItemEditor)jScrollPane.getViewport().getView();
            StateRowItemModel stateRowItemModel = (StateRowItemModel)rowItemEditor.getRowItemModel();
            return stateRowItemModel.getState();
        }
        return null;
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public void setChangeListener(ChangeListener changeListener) {
        this.changeListener = changeListener;
        this.tabbedPane.addChangeListener(changeListener);
    }

    public void highlight(State state, Transition transition, int n) {
        if (state != null && !state.isFinalState()) {
            this.setSelectedState(state);
            TransitionRowUi transitionRowUi = null;
            if (transition != null) {
                RowItemEditor rowItemEditor = this.getRowItemEditor(state);
                int n2 = state.indexOf(transition);
                transitionRowUi = (TransitionRowUi)rowItemEditor.getRowUi(n2);
            }
            if (this.highlightRowUi != null && this.highlightRowUi != transitionRowUi) {
                this.highlightRowUi.dehighlight();
            }
            this.highlightRowUi = transitionRowUi;
            if (this.highlightRowUi != null) {
                this.highlightRowUi.highlight(n);
            }
        } else if (this.highlightRowUi != null) {
            this.highlightRowUi.dehighlight();
            this.highlightRowUi = null;
        }
    }

    protected RowItemEditor getRowItemEditor(State state) {
        RowItemModelInterface rowItemModelInterface = this.stateRowItemModels.get(state);
        return rowItemModelInterface.getRowItemEditor();
    }

    protected int getTabIndex(RowItemEditor rowItemEditor) {
        return (Integer)rowItemEditor.getClientProperty(TABBED_INDEX_PROPERTY);
    }
}

