/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.actorfsm.editor.statetableeditor;

import ch.karatojava.kapps.actorfsm.State;
import ch.karatojava.kapps.actorfsm.Transition;
import ch.karatojava.kapps.actorfsm.editor.UpdateState;
import ch.karatojava.kapps.actorfsm.editor.statetableeditor.TransitionRow;
import ch.karatojava.util.gui.rieditor.DefaultRowItemModel;
import ch.karatojava.util.gui.rieditor.RowInterface;

class StateRowItemModel
extends DefaultRowItemModel {
    protected UpdateState updateState;
    protected State state;

    public StateRowItemModel(State state, UpdateState updateState) {
        this.state = state;
        this.updateState = updateState;
        Transition[] transitionArray = state.getTransitions();
        for (int i = 0; i < transitionArray.length; ++i) {
            TransitionRow transitionRow = new TransitionRow(this, transitionArray[i], updateState);
            updateState.setDataModelState(true);
            this.addRow(transitionRow);
            updateState.setDataModelState(false);
        }
    }

    public State getState() {
        return this.state;
    }

    @Override
    public void addRow(RowInterface rowInterface, int n) {
        super.addRow(rowInterface, n);
        if (!this.updateState.isDataModelUpdated()) {
            this.updateState.setViewModelState(true);
            Transition transition = ((TransitionRow)rowInterface).getTransition();
            this.state.addTransition(transition, n);
            this.updateState.setViewModelState(false);
        }
    }

    @Override
    public void removeRow(RowInterface rowInterface) {
        super.removeRow(rowInterface);
        if (!this.updateState.isDataModelUpdated()) {
            this.updateState.setViewModelState(true);
            Transition transition = ((TransitionRow)rowInterface).getTransition();
            this.state.removeTransition(transition);
            this.updateState.setViewModelState(false);
        }
    }

    @Override
    public RowInterface createRow() {
        return new TransitionRow(this, new Transition(this.state, this.state), this.updateState);
    }
}

