/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.actorfsm.editor.statetableeditor;

import ch.karatojava.kapps.actorfsm.State;
import ch.karatojava.kapps.actorfsm.editor.statetableeditor.CommandItem;
import ch.karatojava.kapps.actorfsm.editor.statetableeditor.CommandItemUi;
import ch.karatojava.kapps.actorfsm.editor.statetableeditor.StateTableEditor;
import ch.karatojava.kapps.actorfsm.editor.statetableeditor.TransitionHeaderRow;
import ch.karatojava.kapps.actorfsm.editor.statetableeditor.TransitionRow;
import ch.karatojava.kapps.actorfsm.editor.statetableeditor.TransitionRowUi;
import ch.karatojava.util.Configuration;
import ch.karatojava.util.GuiFactory;
import ch.karatojava.util.gui.rieditor.AbstractRowItemUiFactory;
import ch.karatojava.util.gui.rieditor.ItemInterface;
import ch.karatojava.util.gui.rieditor.ItemUiInterface;
import ch.karatojava.util.gui.rieditor.RowInterface;
import ch.karatojava.util.gui.rieditor.RowUiInterface;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.border.Border;

public class StateEditorUiFactory
extends AbstractRowItemUiFactory {
    private static final Border NEW_TRANSITION_BUTTON_BORDER = BorderFactory.createEmptyBorder(2, 2, 2, 2);
    protected Vector nextStateNames;
    protected State state;

    public StateEditorUiFactory(State state, Vector vector, AbstractRowItemUiFactory.Clipboard clipboard) {
        super(clipboard, false, false);
        this.state = state;
        this.nextStateNames = vector;
        GuiFactory.getInstance().addUiSwitchListener(this.onItemMenu);
        GuiFactory.getInstance().addUiSwitchListener(this.onRowMenu);
        GuiFactory.getInstance().addUiSwitchListener(this.defaultMenu);
    }

    public void setState(State state) {
        this.state = state;
    }

    @Override
    public ItemUiInterface createItemUi(ItemInterface itemInterface) {
        return new CommandItemUi((CommandItem)itemInterface);
    }

    @Override
    public RowUiInterface createRowUi(RowInterface rowInterface) {
        TransitionRowUi transitionRowUi = new TransitionRowUi((TransitionRow)rowInterface, this.nextStateNames);
        transitionRowUi.createUi(false);
        return transitionRowUi;
    }

    @Override
    public JComponent createHeader() {
        return new TransitionHeaderRow(this.state, this);
    }

    public JLabel createCommandColumnLabel() {
        JLabel jLabel = new JLabel(Configuration.getInstance().getString("language/$language/actorfsm/commandcolumnlabel"));
        return jLabel;
    }

    public JLabel createNextStateColumnLabel() {
        JLabel jLabel = new JLabel(Configuration.getInstance().getString("language/$language/actorfsm/nextstatelabel"));
        jLabel.setMinimumSize(StateTableEditor.MAX_NEXT_STATE_SIZE);
        jLabel.setPreferredSize(StateTableEditor.MAX_NEXT_STATE_SIZE);
        jLabel.setMaximumSize(StateTableEditor.MAX_NEXT_STATE_SIZE);
        return jLabel;
    }

    @Override
    protected JMenuItem createCopyRowMenuItemUi() {
        return GuiFactory.getInstance().createMenuItem("icons/copysmall", "language/$language/actorfsm/editor/statetableeditor/copyrow");
    }

    @Override
    protected JMenuItem createPasteRowMenuItemUi() {
        return GuiFactory.getInstance().createMenuItem("icons/pastesmall", "language/$language/actorfsm/editor/statetableeditor/pasterow");
    }

    @Override
    protected JMenuItem createInsertRowMenuItemUi() {
        return null;
    }

    @Override
    protected JButton createAddRowButton() {
        JButton jButton = new JButton(Configuration.getInstance().getImageIcon("icons/newtransition"));
        jButton.setBorder(NEW_TRANSITION_BUTTON_BORDER);
        return jButton;
    }
}

