/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.actorfsm.editor.statetableeditor;

import ch.karatojava.kapps.actorfsm.ActorTypeInterface;
import ch.karatojava.kapps.actorfsm.CommandTypeInterface;
import ch.karatojava.kapps.actorfsm.editor.statetableeditor.CommandItem;
import ch.karatojava.kapps.actorfsm.editor.statetableeditor.CommandItemUi;
import ch.karatojava.kapps.actorfsm.editor.statetableeditor.SteTrashLabel;
import ch.karatojava.util.gui.JGridPanel;
import ch.karatojava.util.gui.dndpanel.DndPanel;
import ch.karatojava.util.gui.dndpanel.LightweightDragDrop;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class CommandsPanel
extends JPanel
implements LightweightDragDrop {
    private static final long serialVersionUID = 1L;
    protected static final int MAX_COMMANDS_PER_COLUMN = 6;

    public CommandsPanel(ActorTypeInterface actorTypeInterface) {
        this.setBorder(BorderFactory.createEmptyBorder(68, 8, 0, 8));
        this.setLayout(new BoxLayout(this, 1));
        CommandTypeInterface[] commandTypeInterfaceArray = actorTypeInterface.getCommands();
        int n = commandTypeInterfaceArray.length > 6 ? commandTypeInterfaceArray.length / 2 : commandTypeInterfaceArray.length;
        JGridPanel jGridPanel = new JGridPanel(false, n, commandTypeInterfaceArray.length);
        for (int i = 0; i < commandTypeInterfaceArray.length; ++i) {
            CommandItemUi commandItemUi = new CommandItemUi(new CommandItem(commandTypeInterfaceArray[i], null));
            commandItemUi.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 2));
            jGridPanel.add(commandItemUi);
        }
        this.add(jGridPanel);
        this.add(Box.createVerticalGlue());
        SteTrashLabel steTrashLabel = new SteTrashLabel();
        steTrashLabel.setAlignmentX(0.5f);
        this.add(steTrashLabel);
        this.add(Box.createVerticalStrut(4));
        this.setPreferredSize(new Dimension(16 + jGridPanel.getPreferredSize().width, 50));
    }

    @Override
    public BufferedImage getDragImage(Object object) {
        return DndPanel.createBufferedImage((JComponent)object);
    }

    @Override
    public Object acceptsDrag(MouseEvent mouseEvent) {
        Component component = this.findComponentAt(mouseEvent.getPoint());
        if (component instanceof CommandItemUi) {
            return component;
        }
        return null;
    }

    @Override
    public boolean acceptsDrop(MouseEvent mouseEvent, Object object) {
        return false;
    }

    @Override
    public void dropTransferObject(MouseEvent mouseEvent, Object object) {
    }

    @Override
    public void draggingFinished(MouseEvent mouseEvent, Object object, boolean bl) {
    }
}

