/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.actorfsm.editor.fsmdiagrameditor;

import ch.ethz.fsmgui.FSMEvent;
import ch.ethz.fsmgui.FSMModelListener;
import ch.ethz.fsmgui.model.Alphabet;
import ch.ethz.fsmgui.model.FSMModelInterface;
import ch.ethz.fsmgui.model.FSMStateInterface;
import ch.karatojava.kapps.actorfsm.State;
import ch.karatojava.kapps.actorfsm.StateMachine;
import ch.karatojava.kapps.actorfsm.editor.ActorFsmEditor;
import ch.karatojava.kapps.actorfsm.editor.UpdateState;
import ch.karatojava.kapps.actorfsm.editor.fsmdiagrameditor.FsmGuiState;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;

public class FsmGuiStateMachine
implements FSMModelInterface {
    private StateMachine stateMachine;
    private UpdateState updateState;
    private Hashtable<State, FSMStateInterface> guiStates;
    private ArrayList<FSMModelListener> fsmListeners;
    private Set<FsmGuiState> allStates;
    private ActorFsmEditor fsmEditor;

    public FsmGuiStateMachine(ActorFsmEditor actorFsmEditor, StateMachine stateMachine, UpdateState updateState) {
        this.fsmEditor = actorFsmEditor;
        this.stateMachine = stateMachine;
        this.updateState = updateState;
        this.guiStates = new Hashtable();
        this.fsmListeners = new ArrayList();
        this.allStates = new HashSet<FsmGuiState>();
        State[] stateArray = stateMachine.getStates();
        for (int i = 0; i < stateArray.length; ++i) {
            FsmGuiState fsmGuiState = new FsmGuiState(this, stateArray[i], updateState);
            this.guiStates.put(stateArray[i], fsmGuiState);
        }
    }

    public FsmGuiStateMachine(FsmGuiStateMachine fsmGuiStateMachine) {
        this.updateState = new UpdateState();
        this.guiStates = new Hashtable();
        this.fsmListeners = new ArrayList();
        this.allStates = new HashSet<FsmGuiState>();
        this.stateMachine = new StateMachine(fsmGuiStateMachine.stateMachine);
        this.fsmEditor = fsmGuiStateMachine.fsmEditor;
        Enumeration<FSMStateInterface> enumeration = fsmGuiStateMachine.guiStates.elements();
        while (enumeration.hasMoreElements()) {
            FsmGuiState fsmGuiState = (FsmGuiState)enumeration.nextElement();
            State state = this.stateMachine.getState((String)fsmGuiState.getLabel());
            FsmGuiState fsmGuiState2 = new FsmGuiState(this, state, this.updateState);
            fsmGuiState2.setAccepting(fsmGuiState.isAccepting());
            fsmGuiState2.setPosition(fsmGuiState.getX(), fsmGuiState.getY());
            this.guiStates.put(state, fsmGuiState2);
        }
    }

    UpdateState getUpdateState() {
        return this.updateState;
    }

    ActorFsmEditor getActorFsmEditor() {
        return this.fsmEditor;
    }

    public StateMachine getStateMachine() {
        return this.stateMachine;
    }

    public FsmGuiState getGuiState(State state) {
        return (FsmGuiState)this.guiStates.get(state);
    }

    @Override
    public void setAlphabet(Alphabet alphabet) {
    }

    @Override
    public void setStartState(FSMStateInterface fSMStateInterface) {
        this.stateMachine.setStartState(((FsmGuiState)fSMStateInterface).getState());
        this.notifyFSMModelListeners(FSMEvent.createSetStartStateEvent(fSMStateInterface));
    }

    @Override
    public void setName(String string) {
    }

    @Override
    public FSMStateInterface getStartState() {
        State state = this.stateMachine.getStartState();
        if (state != null) {
            return this.guiStates.get(state);
        }
        return null;
    }

    @Override
    public Alphabet getAlphabet() {
        return null;
    }

    @Override
    public Set getAllStates() {
        this.allStates.clear();
        Enumeration<FSMStateInterface> enumeration = this.guiStates.elements();
        while (enumeration.hasMoreElements()) {
            this.allStates.add((FsmGuiState)enumeration.nextElement());
        }
        return this.allStates;
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public void addFSMModelListener(FSMModelListener fSMModelListener) {
        if (fSMModelListener != null && !this.fsmListeners.contains(fSMModelListener)) {
            this.fsmListeners.add(fSMModelListener);
        }
    }

    @Override
    public void removeFSMModelListener(FSMModelListener fSMModelListener) {
        if (this.fsmListeners.contains(fSMModelListener)) {
            this.fsmListeners.remove(fSMModelListener);
        }
    }

    @Override
    public void notifyFSMModelListeners(FSMEvent fSMEvent) {
        for (int i = 0; i < this.fsmListeners.size(); ++i) {
            FSMModelListener fSMModelListener = this.fsmListeners.get(i);
            fSMModelListener.notify(fSMEvent);
        }
    }

    @Override
    public void addState(FSMStateInterface fSMStateInterface) {
        State state = ((FsmGuiState)fSMStateInterface).getState();
        this.stateMachine.addState(state);
        this.guiStates.put(state, fSMStateInterface);
        this.notifyFSMModelListeners(FSMEvent.createAddStateEvent(fSMStateInterface));
    }

    @Override
    public void removeState(FSMStateInterface fSMStateInterface) {
        State state = ((FsmGuiState)fSMStateInterface).getState();
        this.stateMachine.removeState(state, null);
        this.guiStates.remove(state);
        this.notifyFSMModelListeners(FSMEvent.createDeleteStateEvent(fSMStateInterface));
    }

    @Override
    public void clear() {
        this.stateMachine.clear();
        this.guiStates.clear();
        this.notifyFSMModelListeners(FSMEvent.createClearAllEvent());
    }
}

