/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.actorfsm.editor.fsmdiagrameditor;

import ch.ethz.fsmgui.controller.FSMControllerInterface;
import ch.ethz.fsmgui.controller.FSMEditorOperations;
import ch.ethz.fsmgui.controller.FSMMouseInputListener;
import ch.ethz.fsmgui.model.FSMModelInterface;
import ch.ethz.fsmgui.model.FSMStateInterface;
import ch.ethz.fsmgui.view.FSMView;
import ch.karatojava.kapps.actorfsm.SensorTypeInterface;
import ch.karatojava.kapps.actorfsm.State;
import ch.karatojava.kapps.actorfsm.Transition;
import ch.karatojava.kapps.actorfsm.editor.SingleActorFsmEditor;
import ch.karatojava.kapps.actorfsm.editor.UpdateState;
import ch.karatojava.kapps.actorfsm.editor.fsmdiagrameditor.ActorDefaultPopup;
import ch.karatojava.kapps.actorfsm.editor.fsmdiagrameditor.ActorStatePopup;
import ch.karatojava.kapps.actorfsm.editor.fsmdiagrameditor.FsmGuiState;
import ch.karatojava.kapps.actorfsm.editor.fsmdiagrameditor.FsmGuiStateMachine;
import ch.karatojava.kapps.actorfsm.editor.fsmdiagrameditor.StateDialog;
import java.awt.geom.Point2D;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.event.MouseInputListener;

public class ActorGuiFsmController
implements FSMControllerInterface {
    private MouseInputListener mouseListener;
    private FSMEditorOperations editorOps;
    private FsmGuiStateMachine guiStateMachine;
    private UpdateState updateState;
    private FSMView view;
    private ActorDefaultPopup defaultPopup;
    private ActorStatePopup statePopup;
    private FSMStateInterface stopState;
    private StateDialog stateDialog;
    private State clipboardState;

    public ActorGuiFsmController(SingleActorFsmEditor singleActorFsmEditor, FsmGuiStateMachine fsmGuiStateMachine, FSMView fSMView) {
        this.view = fSMView;
        this.defaultPopup = new ActorDefaultPopup(singleActorFsmEditor, this);
        this.statePopup = new ActorStatePopup(this);
        this.stateDialog = singleActorFsmEditor.getStateDialog();
        this.setModel(fsmGuiStateMachine);
        fSMView.addMouseListener(this.mouseListener);
        fSMView.addMouseMotionListener(this.mouseListener);
    }

    public void setConcurrencyEnabled(boolean bl) {
        this.defaultPopup.setConcurrencyEnabled(bl);
    }

    public void setModel(FSMModelInterface fSMModelInterface) {
        this.guiStateMachine = (FsmGuiStateMachine)fSMModelInterface;
        this.updateState = this.guiStateMachine.getUpdateState();
        this.editorOps = new FSMEditorOperations(this.guiStateMachine, this.view);
        this.mouseListener = new FSMMouseInputListener(this);
        this.clipboardState = null;
        this.view.setModel(fSMModelInterface);
    }

    public void setStopState(FSMStateInterface fSMStateInterface) {
        this.stopState = fSMStateInterface;
    }

    @Override
    public MouseInputListener getMouseInputListener() {
        return this.mouseListener;
    }

    @Override
    public FSMEditorOperations getFSMEditorOperations() {
        return this.editorOps;
    }

    @Override
    public FSMView getView() {
        return this.view;
    }

    @Override
    public FSMModelInterface getModel() {
        return this.guiStateMachine;
    }

    public boolean isStopState(FSMStateInterface fSMStateInterface) {
        return this.stopState == fSMStateInterface;
    }

    public void copyToClipboard(FsmGuiState fsmGuiState) {
        this.clipboardState = this.cloneState(fsmGuiState.getState());
    }

    public boolean canPasteFromClipboard() {
        return this.clipboardState != null;
    }

    public void pasteFromClipboard(int n, int n2) {
        State state = this.cloneState(this.clipboardState);
        this.clipboardState = this.cloneState(this.clipboardState);
        state.setName(this.getNewStateName(state.getName()));
        FsmGuiState fsmGuiState = new FsmGuiState(this.guiStateMachine, state, this.guiStateMachine.getUpdateState());
        Point2D point2D = new Point2D.Double();
        point2D = this.view.getModelCoords(point2D, n, n2);
        fsmGuiState.setPosition(point2D.getX(), point2D.getY());
        this.guiStateMachine.addState(fsmGuiState);
        this.updateState.setDataModelState(true);
        Transition[] transitionArray = state.getTransitions();
        for (int i = 0; i < transitionArray.length; ++i) {
            fsmGuiState.addTransition(FsmGuiState.DUMMY_INPUT, this.guiStateMachine.getGuiState(transitionArray[i].getTo()));
        }
        this.updateState.setDataModelState(false);
    }

    @Override
    public void changeFSM(int n, int n2) {
        this.defaultPopup.getPopup(n, n2).show(this.getView(), n, n2);
    }

    public State executeStateDialog(State state) {
        this.stateDialog.setLocationRelativeTo(JOptionPane.getFrameForComponent(this.view));
        if (state != null) {
            this.stateDialog.show(state);
        } else {
            this.stateDialog.show(this.guiStateMachine.getStateMachine());
        }
        if (this.stateDialog.getValue() == 0) {
            String string = this.stateDialog.getStateName();
            String string2 = this.stateDialog.getDescription();
            SensorTypeInterface[] sensorTypeInterfaceArray = this.stateDialog.getSelectedSensors();
            if (state != null) {
                state.setName(string);
                state.setDescription(string2);
                state.setSensors(sensorTypeInterfaceArray);
                return state;
            }
            return new State(this.guiStateMachine.getStateMachine(), string, string2, sensorTypeInterfaceArray);
        }
        return null;
    }

    @Override
    public FSMStateInterface addState(double d, double d2) {
        State state = this.executeStateDialog(null);
        FsmGuiState fsmGuiState = null;
        if (state != null) {
            fsmGuiState = new FsmGuiState(this.guiStateMachine, state, this.updateState);
            fsmGuiState.setPosition(d, d2);
            this.editorOps.addState(fsmGuiState);
            this.view.selectState(this.view.getState(fsmGuiState), true);
        }
        return fsmGuiState;
    }

    @Override
    public boolean addTransitionAllowed(FSMStateInterface fSMStateInterface) {
        return fSMStateInterface != this.stopState;
    }

    @Override
    public void addTransition(ch.ethz.fsmgui.view.Transition transition, int n, int n2) {
        this.editorOps.addTransition(transition.from.model, transition.to.model, transition.toString());
        this.view.selectState(transition.from, true);
    }

    @Override
    public void changeState(FSMStateInterface fSMStateInterface, int n, int n2) {
        JPopupMenu jPopupMenu = this.statePopup.getPopup(fSMStateInterface);
        if (jPopupMenu != null) {
            jPopupMenu.show(this.getView(), n, n2);
        }
    }

    @Override
    public void changeTransition(ch.ethz.fsmgui.view.Transition transition, int n, int n2) {
    }

    @Override
    public void selectState(ch.ethz.fsmgui.view.State state) {
        this.view.selectState(state, true);
    }

    @Override
    public void selectTransition(ch.ethz.fsmgui.view.Transition transition) {
    }

    @Override
    public void changeTransition(ch.ethz.fsmgui.view.Transition transition, ch.ethz.fsmgui.view.State state, ch.ethz.fsmgui.view.State state2) {
        State state3 = ((FsmGuiState)transition.from.model).getState();
        State state4 = state != null ? ((FsmGuiState)state.model).getState() : null;
        State state5 = state2 != null ? ((FsmGuiState)state2.model).getState() : null;
        Transition[] transitionArray = state3.getTransitions();
        for (int i = 0; i < transitionArray.length; ++i) {
            if (transitionArray[i].getTo() != state4) continue;
            if (state5 != null) {
                transitionArray[i].setTo(state5);
                continue;
            }
            transitionArray[i].getFrom().removeTransition(transitionArray[i]);
        }
        this.view.selectState(transition.from, true);
    }

    private String getNewStateName(String string) {
        String string2 = "*" + string;
        while (this.guiStateMachine.getStateMachine().getState(string2) != null) {
            string2 = "*" + string2;
        }
        return string2;
    }

    private State cloneState(State state) {
        State state2 = new State(state.getStateMachine(), state.getName(), state.getDescription(), state.getSensors());
        state2.setFinalState(state.isFinalState());
        state2.setBarrierState(state.isBarrierState());
        state2.setCriticalSectionState(state.isCriticalSectionState());
        state2.setConcurrencyStatus(state.getConcurrencyStatus());
        Transition[] transitionArray = state.getTransitions();
        for (int i = 0; i < transitionArray.length; ++i) {
            State state3 = state.getStateMachine().getState(transitionArray[i].getTo().getName());
            if (state3 == null) continue;
            Transition transition = new Transition(state2, state3, transitionArray[i]);
            if (transition.getTo().getName().equals(state.getName())) {
                transition.setTo(state2);
            }
            state2.addTransition(transition);
        }
        return state2;
    }
}

