/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.actorfsm.editor;

import ch.karatojava.kapps.KaraGuiFactory;
import ch.karatojava.kapps.actorfsm.editor.FsmToJpegExporter;
import ch.karatojava.kapps.actorfsm.editor.SingleActorFsmEditor;
import ch.karatojava.util.Configuration;
import ch.karatojava.util.GuiFactory;
import ch.karatojava.util.JDirShareFileChooser;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class FsmExportWindow {
    protected static JDirShareFileChooser chooser;
    protected static ActionListener chooserListener;
    protected static FsmExportWindow instance;
    protected static JSlider qualitySlider;
    protected static JPanel southPanel;
    protected static JPanel radioButtonPanel;
    protected static JPanel optionPanel;
    protected JCheckBox[] stateCheckBoxes;
    protected JDialog dialog;
    protected JDialog selectStatesFrame;
    protected JRadioButton[] radioButtons;
    protected JCheckBox exportDiagram;
    protected JCheckBox exportStates;
    protected JTextField maxImageHeigt;
    protected SingleActorFsmEditor editor;

    protected FsmExportWindow() {
    }

    public static FsmExportWindow getInstance() {
        if (instance == null) {
            instance = new FsmExportWindow();
            instance.createGui();
        }
        return instance;
    }

    protected void createGui() {
        this.createFileChooserPanel();
        this.createSouthPanel();
    }

    protected void createFileChooserPanel() {
        chooserListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("ApproveSelection")) {
                    FsmExportWindow.this.export();
                } else if (actionEvent.getActionCommand().equals("CancelSelection")) {
                    FsmExportWindow.this.hideDialogs();
                }
            }
        };
        chooser = KaraGuiFactory.getInstance().getImageExportFileChooser();
        chooser.addActionListener(chooserListener);
        chooser.setBorder(GuiFactory.getInstance().createTitledBorder("language/$language/actorfsm/editor/export/filetitle"));
    }

    protected void createSouthPanel() {
        southPanel = new JPanel();
        southPanel.setLayout(new BoxLayout(southPanel, 0));
        this.createExportSelectors();
        this.createRadioButtonPanel();
        this.createOptionPanel();
        southPanel.add(optionPanel);
        southPanel.add(this.getQualityPanel());
        GuiFactory.getInstance().addUiSwitchListener(southPanel);
    }

    protected void createExportSelectors() {
        this.exportDiagram = new JCheckBox(Configuration.getInstance().getString("language/$language/actorfsm/editor/export/diagram"), true);
        this.exportStates = new JCheckBox(Configuration.getInstance().getString("language/$language/actorfsm/editor/export/states"), true);
        this.exportStates.addActionListener(new StateExportListener());
    }

    protected void createOptionPanel() {
        optionPanel = new JPanel();
        optionPanel.setLayout(new BoxLayout(optionPanel, 1));
        optionPanel.setBorder(BorderFactory.createCompoundBorder(GuiFactory.getInstance().createTitledBorder("language/$language/actorfsm/editor/export/optiontitle"), BorderFactory.createEmptyBorder(2, 4, 2, 4)));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.exportDiagram);
        jPanel.add(Box.createHorizontalGlue());
        optionPanel.add(jPanel);
        optionPanel.add(Box.createVerticalGlue());
        optionPanel.add(new JSeparator(0));
        optionPanel.add(Box.createVerticalGlue());
        jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.exportStates);
        jPanel.add(Box.createHorizontalGlue());
        optionPanel.add(jPanel);
        optionPanel.add(radioButtonPanel);
        this.radioButtons[0].setEnabled(this.exportStates.isSelected());
        this.radioButtons[1].setEnabled(this.exportStates.isSelected());
    }

    protected void createRadioButtonPanel() {
        JRadioButton jRadioButton = new JRadioButton(Configuration.getInstance().getString("language/$language/actorfsm/editor/export/allstates"), true);
        JRadioButton jRadioButton2 = new JRadioButton(Configuration.getInstance().getString("language/$language/actorfsm/editor/export/selectedstates"), false);
        this.radioButtons = new JRadioButton[2];
        this.radioButtons[0] = jRadioButton;
        this.radioButtons[1] = jRadioButton2;
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        jRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FsmExportWindow.this.selectStatesFrame.setVisible(false);
            }
        });
        jRadioButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FsmExportWindow.this.selectStatesFrame.setLocationRelativeTo(JOptionPane.getFrameForComponent(FsmExportWindow.this.editor));
                FsmExportWindow.this.selectStatesFrame.setVisible(true);
            }
        });
        radioButtonPanel = new JPanel();
        radioButtonPanel.setLayout(new BoxLayout(radioButtonPanel, 0));
        radioButtonPanel.add(jRadioButton);
        radioButtonPanel.add(jRadioButton2);
    }

    protected JPanel getQualityPanel() {
        qualitySlider = new JSlider(0, 4, 4);
        qualitySlider.setMajorTickSpacing(1);
        qualitySlider.setPaintTicks(true);
        qualitySlider.setPaintLabels(true);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>(2);
        hashtable.put(new Integer(0), GuiFactory.getInstance().createLabel("language/$language/actorfsm/editor/export/qualitymin"));
        hashtable.put(new Integer(100), GuiFactory.getInstance().createLabel("language/$language/actorfsm/editor/export/qualitymax"));
        qualitySlider.setLabelTable(hashtable);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(GuiFactory.getInstance().createTitledBorder("language/$language/actorfsm/editor/export/qualitytitle"));
        jPanel.add(Box.createVerticalGlue());
        jPanel.add(qualitySlider);
        jPanel.add(Box.createVerticalGlue());
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(GuiFactory.getInstance().createTitledBorder("language/$language/actorfsm/editor/export/imagesizetitle"));
        this.maxImageHeigt = new JTextField("800", 4);
        jPanel2.add(GuiFactory.getInstance().createLabel("language/$language/actorfsm/editor/export/maxheight"));
        jPanel2.add(this.maxImageHeigt);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.add(jPanel);
        jPanel3.add(jPanel2);
        return jPanel3;
    }

    protected void createStateSelectWindow(SingleActorFsmEditor singleActorFsmEditor) {
        JTabbedPane jTabbedPane = singleActorFsmEditor.getStateTableEditor().getTabbedPane();
        int n = jTabbedPane.getComponentCount();
        int n2 = n / 3;
        if (n2 * 3 < n) {
            ++n2;
        }
        this.stateCheckBoxes = new JCheckBox[n];
        this.selectStatesFrame = new JDialog(JOptionPane.getFrameForComponent(this.dialog), Configuration.getInstance().getString("language/$language/actorfsm/editor/export/selectstatestitle"), true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(n2, 3));
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            this.stateCheckBoxes[i] = new JCheckBox(jTabbedPane.getTitleAt(i), false);
            jPanel.add(this.stateCheckBoxes[i + n3]);
        }
        this.selectStatesFrame.getContentPane().setLayout(new BoxLayout(this.selectStatesFrame.getContentPane(), 1));
        this.selectStatesFrame.getContentPane().add(jPanel);
        JButton jButton = new JButton("Ok");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FsmExportWindow.this.selectStatesFrame.setVisible(false);
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(jButton);
        jPanel2.add(Box.createHorizontalGlue());
        this.selectStatesFrame.getContentPane().add(Box.createRigidArea(new Dimension(10, 10)));
        this.selectStatesFrame.getContentPane().add(jPanel2);
        GuiFactory.getInstance().addUiSwitchListener(this.selectStatesFrame);
        this.selectStatesFrame.pack();
    }

    public void showExportDialog(SingleActorFsmEditor singleActorFsmEditor) {
        this.editor = singleActorFsmEditor;
        this.createStateSelectWindow(singleActorFsmEditor);
        this.dialog = new JDialog(JOptionPane.getFrameForComponent(singleActorFsmEditor), "Export as JPEG", true);
        this.dialog.getContentPane().setLayout(new BoxLayout(this.dialog.getContentPane(), 1));
        this.dialog.getContentPane().add(chooser);
        this.dialog.getContentPane().add(southPanel);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(JOptionPane.getFrameForComponent(singleActorFsmEditor));
        this.dialog.setVisible(true);
        chooser.shareCurrentDirectory();
    }

    public boolean exportDiagram() {
        return this.exportDiagram.isSelected();
    }

    public boolean exportState(String string) {
        if (!this.exportStates.isSelected()) {
            return false;
        }
        if (this.radioButtons[0].isSelected()) {
            return true;
        }
        for (int i = 0; i < this.stateCheckBoxes.length; ++i) {
            if (!this.stateCheckBoxes[i].getText().equals(string) || !this.stateCheckBoxes[i].isSelected()) continue;
            return true;
        }
        return false;
    }

    public int getImageQuality() {
        return qualitySlider.getValue();
    }

    protected static int askOverwrite(String string) {
        return JOptionPane.showConfirmDialog(JOptionPane.getFrameForComponent(chooser), "There exists a file with the name \n" + string + ".\n" + "Do want to overwrite the existing file?", "Overwrite?", 1);
    }

    protected void export() {
        int n;
        File file;
        String string = chooser.getSelectedFile().getAbsolutePath();
        if (!string.endsWith(".jpg")) {
            string = string + ".jpg";
        }
        if ((file = new File(string)).exists() && FsmExportWindow.askOverwrite(string) != 0) {
            return;
        }
        try {
            n = Integer.valueOf(this.maxImageHeigt.getText());
        }
        catch (Exception exception) {
            n = 0;
        }
        if (n <= 0) {
            JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(this.dialog), "Invalid image height", "Error", 0);
            return;
        }
        FsmToJpegExporter.exportFsm(this.editor, file, this, n);
        this.hideDialogs();
    }

    protected void hideDialogs() {
        this.selectStatesFrame.setVisible(false);
        this.selectStatesFrame.dispose();
        this.selectStatesFrame = null;
        this.dialog.setVisible(false);
        this.dialog.dispose();
        this.dialog = null;
    }

    protected class StateExportListener
    implements ActionListener {
        protected StateExportListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            southPanel.removeAll();
            southPanel.setLayout(new BoxLayout(southPanel, 0));
            FsmExportWindow.this.createOptionPanel();
            southPanel.add(optionPanel);
            southPanel.add(FsmExportWindow.this.getQualityPanel());
            FsmExportWindow.this.dialog.validate();
        }
    }
}

