/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.actorfsm.editor;

import ch.karatojava.editor.AbstractEditor;
import ch.karatojava.editor.EditorIoToolbar;
import ch.karatojava.interpreter.InterpreterListener;
import ch.karatojava.interpreter.InterpreterListenerAdapter;
import ch.karatojava.interpreter.RunnableInterface;
import ch.karatojava.interpreter.StepableInterpreter;
import ch.karatojava.kapps.KaraGuiFactory;
import ch.karatojava.kapps.actorfsm.ActorInterface;
import ch.karatojava.kapps.actorfsm.ActorTypeInterface;
import ch.karatojava.kapps.actorfsm.SingleActorFsmInterpreter;
import ch.karatojava.kapps.actorfsm.State;
import ch.karatojava.kapps.actorfsm.StateMachine;
import ch.karatojava.kapps.actorfsm.editor.ActorFsmEditorUiFactory;
import ch.karatojava.kapps.actorfsm.editor.SingleActorFsmEditor;
import ch.karatojava.kapps.actorfsm.editor.fsmdiagrameditor.FsmGuiState;
import ch.karatojava.kapps.actorfsm.editor.fsmdiagrameditor.FsmGuiStateMachine;
import ch.karatojava.kapps.actorfsm.editor.fsmdiagrameditor.StateDialog;
import ch.karatojava.kapps.actorfsm.editor.io.StateMachineBuilder;
import ch.karatojava.kapps.actorfsm.editor.io.StateMachineOutputter;
import ch.karatojava.kapps.karaide.KaraActorKonfig;
import ch.karatojava.util.Configuration;
import ch.karatojava.util.ExceptionActionListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class ActorFsmEditor
extends AbstractEditor {
    protected JPanel editorPanel;
    protected Dimension clipboardFaEditorSize;
    protected FsmGuiStateMachine clipboard;
    protected EditorIoToolbar editorIo;
    protected ActorInterface[] actors;
    protected SingleActorFsmEditor[] fsmEditors;
    protected JTabbedPane editorTabbedPane;
    protected Hashtable<ActorInterface, Integer> actorToTabIndex;
    protected boolean modified;
    protected boolean stopInterpreter;
    protected InterpreterListener[] interpreterListeners;
    protected InterpreterListener interpreterListener = new InterpreterListenerAdapter(){
        protected SingleActorFsmInterpreter fsmInterpreter;
        protected boolean isEditable = true;
        protected MouseAdapter dummyMouse = new MouseAdapter(){
            protected int tabIndex;

            protected int calcTabIndex(MouseEvent mouseEvent) {
                Component component = ActorFsmEditor.this.editorPanel.findComponentAt(mouseEvent.getPoint());
                if (component == ActorFsmEditor.this.editorTabbedPane) {
                    int n = mouseEvent.getX() - ActorFsmEditor.this.editorTabbedPane.getX();
                    int n2 = mouseEvent.getY() - ActorFsmEditor.this.editorTabbedPane.getY();
                    return ActorFsmEditor.this.editorTabbedPane.getUI().tabForCoordinate(ActorFsmEditor.this.editorTabbedPane, n, n2);
                }
                return -1;
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.tabIndex = this.calcTabIndex(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                int n = this.calcTabIndex(mouseEvent);
                if (n >= 0 && n == this.tabIndex) {
                    ActorFsmEditor.this.editorTabbedPane.setSelectedIndex(this.tabIndex);
                } else {
                    ExceptionActionListener.reportException(ActorFsmEditor.this.editorPanel, Configuration.getInstance().getString("language/$language/actorfsm/editor/dontmodifytitle"), new Exception(Configuration.getInstance().getString("language/$language/actorfsm/editor/dontmodify")));
                }
            }
        };

        protected void setEditable(boolean bl) {
            JFrame jFrame = (JFrame)JOptionPane.getFrameForComponent(ActorFsmEditor.this.editorPanel);
            Component component = jFrame.getGlassPane();
            if (!bl && this.isEditable) {
                component.addMouseListener(this.dummyMouse);
                component.setVisible(true);
            } else if (bl && !this.isEditable) {
                component.setVisible(false);
                component.removeMouseListener(this.dummyMouse);
            }
            this.isEditable = bl;
        }

        protected int getActorIndex(RunnableInterface runnableInterface) {
            this.fsmInterpreter = (SingleActorFsmInterpreter)((StepableInterpreter)runnableInterface).getStepper();
            ActorInterface actorInterface = this.fsmInterpreter.getActor();
            return ActorFsmEditor.this.actorToTabIndex.get(actorInterface);
        }

        @Override
        public void gotReady(RunnableInterface runnableInterface) {
            for (int i = 0; i < ActorFsmEditor.this.interpreterListeners.length; ++i) {
                ActorFsmEditor.this.interpreterListeners[i].gotReady(runnableInterface);
            }
            this.setEditable(false);
            ActorFsmEditor.this.stopInterpreter = false;
        }

        @Override
        public void beginCompositeStep(RunnableInterface runnableInterface) {
            if (!ActorFsmEditor.this.stopInterpreter) {
                ActorFsmEditor.this.interpreterListeners[this.getActorIndex(runnableInterface)].beginCompositeStep(runnableInterface);
            }
        }

        @Override
        public void stepped(RunnableInterface runnableInterface) {
            if (!ActorFsmEditor.this.stopInterpreter) {
                ActorFsmEditor.this.interpreterListeners[this.getActorIndex(runnableInterface)].stepped(runnableInterface);
            }
        }

        @Override
        public void endCompositeStep(RunnableInterface runnableInterface) {
            ActorFsmEditor.this.interpreterListeners[this.getActorIndex(runnableInterface)].endCompositeStep(runnableInterface);
        }

        @Override
        public void stopped(RunnableInterface runnableInterface) {
            for (int i = 0; i < ActorFsmEditor.this.interpreterListeners.length; ++i) {
                ActorFsmEditor.this.interpreterListeners[i].stopped(runnableInterface);
            }
            this.setEditable(true);
        }

        @Override
        public void errorStop(RunnableInterface runnableInterface) {
            for (int i = 0; i < ActorFsmEditor.this.interpreterListeners.length; ++i) {
                ActorFsmEditor.this.interpreterListeners[i].errorStop(runnableInterface);
            }
            this.setEditable(true);
        }
    };

    public ActorFsmEditor(ActorFsmEditorUiFactory actorFsmEditorUiFactory, ActorTypeInterface actorTypeInterface, ActorInterface[] actorInterfaceArray, StateDialog stateDialog) {
        this(actorFsmEditorUiFactory, actorTypeInterface, actorInterfaceArray, stateDialog, false);
    }

    public ActorFsmEditor(ActorFsmEditorUiFactory actorFsmEditorUiFactory, ActorTypeInterface actorTypeInterface, ActorInterface[] actorInterfaceArray, StateDialog stateDialog, boolean bl) {
        this.actors = actorInterfaceArray;
        this.editorPanel = new JPanel();
        this.editorPanel.setLayout(new BoxLayout(this.editorPanel, 1));
        KaraGuiFactory karaGuiFactory = KaraGuiFactory.getInstance();
        this.editorIo = new EditorIoToolbar(this, karaGuiFactory.createEditorToolbar(karaGuiFactory.getFileChooser(), karaGuiFactory.getProgramFileFilter()), karaGuiFactory.getProgramFileFilter().getExtensions()[0]);
        this.editorPanel.add(this.editorIo);
        this.editorTabbedPane = new JTabbedPane();
        this.editorTabbedPane.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.editorTabbedPane.setOpaque(false);
        this.editorPanel.add(this.editorTabbedPane);
        this.actorToTabIndex = new Hashtable();
        this.fsmEditors = new SingleActorFsmEditor[actorInterfaceArray.length];
        for (int i = 0; i < actorInterfaceArray.length; ++i) {
            this.actorToTabIndex.put(actorInterfaceArray[i], new Integer(i));
            this.fsmEditors[i] = new SingleActorFsmEditor(actorFsmEditorUiFactory, this, actorTypeInterface, stateDialog, bl);
            this.editorTabbedPane.addTab("", this.fsmEditors[i]);
            this.editorTabbedPane.setIconAt(i, actorInterfaceArray[i].getIcon());
        }
        this.newFile();
    }

    public JPanel getGui() {
        return this.editorPanel;
    }

    public EditorIoToolbar getEditorIoToolbar() {
        return this.editorIo;
    }

    @Override
    public Object getContent() {
        Hashtable<ActorInterface, StateMachine> hashtable = new Hashtable<ActorInterface, StateMachine>();
        for (int i = 0; i < this.actors.length; ++i) {
            hashtable.put(this.actors[i], this.fsmEditors[i].getStateMachine());
        }
        return hashtable;
    }

    public int countActors() {
        return this.actors.length;
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    public InterpreterListener[] getInterpreterListeners() {
        this.interpreterListeners = new InterpreterListener[this.fsmEditors.length];
        for (int i = 0; i < this.interpreterListeners.length; ++i) {
            this.interpreterListeners[i] = this.fsmEditors[i].getInterpreterListener();
        }
        return new InterpreterListener[]{this.interpreterListener};
    }

    public SingleActorFsmEditor[] getSingleActorFsmEditors() {
        return (SingleActorFsmEditor[])this.fsmEditors.clone();
    }

    @Override
    public Object create(InputStream inputStream) throws Exception {
        return StateMachineBuilder.buildStateMachines(this, inputStream, this.actors);
    }

    @Override
    protected void doSave(OutputStream outputStream) throws Exception {
        Hashtable<ActorInterface, FsmGuiStateMachine> hashtable = new Hashtable<ActorInterface, FsmGuiStateMachine>();
        for (int i = 0; i < this.actors.length; ++i) {
            hashtable.put(this.actors[i], this.fsmEditors[i].getFsmGuiStateMachine());
        }
        StateMachineOutputter.outputStateMachine(hashtable, outputStream, KaraActorKonfig.getInstance().getKaraActorType());
    }

    @Override
    protected void doSetContent(Object object) {
        Hashtable hashtable = (Hashtable)object;
        if (hashtable != null) {
            for (int i = 0; i < this.actors.length; ++i) {
                FsmGuiStateMachine fsmGuiStateMachine = (FsmGuiStateMachine)hashtable.get(this.actors[i]);
                this.fsmEditors[i].setStateMachine(fsmGuiStateMachine);
                FsmGuiState fsmGuiState = (FsmGuiState)fsmGuiStateMachine.getStartState();
                if (fsmGuiState == null) continue;
                State state = fsmGuiState.getState();
                this.fsmEditors[i].getStateTableEditor().setSelectedState(state);
            }
        }
    }

    @Override
    protected void doNewFile() {
        this.clipboard = null;
        this.clipboardFaEditorSize = null;
        this.stopInterpreter = true;
        this.actors[0].getActorType().resetSensors();
        for (int i = 0; i < this.fsmEditors.length; ++i) {
            this.fsmEditors[i].setNewStateMachine();
        }
        this.editorPanel.revalidate();
    }

    @Override
    public void resetModified() {
        this.modified = false;
    }

    public void setModified() {
        this.modified = true;
        this.listenerSupport.fireModifiedContent();
    }

    public void copyToClipboard(FsmGuiStateMachine fsmGuiStateMachine) {
        this.clipboardFaEditorSize = null;
        for (int i = 0; i < this.actors.length; ++i) {
            if (this.fsmEditors[i].getFsmGuiStateMachine() != fsmGuiStateMachine) continue;
            this.clipboardFaEditorSize = this.fsmEditors[i].getTopComponent().getSize();
        }
        this.clipboard = new FsmGuiStateMachine(fsmGuiStateMachine);
    }

    public Dimension getClipboardFaEditorSize() {
        return this.clipboardFaEditorSize;
    }

    public FsmGuiStateMachine pasteFromClipboard() {
        return new FsmGuiStateMachine(this.clipboard);
    }

    public boolean canPasteFromClipboard() {
        return this.clipboard != null;
    }
}

