/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.actorfsm;

import ch.karatojava.kapps.actorfsm.ActorFsmListener;
import ch.karatojava.kapps.actorfsm.ActorFsmListenerSupport;
import ch.karatojava.kapps.actorfsm.State;
import ch.karatojava.kapps.actorfsm.Transition;
import java.util.ArrayList;
import java.util.Hashtable;

public class StateMachine {
    protected ArrayList<State> states = new ArrayList();
    protected State startState = null;
    protected Hashtable<String, State> stateNames = new Hashtable();
    protected ActorFsmListenerSupport listenerSupport = new ActorFsmListenerSupport();

    public StateMachine() {
    }

    public StateMachine(StateMachine stateMachine) {
        Object object;
        State state;
        int n;
        for (n = 0; n < stateMachine.states.size(); ++n) {
            state = stateMachine.states.get(n);
            object = new State(this, state.getName(), state.getDescription(), state.getSensors());
            ((State)object).setFinalState(state.isFinalState());
            ((State)object).setBarrierState(state.isBarrierState());
            ((State)object).setCriticalSectionState(state.isCriticalSectionState());
            ((State)object).setConcurrencyStatus(state.getConcurrencyStatus());
            this.addState((State)object);
        }
        for (n = 0; n < stateMachine.states.size(); ++n) {
            state = stateMachine.states.get(n);
            object = state.getTransitions();
            for (int i = 0; i < ((Object)object).length; ++i) {
                State state2 = this.getState(((Transition)object[i]).getFrom().getName());
                State state3 = this.getState(((Transition)object[i]).getTo().getName());
                State state4 = this.states.get(n);
                state4.addTransition(new Transition(state2, state3, (Transition)object[i]));
            }
        }
        if (stateMachine.startState != null) {
            this.setStartState(this.getState(stateMachine.startState.getName()));
        }
    }

    public void setStartState(State state) {
        this.startState = state;
        if (state != null) {
            this.listenerSupport.fireSetStartState(this.startState);
        } else {
            this.listenerSupport.fireSetStartStateNull(this);
        }
    }

    public State getState(String string) {
        return this.stateNames.get(string);
    }

    public State getStartState() {
        return this.startState;
    }

    public int indexOf(State state) {
        return this.states.indexOf(state);
    }

    public int size() {
        return this.states.size();
    }

    public State[] getStates() {
        State[] stateArray = new State[this.states.size()];
        this.states.toArray(stateArray);
        return stateArray;
    }

    public boolean contains(State state) {
        return this.states.contains(state);
    }

    public void addState(State state) {
        this.states.add(state);
        this.stateNames.put(state.getName(), state);
        this.listenerSupport.fireStateAdded(state);
    }

    public void removeState(State state, State state2) {
        int n;
        Transition[] transitionArray = state.getTransitions();
        for (n = 0; n < transitionArray.length; ++n) {
            state.removeTransition(transitionArray[n]);
        }
        int n2 = this.states.size();
        for (n = 0; n < n2; ++n) {
            State state3 = this.states.get(n);
            transitionArray = state3.getTransitions();
            for (int i = 0; i < transitionArray.length; ++i) {
                if (transitionArray[i].getTo() != state) continue;
                if (state2 != null) {
                    transitionArray[i].setTo(state2);
                    continue;
                }
                transitionArray[i].setTo(state3);
            }
        }
        if (state == this.startState) {
            this.setStartState(null);
        }
        this.states.remove(state);
        this.stateNames.remove(state.getName());
        this.listenerSupport.fireStateRemoved(state, state2);
    }

    public void clear() {
        this.states = new ArrayList();
        this.startState = null;
        this.stateNames = new Hashtable();
        this.listenerSupport.fireStateMachineClear(this);
    }

    public void addActorFsmListener(ActorFsmListener actorFsmListener) {
        this.listenerSupport.addActorFsmListener(actorFsmListener);
    }

    public void removeActorFsmListener(ActorFsmListener actorFsmListener) {
        this.listenerSupport.removeActorFsmListener(actorFsmListener);
    }

    void nameSet(State state, String string) {
        this.stateNames.remove(string);
        this.stateNames.put(state.getName(), state);
    }

    public ActorFsmListenerSupport getListenerSupport() {
        return this.listenerSupport;
    }
}

