/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.actorfsm;

import ch.karatojava.interpreter.InterpreterException;
import ch.karatojava.interpreter.StepperInterface;
import ch.karatojava.kapps.actorfsm.ActorInterface;
import ch.karatojava.kapps.actorfsm.AmbigousTransitionException;
import ch.karatojava.kapps.actorfsm.CommandTypeInterface;
import ch.karatojava.kapps.actorfsm.NoStartStateException;
import ch.karatojava.kapps.actorfsm.NoTransitionException;
import ch.karatojava.kapps.actorfsm.SensorTypeInterface;
import ch.karatojava.kapps.actorfsm.State;
import ch.karatojava.kapps.actorfsm.StateMachine;
import ch.karatojava.kapps.actorfsm.Transition;
import java.util.Random;

public class SingleActorFsmInterpreter
implements StepperInterface {
    protected Mode mode;
    protected boolean deterministic = true;
    protected ActorInterface actor;
    protected StateMachine stateMachine;
    protected State currentState;
    protected Transition currentTransition;
    protected int currentCommandIndex;
    protected Random randomGenerator = new Random();

    public SingleActorFsmInterpreter() {
        this.mode = Mode.AND;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setStateMachine(StateMachine stateMachine) {
        this.stateMachine = stateMachine;
    }

    public StateMachine getStateMachine() {
        return this.stateMachine;
    }

    public void setActor(ActorInterface actorInterface) {
        this.actor = actorInterface;
    }

    public ActorInterface getActor() {
        return this.actor;
    }

    public void setDeterministic(boolean bl) {
        this.deterministic = bl;
    }

    public boolean isDeterministic() {
        return this.deterministic;
    }

    @Override
    public void getReady() throws InterpreterException {
        this.currentState = this.stateMachine.getStartState();
        if (this.currentState == null) {
            throw new NoStartStateException(this.actor);
        }
        this.currentTransition = null;
        this.currentCommandIndex = -1;
    }

    public final State getCurrentState() {
        return this.currentState;
    }

    public final Transition getCurrentTransition() {
        return this.currentTransition;
    }

    public final CommandTypeInterface getCurrentCommand() {
        CommandTypeInterface commandTypeInterface = null;
        if (this.currentCommandIndex < this.currentTransition.size()) {
            return this.currentTransition.getCommand(this.currentCommandIndex);
        }
        return commandTypeInterface;
    }

    public final int getCurrentCommandIndex() {
        int n = -1;
        if (this.currentTransition != null && this.currentCommandIndex < this.currentTransition.size()) {
            return this.currentCommandIndex;
        }
        return n;
    }

    @Override
    public void beginCompositeStep() throws InterpreterException {
        this.currentTransition = this.getNextTransition();
        this.currentCommandIndex = 0;
    }

    @Override
    public void executeStep() throws InterpreterException {
        if (this.currentTransition.size() > 0) {
            CommandTypeInterface commandTypeInterface = this.currentTransition.getCommand(this.currentCommandIndex);
            this.actor.execute(commandTypeInterface);
            ++this.currentCommandIndex;
        }
    }

    @Override
    public void endCompositeStep() throws InterpreterException {
        this.currentState = this.currentTransition.getTo();
        this.currentTransition = null;
        this.currentCommandIndex = -1;
    }

    @Override
    public boolean executionFinished() {
        return this.currentState.isFinalState();
    }

    @Override
    public boolean compositeStepFinished() {
        return this.currentCommandIndex >= this.currentTransition.size();
    }

    protected Transition getNextTransition() throws NoTransitionException, AmbigousTransitionException {
        int n;
        int n2;
        Transition[] transitionArray = this.currentState.getTransitions();
        Transition[] transitionArray2 = new Transition[transitionArray.length];
        Transition transition = null;
        SensorTypeInterface[] sensorTypeInterfaceArray = this.currentState.getSensors();
        boolean[] blArray = new boolean[sensorTypeInterfaceArray.length];
        for (n2 = 0; n2 < sensorTypeInterfaceArray.length; ++n2) {
            blArray[n2] = this.actor.getValue(sensorTypeInterfaceArray[n2]);
        }
        n2 = 0;
        for (n = 0; n < transitionArray.length; ++n) {
            if (!transitionArray[n].inputMatch(blArray, this.mode)) continue;
            transitionArray2[n2] = transitionArray[n];
            ++n2;
        }
        if (n2 == 0) {
            throw new NoTransitionException(this.currentState, this.actor);
        }
        if (this.deterministic) {
            if (n2 > 1) {
                throw new AmbigousTransitionException(this.currentState, this.actor);
            }
            transition = transitionArray2[0];
        } else {
            n = this.randomGenerator.nextInt(n2);
            transition = transitionArray2[n];
        }
        return transition;
    }

    public static final class Mode {
        public static final Mode AND = new Mode();
        public static final Mode OR = new Mode();

        protected Mode() {
        }
    }
}

