/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.actorfsm;

import ch.karatojava.kapps.actorfsm.ActorFsmListener;
import ch.karatojava.kapps.actorfsm.CommandTypeInterface;
import ch.karatojava.kapps.actorfsm.SensorTypeInterface;
import ch.karatojava.kapps.actorfsm.State;
import ch.karatojava.kapps.actorfsm.StateMachine;
import ch.karatojava.kapps.actorfsm.Transition;
import java.util.ArrayList;

class ActorFsmListenerSupport {
    public static final String CONCURRENCY_STATUS_CHANGED = "concurrency status changed";
    public static final String SET_BARRIER = "set barrier";
    public static final String SET_CRITICAL_SECTION = "set critical section";
    public static final String SET_DESCRIPTION = "set description";
    public static final String SET_FINAL = "set final";
    public static final String SET_NAME = "set name";
    public static final String SET_SENSORS = "set sensors";
    public static final String SET_START_STATE = "set start state";
    public static final String SET_START_STATE_NULL = "set start state null";
    public static final String STATE_ADDED = "state added";
    public static final String STATE_REMOVED = "state removed";
    public static final String STATEMACHINE_CLEARED = "state machine cleared";
    public static final String TRANSITION_ADDED = "transition added";
    public static final String TRANSITION_REMOVED = "transition removed";
    public static final String TRANSITION_COMMAND_ADDED = "transition: command added";
    public static final String TRANSITION_COMMAND_REMOVED = "transition: command removed";
    public static final String TRANSITION_COMMANDS_SET = "transition: commands set";
    public static final String TRANSITION_INPUT_CHANGED = "transition: input changed";
    public static final String TRANSITION_TO_CHANGED = "transition: to changed";
    protected ArrayList<ActorFsmListener> listeners;
    protected ActorFsmListener[] listenersArray;
    protected boolean eventInProcess;
    protected String lastEvent;

    public ActorFsmListenerSupport() {
        this.listeners = new ArrayList();
        this.listenersArray = new ActorFsmListener[this.listeners.size()];
        this.listeners.toArray(this.listenersArray);
    }

    public ActorFsmListenerSupport(ActorFsmListenerSupport actorFsmListenerSupport) {
        this.listeners = (ArrayList)actorFsmListenerSupport.listeners.clone();
        this.listenersArray = new ActorFsmListener[actorFsmListenerSupport.listeners.size()];
        this.listeners.toArray(this.listenersArray);
    }

    public synchronized void addActorFsmListener(ActorFsmListener actorFsmListener) {
        this.listeners.add(actorFsmListener);
        this.listenersArray = new ActorFsmListener[this.listeners.size()];
        this.listeners.toArray(this.listenersArray);
    }

    public synchronized void removeActorFsmListener(ActorFsmListener actorFsmListener) {
        this.listeners.remove(actorFsmListener);
        this.listenersArray = new ActorFsmListener[this.listeners.size()];
        this.listeners.toArray(this.listenersArray);
    }

    public boolean eventInProcess() {
        return this.eventInProcess;
    }

    public String getLastEvent() {
        return this.lastEvent;
    }

    public void fireStateMachineClear(StateMachine stateMachine) {
        this.eventInProcess = true;
        for (int i = 0; i < this.listenersArray.length; ++i) {
            this.listenersArray[i].stateMachineClear(stateMachine);
        }
        this.eventInProcess = false;
        this.lastEvent = STATEMACHINE_CLEARED;
    }

    public void fireSetStartState(State state) {
        this.eventInProcess = true;
        for (int i = 0; i < this.listenersArray.length; ++i) {
            this.listenersArray[i].setStartState(state);
        }
        this.eventInProcess = false;
        this.lastEvent = SET_START_STATE;
    }

    public void fireSetStartStateNull(StateMachine stateMachine) {
        this.eventInProcess = true;
        for (int i = 0; i < this.listenersArray.length; ++i) {
            this.listenersArray[i].setStartStateNull(stateMachine);
        }
        this.eventInProcess = false;
        this.lastEvent = SET_START_STATE_NULL;
    }

    public void fireSetBarrierState() {
        this.eventInProcess = true;
        for (int i = 0; i < this.listenersArray.length; ++i) {
            this.listenersArray[i].setBarrierState();
        }
        this.eventInProcess = false;
        this.lastEvent = SET_BARRIER;
    }

    public void fireSetCriticalSectionState() {
        this.eventInProcess = true;
        for (int i = 0; i < this.listenersArray.length; ++i) {
            this.listenersArray[i].setCriticalSectionState();
        }
        this.eventInProcess = false;
        this.lastEvent = SET_CRITICAL_SECTION;
    }

    public void fireConcurrencyStatusChanged() {
        this.eventInProcess = true;
        for (int i = 0; i < this.listenersArray.length; ++i) {
            this.listenersArray[i].concurrencyStatusChanged();
        }
        this.eventInProcess = false;
        this.lastEvent = CONCURRENCY_STATUS_CHANGED;
    }

    public void fireStateAdded(State state) {
        this.eventInProcess = true;
        for (int i = 0; i < this.listenersArray.length; ++i) {
            this.listenersArray[i].stateAdded(state);
        }
        this.eventInProcess = false;
        this.lastEvent = STATE_ADDED;
    }

    public void fireStateRemoved(State state, State state2) {
        this.eventInProcess = true;
        for (int i = 0; i < this.listenersArray.length; ++i) {
            this.listenersArray[i].stateRemoved(state, state2);
        }
        this.eventInProcess = false;
        this.lastEvent = STATE_REMOVED;
    }

    public boolean stateAdded(State state) {
        return state.getStateMachine().contains(state);
    }

    public boolean transitionAdded(Transition transition) {
        return transition.getFrom().contains(transition);
    }

    public void fireTransitionAdded(Transition transition) {
        if (this.stateAdded(transition.getFrom())) {
            this.eventInProcess = true;
            for (int i = 0; i < this.listenersArray.length; ++i) {
                this.listenersArray[i].transitionAdded(transition);
            }
            this.eventInProcess = false;
            this.lastEvent = TRANSITION_ADDED;
        }
    }

    public void fireTransitionRemoved(Transition transition, int n) {
        if (this.stateAdded(transition.getFrom())) {
            this.eventInProcess = true;
            for (int i = 0; i < this.listenersArray.length; ++i) {
                this.listenersArray[i].transitionRemoved(transition, n);
            }
            this.eventInProcess = false;
            this.lastEvent = TRANSITION_REMOVED;
        }
    }

    public void fireSetFinalState(State state) {
        if (this.stateAdded(state)) {
            this.eventInProcess = true;
            for (int i = 0; i < this.listenersArray.length; ++i) {
                this.listenersArray[i].setFinalState(state);
            }
            this.eventInProcess = false;
            this.lastEvent = SET_FINAL;
        }
    }

    public void fireSetDescription(State state) {
        if (this.stateAdded(state)) {
            this.eventInProcess = true;
            for (int i = 0; i < this.listenersArray.length; ++i) {
                this.listenersArray[i].setDescription(state);
            }
            this.eventInProcess = false;
            this.lastEvent = SET_DESCRIPTION;
        }
    }

    public void fireSetName(State state, String string) {
        if (this.stateAdded(state)) {
            this.eventInProcess = true;
            for (int i = 0; i < this.listenersArray.length; ++i) {
                this.listenersArray[i].setName(state, string);
            }
            this.eventInProcess = false;
            this.lastEvent = SET_NAME;
        }
    }

    public void fireSetSensors(State state) {
        if (this.stateAdded(state)) {
            this.eventInProcess = true;
            for (int i = 0; i < this.listenersArray.length; ++i) {
                this.listenersArray[i].setSensors(state);
            }
            this.eventInProcess = false;
            this.lastEvent = SET_SENSORS;
        }
    }

    public void fireTransitionInputChanged(Transition transition, SensorTypeInterface sensorTypeInterface, int n) {
        if (this.stateAdded(transition.getFrom()) && this.transitionAdded(transition)) {
            this.eventInProcess = true;
            for (int i = 0; i < this.listenersArray.length; ++i) {
                this.listenersArray[i].transitionInputChanged(transition, sensorTypeInterface, n);
            }
            this.eventInProcess = false;
            this.lastEvent = TRANSITION_INPUT_CHANGED;
        }
    }

    public void fireTransitionToChanged(Transition transition, State state) {
        if (this.stateAdded(transition.getFrom()) && this.transitionAdded(transition)) {
            this.eventInProcess = true;
            for (int i = 0; i < this.listenersArray.length; ++i) {
                this.listenersArray[i].transitionToChanged(transition, state);
            }
            this.eventInProcess = false;
            this.lastEvent = TRANSITION_TO_CHANGED;
        }
    }

    public void fireTransitionCommandAdded(Transition transition, int n) {
        if (this.stateAdded(transition.getFrom()) && this.transitionAdded(transition)) {
            this.eventInProcess = true;
            for (int i = 0; i < this.listenersArray.length; ++i) {
                this.listenersArray[i].transitionCommandAdded(transition, n);
            }
            this.eventInProcess = false;
            this.lastEvent = TRANSITION_COMMAND_ADDED;
        }
    }

    public void fireTransitionCommandRemoved(Transition transition, CommandTypeInterface commandTypeInterface, int n) {
        if (this.stateAdded(transition.getFrom()) && this.transitionAdded(transition)) {
            this.eventInProcess = true;
            for (int i = 0; i < this.listenersArray.length; ++i) {
                this.listenersArray[i].transitionCommandRemoved(transition, commandTypeInterface, n);
            }
            this.eventInProcess = false;
            this.lastEvent = TRANSITION_COMMAND_REMOVED;
        }
    }

    public void fireTransitionCommandsSet(Transition transition) {
        if (this.stateAdded(transition.getFrom()) && this.transitionAdded(transition)) {
            this.eventInProcess = true;
            for (int i = 0; i < this.listenersArray.length; ++i) {
                this.listenersArray[i].transitionCommandsSet(transition);
            }
            this.eventInProcess = false;
            this.lastEvent = TRANSITION_COMMANDS_SET;
        }
    }
}

