/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.abstractscriptide;

import ch.karatojava.editor.EditorInterface;
import ch.karatojava.editor.EditorIoToolbar;
import ch.karatojava.editor.EditorWindowListener;
import ch.karatojava.interpreter.InterpreterListener;
import ch.karatojava.kapps.Application;
import ch.karatojava.kapps.KaraEditorUiFactory;
import ch.karatojava.kapps.KaraGuiFactory;
import ch.karatojava.kapps.ProgramEditorFacadeInterface;
import ch.karatojava.kapps.WorldEditorFacadeInterface;
import ch.karatojava.kapps.abstractscriptide.JavaCompiler;
import ch.karatojava.kapps.abstractscriptide.JavaEditor;
import ch.karatojava.util.Configuration;
import ch.karatojava.util.ExceptionActionListener;
import ch.karatojava.util.GuiFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public abstract class JavaProgramEditorFacade
implements ProgramEditorFacadeInterface {
    protected static final String JAVAC_PATH_PROPERTY = "javac.path";
    protected static final String FONT_SIZE_PROPERTY = "font size";
    protected JavaEditor javaEditor;
    protected JFrame editorGui;
    protected JTextField javacPath;
    protected JavaCompiler compiler;
    protected JFileChooser compilerChooser;
    protected Properties configProperties;
    protected DocumentListener javacPathListener = new DocumentListener(){

        protected void saveToConfigProperties(String string) {
            JavaProgramEditorFacade.this.getConfigProperties().setProperty(JavaProgramEditorFacade.JAVAC_PATH_PROPERTY, string);
            JavaProgramEditorFacade.this.saveConfigProperties();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            JavaProgramEditorFacade.this.compiler.setJavacPath(JavaProgramEditorFacade.this.javacPath.getText());
            this.saveToConfigProperties(JavaProgramEditorFacade.this.javacPath.getText());
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            JavaProgramEditorFacade.this.compiler.setJavacPath(JavaProgramEditorFacade.this.javacPath.getText());
            this.saveToConfigProperties(JavaProgramEditorFacade.this.javacPath.getText());
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            JavaProgramEditorFacade.this.compiler.setJavacPath(JavaProgramEditorFacade.this.javacPath.getText());
            this.saveToConfigProperties(JavaProgramEditorFacade.this.javacPath.getText());
        }
    };
    protected ActionListener fontSizeListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Integer n = (Integer)((JRadioButton)actionEvent.getSource()).getClientProperty(JavaProgramEditorFacade.FONT_SIZE_PROPERTY);
            JavaProgramEditorFacade.this.javaEditor.setFontSize(n);
        }
    };

    @Override
    public void setWorldEditorFacade(WorldEditorFacadeInterface worldEditorFacadeInterface) {
    }

    @Override
    public int getNumberOfInitSteps() {
        return 4;
    }

    @Override
    public JFrame getProgramEditorGui() {
        return this.editorGui;
    }

    @Override
    public EditorIoToolbar getProgramEditorIoToolbar() {
        return this.javaEditor.getEditorToolbar();
    }

    @Override
    public EditorInterface getProgramEditor() {
        return this.javaEditor;
    }

    protected abstract String getConfigFileName();

    protected File getConfigFile() {
        boolean bl = Application.getInstance().isParameter("testingjavakara");
        if (!bl) {
            return new File(new File(System.getProperty("java.class.path")).getParentFile(), this.getConfigFileName());
        }
        return new File("c:/tmp/" + this.getConfigFileName());
    }

    protected Properties getInitialConfigProperties() {
        Properties properties = new Properties();
        properties.put(JAVAC_PATH_PROPERTY, "javac");
        return properties;
    }

    protected Properties getConfigProperties() {
        if (this.configProperties == null) {
            try {
                this.configProperties = new Properties();
                this.configProperties.load(new FileReader(this.getConfigFile()));
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.configProperties = this.getInitialConfigProperties();
            }
            catch (IOException iOException) {
                this.configProperties = this.getInitialConfigProperties();
            }
        }
        return this.configProperties;
    }

    protected String getJavacPath() {
        return this.getConfigProperties().getProperty(JAVAC_PATH_PROPERTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveConfigProperties() {
        if (this.getConfigProperties() != null) {
            FileWriter fileWriter = null;
            try {
                fileWriter = new FileWriter(this.getConfigFile());
                this.getConfigProperties().store(fileWriter, null);
            }
            catch (IOException iOException) {
            }
            finally {
                if (fileWriter != null) {
                    try {
                        fileWriter.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    @Override
    public JComponent getConfigGui() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBorder(GuiFactory.getInstance().createTitledBorder("language/$language/scriptide/setup/title"));
        JButton jButton = new JButton(Configuration.getInstance().getString("language/$language/scriptide/setup/selectcompilerbutton"));
        jButton.addActionListener(new ExceptionActionListener(this, "selectCompiler"));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.add(GuiFactory.getInstance().createLabel("language/$language/scriptide/setup/label1"));
        jPanel3.add(GuiFactory.getInstance().createLabel("language/$language/scriptide/setup/label2"));
        jPanel3.add(GuiFactory.getInstance().createLabel("language/$language/scriptide/setup/label3"));
        jPanel3.add(Box.createVerticalStrut(4));
        this.javacPath = new JTextField(10);
        this.javacPath.getDocument().addDocumentListener(this.javacPathListener);
        this.javacPath.setText(this.getJavacPath());
        jPanel2.add((Component)jPanel3, "North");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(4, 0));
        jPanel4.add((Component)jButton, "West");
        jPanel4.add((Component)this.javacPath, "Center");
        jPanel2.add((Component)jPanel4, "South");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        jPanel5.setBorder(GuiFactory.getInstance().createTitledBorder("language/$language/scriptide/setup/fonttitle"));
        JLabel jLabel = new JLabel(Configuration.getInstance().getString("language/$language/scriptide/setup/fontsize"));
        ButtonGroup buttonGroup = new ButtonGroup();
        jPanel5.add(jLabel);
        jPanel5.add(Box.createHorizontalStrut(6));
        jPanel5.add(this.createFontSizeButton(10, buttonGroup));
        JRadioButton jRadioButton = this.createFontSizeButton(12, buttonGroup);
        jRadioButton.doClick();
        jPanel5.add(jRadioButton);
        jPanel5.add(this.createFontSizeButton(14, buttonGroup));
        jPanel5.add(this.createFontSizeButton(16, buttonGroup));
        jPanel5.add(this.createFontSizeButton(18, buttonGroup));
        jPanel5.add(Box.createHorizontalGlue());
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(6));
        jPanel.add(jPanel5);
        return jPanel;
    }

    protected JRadioButton createFontSizeButton(int n, ButtonGroup buttonGroup) {
        JRadioButton jRadioButton = new JRadioButton(" " + n);
        jRadioButton.addActionListener(this.fontSizeListener);
        jRadioButton.putClientProperty(FONT_SIZE_PROPERTY, new Integer(n));
        buttonGroup.add(jRadioButton);
        return jRadioButton;
    }

    public void selectCompiler() {
        File file;
        this.compilerChooser.rescanCurrentDirectory();
        int n = this.compilerChooser.showOpenDialog(JOptionPane.getFrameForComponent(this.javacPath));
        if (n == 0 && (file = this.compilerChooser.getSelectedFile()) != null) {
            this.javacPath.setText(file.getAbsolutePath());
        }
    }

    @Override
    public InterpreterListener[] getInterpreterListeners() {
        return new InterpreterListener[]{this.javaEditor.getInterpreterListener(), new KaraEditorUiFactory.InterpreterListener(this.javaEditor.getEditorToolbar())};
    }

    protected JavaEditor createJavaEditor(JavaCompiler javaCompiler) {
        return new JavaEditor(javaCompiler);
    }

    @Override
    public int initialize(JProgressBar jProgressBar, JLabel jLabel, int n) {
        jLabel.setText("java source code editor ...");
        this.compiler = new JavaCompiler();
        this.javaEditor = this.createJavaEditor(this.compiler);
        jProgressBar.setValue(++n);
        jLabel.setText("java source code editor ...");
        this.compilerChooser = new JFileChooser();
        this.compilerChooser.setMultiSelectionEnabled(false);
        jProgressBar.setValue(++n);
        jLabel.setText("java source code editor gui...");
        this.editorGui = this.createProgramEditorGui();
        jProgressBar.setValue(++n);
        return n;
    }

    protected JFrame createProgramEditorGui() {
        JFrame jFrame = KaraGuiFactory.getInstance().createProgramEditorFrame();
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add((Component)this.javaEditor.getGui(), "Center");
        jFrame.setDefaultCloseOperation(0);
        jFrame.addWindowListener(new EditorWindowListener(false, this.javaEditor.getEditorToolbar(), null));
        return jFrame;
    }
}

