/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.abstractscriptide;

import ch.karatojava.editor.EditorIoToolbar;
import ch.karatojava.kapps.KaraGuiFactory;
import ch.karatojava.kapps.abstractscriptide.AbstractScriptEditor;
import ch.karatojava.kapps.abstractscriptide.ErrorMessage;
import ch.karatojava.kapps.abstractscriptide.JavaCompiler;
import ch.karatojava.kapps.tasks.ExecutableLoaderInterface;
import ch.karatojava.util.Configuration;
import ch.karatojava.util.gui.jedit.JavaTokenMarker;
import ch.karatojava.util.gui.jedit.TokenMarker;
import java.io.File;
import java.io.OutputStream;
import javax.swing.JOptionPane;

public class JavaEditor
extends AbstractScriptEditor
implements ExecutableLoaderInterface {
    protected boolean mustRecompile;
    protected JavaCompiler compiler;
    protected Object executable;

    public JavaEditor(JavaCompiler javaCompiler) {
        this.compiler = javaCompiler;
    }

    @Override
    public void save(File file) throws Exception {
        boolean bl = file != this.currentFile;
        boolean bl2 = this.editorAdapter.isModified();
        super.save(file);
        if (bl || bl2) {
            this.mustRecompile = true;
        }
    }

    @Override
    protected void doSave(OutputStream outputStream) throws Exception {
        super.doSave(outputStream);
        this.executable = null;
    }

    @Override
    protected void doSetContent(Object object) {
        super.doSetContent(object);
        this.mustRecompile = true;
        this.executable = null;
    }

    @Override
    protected void doNewFile() {
        super.doNewFile();
        this.mustRecompile = true;
        this.executable = null;
    }

    @Override
    public void loadExecutable(String string) throws Exception {
        Class<?> clazz = Class.forName(string);
        this.executable = clazz.newInstance();
        this.mustRecompile = false;
        this.editorAdapter.resetModified();
    }

    @Override
    public Object getContent() {
        if (!JOptionPane.getFrameForComponent(this.editorPanel).isVisible()) {
            throw new RuntimeException(Configuration.getInstance().getString("language/$language/interpreter/progwinclosed"));
        }
        Object object = null;
        try {
            if (this.executable != null && !this.editorAdapter.isModified()) {
                return this.executable;
            }
            boolean bl = this.compile();
            if (bl && this.compiler.getCompilerMessages().length == 0) {
                object = this.compiler.loadJavaProgram(this.getCurrentFile());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception.getMessage());
        }
        return object;
    }

    public boolean compile() throws Exception {
        boolean bl;
        boolean bl2 = bl = !this.mustRecompile && !this.editorAdapter.isModified();
        if (!bl) {
            this.editorAdapter.insertUpdate(null);
            this.listenerSupport.fireModifiedContent();
            this.executable = null;
            if (this.editorToolbar.saveFile()) {
                File file = this.getCurrentFile();
                this.compiler.compile(file);
                this.messagesArray = this.compiler.getCompilerMessages();
                ErrorMessage[] errorMessageArray = new ErrorMessage[this.messagesArray.length + 1];
                System.arraycopy(this.messagesArray, 0, errorMessageArray, 1, this.messagesArray.length);
                errorMessageArray[0] = new ErrorMessage("Executed: " + this.compiler.getCompilerCommand() + "\n", -1);
                this.errorMessagesList.setListData(errorMessageArray);
                this.mustRecompile = this.messagesArray.length > 0;
                this.errorMessagesList.setOpaque(this.mustRecompile);
                this.errorMessagesList.setEnabled(this.mustRecompile);
                bl = !this.mustRecompile;
            }
        }
        return bl;
    }

    @Override
    protected EditorIoToolbar createEditorToolbar() {
        KaraGuiFactory karaGuiFactory = KaraGuiFactory.getInstance();
        return new EditorIoToolbar(this, karaGuiFactory.createEditorToolbar(karaGuiFactory.getFileChooser(), karaGuiFactory.getJavaSourceFileFilter()), this.getFileExtension());
    }

    @Override
    protected String getFileExtension() {
        return "java";
    }

    @Override
    protected TokenMarker getTokenMarker() {
        return new JavaTokenMarker();
    }
}

