/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.abstractscriptide;

import ch.karatojava.editor.EditorInterface;
import ch.karatojava.editor.EditorIoToolbar;
import ch.karatojava.editor.EditorWindowListener;
import ch.karatojava.interpreter.InterpreterListener;
import ch.karatojava.kapps.KaraEditorUiFactory;
import ch.karatojava.kapps.KaraGuiFactory;
import ch.karatojava.kapps.ProgramEditorFacadeInterface;
import ch.karatojava.kapps.WorldEditorFacadeInterface;
import ch.karatojava.kapps.abstractscriptide.AbstractScriptEditor;
import ch.karatojava.util.Configuration;
import ch.karatojava.util.GuiFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;

public abstract class AbstractScriptEditorFacade
implements ProgramEditorFacadeInterface {
    protected static final String FONT_SIZE_PROPERTY = "font size";
    protected AbstractScriptEditor scriptEditor;
    protected JFrame editorGui;
    protected JFileChooser compilerChooser;
    protected ActionListener fontSizeListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Integer n = (Integer)((JRadioButton)actionEvent.getSource()).getClientProperty(AbstractScriptEditorFacade.FONT_SIZE_PROPERTY);
            AbstractScriptEditorFacade.this.scriptEditor.setFontSize(n);
        }
    };

    @Override
    public void setWorldEditorFacade(WorldEditorFacadeInterface worldEditorFacadeInterface) {
    }

    @Override
    public JFrame getProgramEditorGui() {
        return this.editorGui;
    }

    @Override
    public EditorIoToolbar getProgramEditorIoToolbar() {
        return this.scriptEditor.getEditorToolbar();
    }

    @Override
    public EditorInterface getProgramEditor() {
        return this.scriptEditor;
    }

    @Override
    public JComponent getConfigGui() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBorder(GuiFactory.getInstance().createTitledBorder("language/$language/scriptide/setup/fonttitle"));
        JLabel jLabel = new JLabel(Configuration.getInstance().getString("language/$language/scriptide/setup/fontsize"));
        ButtonGroup buttonGroup = new ButtonGroup();
        jPanel2.add(jLabel);
        jPanel2.add(Box.createHorizontalStrut(6));
        jPanel2.add(this.createFontSizeButton(10, buttonGroup));
        JRadioButton jRadioButton = this.createFontSizeButton(12, buttonGroup);
        jRadioButton.doClick();
        jPanel2.add(jRadioButton);
        jPanel2.add(this.createFontSizeButton(14, buttonGroup));
        jPanel2.add(this.createFontSizeButton(16, buttonGroup));
        jPanel2.add(this.createFontSizeButton(18, buttonGroup));
        jPanel2.add(Box.createHorizontalGlue());
        jPanel.add(Box.createVerticalStrut(6));
        jPanel.add(jPanel2);
        return jPanel;
    }

    protected JRadioButton createFontSizeButton(int n, ButtonGroup buttonGroup) {
        JRadioButton jRadioButton = new JRadioButton(" " + n);
        jRadioButton.addActionListener(this.fontSizeListener);
        jRadioButton.putClientProperty(FONT_SIZE_PROPERTY, new Integer(n));
        buttonGroup.add(jRadioButton);
        return jRadioButton;
    }

    @Override
    public InterpreterListener[] getInterpreterListeners() {
        return new InterpreterListener[]{this.scriptEditor.getInterpreterListener(), new KaraEditorUiFactory.InterpreterListener(this.scriptEditor.getEditorToolbar())};
    }

    protected abstract AbstractScriptEditor getEditor();

    @Override
    public int getNumberOfInitSteps() {
        return 3;
    }

    @Override
    public int initialize(JProgressBar jProgressBar, JLabel jLabel, int n) {
        jLabel.setText("creating source code editor ...");
        this.scriptEditor = this.getEditor();
        jProgressBar.setValue(++n);
        jLabel.setText("creating file chooser ...");
        this.compilerChooser = new JFileChooser();
        this.compilerChooser.setMultiSelectionEnabled(false);
        jProgressBar.setValue(++n);
        jLabel.setText("creating source code editor gui ...");
        this.editorGui = this.createProgramEditorGui();
        jProgressBar.setValue(++n);
        return n;
    }

    protected JFrame createProgramEditorGui() {
        JFrame jFrame = KaraGuiFactory.getInstance().createProgramEditorFrame();
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add((Component)this.scriptEditor.getGui(), "Center");
        jFrame.setDefaultCloseOperation(0);
        jFrame.addWindowListener(new EditorWindowListener(false, this.scriptEditor.getEditorToolbar(), null));
        return jFrame;
    }
}

