/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.abstractscriptide;

import ch.karatojava.editor.AbstractEditor;
import ch.karatojava.editor.DocumentToEditorListenerAdapter;
import ch.karatojava.editor.EditorIoToolbar;
import ch.karatojava.interpreter.InterpreterListener;
import ch.karatojava.interpreter.InterpreterListenerAdapter;
import ch.karatojava.interpreter.RunnableInterface;
import ch.karatojava.kapps.abstractscriptide.ErrorMessage;
import ch.karatojava.util.Configuration;
import ch.karatojava.util.ExceptionActionListener;
import ch.karatojava.util.gui.jedit.JEditTextArea;
import ch.karatojava.util.gui.jedit.TextAreaDefaults;
import ch.karatojava.util.gui.jedit.TokenMarker;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class AbstractScriptEditor
extends AbstractEditor {
    protected static final ErrorMessage[] NO_MESSAGE = new ErrorMessage[0];
    protected static final Color MESSAGES_COLOR = new Color(255, 150, 150);
    protected static final Color COMPILE_ERROR_COLOR = new Color(220, 200, 200);
    protected static final Font FONT = new Font("DialogInput", 0, 12);
    protected static final int BUFFER_SIZE = 2048;
    protected JPanel editorPanel;
    protected EditorIoToolbar editorToolbar;
    protected JEditTextArea sourceTextArea;
    protected ErrorMessage[] messagesArray;
    protected JList errorMessagesList;
    protected DocumentToEditorListenerAdapter editorAdapter;
    protected JLabel lineNumberLabel;
    protected InterpreterListener interpreterListener = new InterpreterListenerAdapter(){
        protected boolean isEditable = true;
        protected MouseAdapter dummyMouse = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                ExceptionActionListener.reportException(AbstractScriptEditor.this.editorPanel, Configuration.getInstance().getString("language/$language/scriptide/dontmodifytitle"), new Exception(Configuration.getInstance().getString("language/$language/scriptide/dontmodify")));
            }
        };

        protected void setEditable(boolean bl) {
            JFrame jFrame = (JFrame)JOptionPane.getFrameForComponent(AbstractScriptEditor.this.editorPanel);
            Component component = jFrame.getGlassPane();
            if (!bl && this.isEditable) {
                component.addMouseListener(this.dummyMouse);
                component.setVisible(true);
            } else if (bl && !this.isEditable) {
                component.setVisible(false);
                component.removeMouseListener(this.dummyMouse);
            }
            AbstractScriptEditor.this.sourceTextArea.setEditable(bl);
            this.isEditable = bl;
        }

        @Override
        public void gotReady(RunnableInterface runnableInterface) {
            this.setEditable(false);
        }

        @Override
        public void stopped(RunnableInterface runnableInterface) {
            this.setEditable(true);
        }

        @Override
        public void errorStop(RunnableInterface runnableInterface) {
            this.setEditable(true);
        }
    };
    protected ListSelectionListener messageListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n;
            int n2 = AbstractScriptEditor.this.errorMessagesList.getSelectedIndex();
            if (n2 >= 0 && (n = AbstractScriptEditor.this.messagesArray[n2].getLineNumber()) >= 0) {
                String string = AbstractScriptEditor.this.sourceTextArea.getText();
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                for (int i = 0; i < n && n5 < string.length(); ++i) {
                    n3 = n4;
                    while (string.charAt(n5) != '\n' && n5 < string.length()) {
                        ++n5;
                    }
                    n4 = n5++;
                }
                AbstractScriptEditor.this.sourceTextArea.requestFocus();
                AbstractScriptEditor.this.sourceTextArea.setCaretPosition(n3);
                AbstractScriptEditor.this.sourceTextArea.select(n3 + 1, n4 + 1);
            }
            AbstractScriptEditor.this.errorMessagesList.setListData(NO_MESSAGE);
            AbstractScriptEditor.this.errorMessagesList.setListData(AbstractScriptEditor.this.messagesArray);
        }
    };

    public AbstractScriptEditor() {
        this.editorPanel = new JPanel();
        this.editorAdapter = new DocumentToEditorListenerAdapter(this.listenerSupport);
        this.editorToolbar = this.createEditorToolbar();
        JSplitPane jSplitPane = new JSplitPane(0);
        this.sourceTextArea = new JEditTextArea(this.getTextAreaDefaults());
        this.sourceTextArea.getDocument().addDocumentListener(this.editorAdapter);
        this.sourceTextArea.setFont(FONT);
        this.sourceTextArea.setOpaque(false);
        this.sourceTextArea.setTokenMarker(this.getTokenMarker());
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton();
        this.errorMessagesList = new JList();
        this.lineNumberLabel = new JLabel();
        this.editorPanel.setLayout(new BorderLayout());
        this.editorPanel.add((Component)this.editorToolbar, "North");
        this.editorPanel.add((Component)jSplitPane, "Center");
        this.editorPanel.add((Component)this.lineNumberLabel, "South");
        jSplitPane.setTopComponent(new JScrollPane(this.sourceTextArea));
        jSplitPane.setBottomComponent(jPanel);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setDividerLocation(400);
        this.sourceTextArea.getDocument().addDocumentListener(this.editorAdapter);
        this.sourceTextArea.addCaretListener(new LineNumberListener());
        this.sourceTextArea.setFont(FONT);
        this.sourceTextArea.setOpaque(false);
        this.newFile();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jButton, "North");
        jPanel.add((Component)new JScrollPane(this.errorMessagesList), "Center");
        this.errorMessagesList.setCellRenderer(new MessageListRenderer());
        this.errorMessagesList.addListSelectionListener(this.messageListener);
        this.errorMessagesList.setBackground(COMPILE_ERROR_COLOR);
        this.messagesArray = NO_MESSAGE;
    }

    protected abstract EditorIoToolbar createEditorToolbar();

    protected abstract TokenMarker getTokenMarker();

    protected abstract String getFileExtension();

    protected String getTemplate() {
        return Configuration.getInstance().getString("language/$language/$karamodel/template");
    }

    protected TextAreaDefaults getTextAreaDefaults() {
        TextAreaDefaults textAreaDefaults = TextAreaDefaults.getDefaults();
        textAreaDefaults.eolMarkers = false;
        textAreaDefaults.caretBlinks = true;
        textAreaDefaults.blockCaret = false;
        textAreaDefaults.lineHighlightColor = Color.yellow;
        textAreaDefaults.caretVisible = false;
        textAreaDefaults.paintInvalid = false;
        textAreaDefaults.bracketHighlightColor = Color.magenta;
        textAreaDefaults.cols = 40;
        textAreaDefaults.rows = 10;
        textAreaDefaults.tabsAsSpaces = true;
        return textAreaDefaults;
    }

    public ErrorMessage[] getMessagesArray() {
        return this.messagesArray;
    }

    public void setMessagesArray(ErrorMessage[] errorMessageArray) {
        this.messagesArray = errorMessageArray;
        this.errorMessagesList.setListData(this.messagesArray);
        this.errorMessagesList.setOpaque(errorMessageArray != null && errorMessageArray.length > 0);
        this.errorMessagesList.setEnabled(errorMessageArray != null && errorMessageArray.length > 0);
    }

    public JPanel getGui() {
        return this.editorPanel;
    }

    public void setFontSize(int n) {
        Font font = this.sourceTextArea.getFont();
        font = font.deriveFont(font.getStyle(), n);
        this.sourceTextArea.getPainter().setFont(font);
    }

    public InterpreterListener getInterpreterListener() {
        return this.interpreterListener;
    }

    public void resetErrorMessages() {
        this.errorMessagesList.setOpaque(false);
        this.errorMessagesList.setListData(NO_MESSAGE);
    }

    public EditorIoToolbar getEditorToolbar() {
        return this.editorToolbar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doSave(OutputStream outputStream) throws Exception {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(outputStream);
            printWriter.print(this.sourceTextArea.getText());
            this.resetErrorMessages();
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    @Override
    protected void doSetContent(Object object) {
        this.sourceTextArea.setText(object.toString());
        this.sourceTextArea.setCaretPosition(0);
    }

    @Override
    protected void doNewFile() {
        String string = this.getTemplate();
        this.sourceTextArea.setText(string);
        this.sourceTextArea.setCaretPosition(0);
    }

    @Override
    protected void resetModified() {
        this.resetErrorMessages();
        this.editorAdapter.resetModified();
    }

    @Override
    public Object create(InputStream inputStream) throws Exception {
        int n;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[2048];
        while ((n = inputStreamReader.read(cArray, 0, 2048)) != -1) {
            stringBuffer.append(cArray, 0, n);
        }
        inputStreamReader.close();
        return stringBuffer.toString();
    }

    public void loadExecutable(String string) throws Exception {
        this.editorAdapter.resetModified();
    }

    @Override
    public boolean isModified() {
        return this.editorAdapter.isModified();
    }

    @Override
    public Object getContent() {
        if (!JOptionPane.getFrameForComponent(this.editorPanel).isVisible()) {
            throw new RuntimeException(Configuration.getInstance().getString("language/$language/interpreter/progwinclosed"));
        }
        try {
            if (!this.editorToolbar.saveFile()) {
                return null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception.getMessage());
        }
        return this.sourceTextArea.getText();
    }

    protected class LineNumberListener
    implements CaretListener {
        private String rowNumberText = "Zeile: ";
        private String columnNumberText = ", Spalte: ";

        protected LineNumberListener() {
        }

        @Override
        public void caretUpdate(CaretEvent caretEvent) {
            String[] stringArray = AbstractScriptEditor.this.sourceTextArea.getText().split("\n");
            int n = caretEvent.getMark();
            int n2 = 0;
            int n3 = -1;
            int n4 = -1;
            for (int i = 0; i < stringArray.length && n3 == -1; ++i) {
                if (n2 <= n && n <= n2 + stringArray[i].length()) {
                    n3 = i;
                    n4 = n - n2;
                }
                n2 = n2 + stringArray[i].length() + 1;
            }
            if (n3 >= 0) {
                AbstractScriptEditor.this.lineNumberLabel.setText(this.rowNumberText + n3 + this.columnNumberText + n4);
            } else {
                AbstractScriptEditor.this.lineNumberLabel.setText("");
            }
        }
    }

    protected class MessageListRenderer
    extends JTextArea
    implements ListCellRenderer {
        private static final long serialVersionUID = -6313817226464992907L;

        public MessageListRenderer() {
            this.setFont(FONT);
            this.setOpaque(false);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setText(object.toString());
            if (bl) {
                this.setOpaque(true);
                this.setBackground(MESSAGES_COLOR);
            } else {
                this.setOpaque(false);
            }
            return this;
        }
    }
}

