/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps;

import ch.karatojava.editor.EditorIoToolbar;
import ch.karatojava.kapps.InterpreterFacadeInterface;
import ch.karatojava.kapps.KaraConfigDialog;
import ch.karatojava.kapps.KaraGuiFactory;
import ch.karatojava.kapps.ProgramEditorFacadeInterface;
import ch.karatojava.kapps.TasksFacadeInterface;
import ch.karatojava.kapps.WorldEditorFacadeInterface;
import ch.karatojava.util.Configuration;
import ch.karatojava.util.ExceptionActionListener;
import ch.karatojava.util.GuiFactory;
import java.awt.Dimension;
import java.awt.Frame;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class KaraGuiNorthPanel
extends JPanel {
    private static final long serialVersionUID = -1706435906468478558L;
    protected WorldEditorFacadeInterface worldEditorFacade;
    protected ProgramEditorFacadeInterface programEditorFacade;
    protected InterpreterFacadeInterface interpreterFacade;
    protected TasksFacadeInterface tasksFacade;
    protected JFrame tcFrame;
    protected KaraConfigDialog karaConfigDialog;
    protected JFrame helpFrame;

    public KaraGuiNorthPanel(WorldEditorFacadeInterface worldEditorFacadeInterface, ProgramEditorFacadeInterface programEditorFacadeInterface, InterpreterFacadeInterface interpreterFacadeInterface, TasksFacadeInterface tasksFacadeInterface) {
        this.worldEditorFacade = worldEditorFacadeInterface;
        this.programEditorFacade = programEditorFacadeInterface;
        this.interpreterFacade = interpreterFacadeInterface;
        this.tasksFacade = tasksFacadeInterface;
        this.karaConfigDialog = this.createKaraConfigDialog();
        String string = Configuration.getInstance().getString("karamodel/$karamodel/help/$language");
        if (string.equalsIgnoreCase("yes")) {
            this.helpFrame = KaraGuiFactory.getInstance().createHelpFrame();
        }
        this.tcFrame = tasksFacadeInterface.getTasksFrame();
        this.createGui();
    }

    protected KaraConfigDialog createKaraConfigDialog() {
        return new KaraConfigDialog((Frame)KaraGuiFactory.getInstance().getApplicationFrame(), this.worldEditorFacade, this.programEditorFacade, this.interpreterFacade);
    }

    protected void initButtonPanel(JPanel jPanel, JButton jButton) {
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(Box.createRigidArea(new Dimension(0, 12)));
        jPanel.add(jButton);
        jButton.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(8, 2, 8, 2)));
    }

    protected void createGui() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton();
        JPanel jPanel2 = new JPanel();
        JButton jButton2 = new JButton();
        JButton jButton3 = GuiFactory.getInstance().createImageIconButton("icons/preferences");
        JButton jButton4 = null;
        jButton.addActionListener(new ExceptionActionListener(this, "openProgramWindow"));
        jButton3.addActionListener(new ExceptionActionListener(this, "openConfigWindow"));
        if (this.helpFrame != null) {
            jButton4 = GuiFactory.getInstance().createImageIconButton("icons/help");
            jButton4.addActionListener(new ExceptionActionListener(this, "openHelpWindow"));
            jButton4.setBorder(BorderFactory.createEmptyBorder(14, 2, 8, 2));
        }
        this.setLayout(new BoxLayout(this, 0));
        jButton.setText(Configuration.getInstance().getString("language/$language/programming"));
        this.initButtonPanel(jPanel, jButton);
        jButton2.setText(Configuration.getInstance().getString("language/$language/tasks/gui/buttontext"));
        this.initButtonPanel(jPanel2, jButton2);
        jButton3.setBorder(BorderFactory.createEmptyBorder(14, 2, 8, 2));
        this.add(Box.createHorizontalStrut(2));
        this.add(jPanel);
        this.add(Box.createHorizontalGlue());
        EditorIoToolbar editorIoToolbar = this.worldEditorFacade.getWorldEditorIoToolbar();
        if (editorIoToolbar != null) {
            this.add(this.worldEditorFacade.getWorldEditorIoToolbar());
        }
        if (this.tcFrame != null) {
            jButton2.addActionListener(new ExceptionActionListener(this, "openTasksWindow"));
            this.add(Box.createHorizontalGlue());
            this.add(jPanel2);
        }
        this.add(Box.createHorizontalGlue());
        this.add(jButton3);
        this.add(Box.createHorizontalStrut(4));
        if (jButton4 != null) {
            this.add(jButton4);
            this.add(Box.createHorizontalStrut(2));
        }
    }

    public void openProgramWindow() {
        JFrame jFrame = this.programEditorFacade.getProgramEditorGui();
        if (!jFrame.isVisible()) {
            jFrame.setVisible(true);
            if (!this.programEditorFacade.getProgramEditor().hasContent()) {
                this.programEditorFacade.getProgramEditor().newFile();
            }
        } else {
            jFrame.toFront();
        }
    }

    public void openConfigWindow() {
        this.karaConfigDialog.setVisible(true);
    }

    public void openHelpWindow() {
        this.helpFrame.setVisible(true);
    }

    public void openTasksWindow() {
        this.tcFrame.setVisible(true);
    }
}

