/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.interpreter;

import ch.karatojava.interpreter.InterpreterListenerSupport;
import ch.karatojava.interpreter.RunnableInterface;
import ch.karatojava.interpreter.StepableInterface;
import ch.karatojava.interpreter.StepableInterpreter;
import ch.karatojava.interpreter.StepperInterface;
import ch.karatojava.util.CyclicBarrier;

public class StepableInterpreterThread
implements Runnable {
    private boolean pauseInterpreter;
    private boolean stopInterpreter;
    protected StepableInterpreter interpreter;
    protected StepperInterface stepper;
    protected InterpreterListenerSupport listenerSupport;
    protected CyclicBarrier barrier;

    public StepableInterpreterThread(StepableInterpreter stepableInterpreter, StepperInterface stepperInterface, CyclicBarrier cyclicBarrier) {
        this.interpreter = stepableInterpreter;
        this.stepper = stepperInterface;
        this.listenerSupport = stepableInterpreter.getListenerSupport();
        this.barrier = cyclicBarrier;
    }

    public void signalStopInterpreter() {
        this.stopInterpreter = true;
    }

    public void signalPauseInterpreter() {
        this.pauseInterpreter = true;
    }

    protected void sleep() {
        try {
            Thread.sleep(this.interpreter.getWaitInterval());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.barrier.waitBarrierIgnoreInterrupt("thread");
        while (true) {
            Object object;
            try {
                while (true) {
                    boolean bl = false;
                    this.pauseInterpreter = false;
                    this.stopInterpreter = false;
                    this.barrier.waitBarrierIgnoreInterrupt("thread1");
                    object = this.interpreter;
                    synchronized (object) {
                        this.stepper.getReady();
                        this.listenerSupport.fireGotReady();
                    }
                    object = this.barrier;
                    synchronized (object) {
                        if (!this.stopInterpreter) {
                            this.barrier.waitBarrierIgnoreInterrupt("thread2");
                        }
                    }
                    object = this.interpreter;
                    synchronized (object) {
                        if (this.interpreter.getState() == RunnableInterface.State.RUNNING) {
                            this.listenerSupport.firePlaying();
                        }
                    }
                    while (!this.stopInterpreter && !bl) {
                        object = this.interpreter;
                        synchronized (object) {
                            this.stepper.beginCompositeStep();
                            this.listenerSupport.fireBeginCompositeStep();
                        }
                        do {
                            this.sleep();
                            object = this.interpreter;
                            synchronized (object) {
                                this.stepper.executeStep();
                                this.listenerSupport.fireStepped();
                            }
                        } while (!this.stopInterpreter && !this.stepper.compositeStepFinished());
                        object = this.interpreter;
                        synchronized (object) {
                            this.stepper.endCompositeStep();
                            this.listenerSupport.fireEndCompositeStep();
                            bl = this.stepper.executionFinished();
                            if (this.stopInterpreter || bl || (object = this.interpreter.getState()) != StepableInterface.State.STEPPING && !this.pauseInterpreter) continue;
                        }
                        Object object2 = this.interpreter;
                        synchronized (object2) {
                            if (this.pauseInterpreter) {
                                this.listenerSupport.firePausing();
                            }
                        }
                        object2 = this.barrier;
                        synchronized (object2) {
                            if (!this.stopInterpreter) {
                                this.barrier.waitBarrierIgnoreInterrupt("thread3");
                            }
                            this.pauseInterpreter = false;
                        }
                        object2 = this.interpreter;
                        synchronized (object2) {
                            if (!this.stopInterpreter) {
                                this.listenerSupport.firePlaying();
                            }
                        }
                    }
                    object = this.interpreter;
                    synchronized (object) {
                        if (bl) {
                            this.interpreter.executionDone();
                        }
                        this.listenerSupport.fireStopped();
                    }
                }
            }
            catch (Exception exception) {
                object = this.barrier;
                synchronized (object) {
                    if (this.barrier.sleeping() > 0) {
                        this.barrier.waitBarrierIgnoreInterrupt("thread.errorstop");
                    }
                }
                object = this.interpreter;
                synchronized (object) {
                    this.interpreter.getExceptionHandler().handleException(exception);
                    this.interpreter.executionDone();
                    this.listenerSupport.fireErrorStop();
                }
                continue;
            }
            break;
        }
    }
}

