/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.interpreter;

import ch.karatojava.interpreter.InterpreterListener;
import ch.karatojava.interpreter.SchedulerListener;
import ch.karatojava.interpreter.StepperInterface;
import java.util.ArrayList;
import java.util.Hashtable;

public abstract class Scheduler
implements StepperInterface {
    protected Hashtable<Object, StepperInterface> steppers;
    protected Hashtable<Object, Object> clientProperties = new Hashtable();
    protected ArrayList<SchedulerListener> listeners = new ArrayList();

    public void initSteppers() {
        this.steppers = new Hashtable();
    }

    public void setStepper(StepperInterface stepperInterface, Object object) {
        this.steppers.put(object, stepperInterface);
    }

    public abstract StepperInterface getCurrentStepper();

    public StepperInterface getStepper(Object object) {
        return this.steppers.get(object);
    }

    public InterpreterListener getInterpreterListener() {
        return null;
    }

    public void setClientProperty(Object object, Object object2) {
        this.clientProperties.put(object, object2);
    }

    public Object getClientProperty(Object object) {
        return this.clientProperties.get(object);
    }

    public abstract void setStepperPriority(Object var1, int var2);

    public abstract int getStepperPriority(Object var1);

    public void addListener(SchedulerListener schedulerListener) {
        if (!this.listeners.contains(schedulerListener)) {
            this.listeners.add(schedulerListener);
        }
    }

    public void removeListener(SchedulerListener schedulerListener) {
        if (this.listeners.contains(schedulerListener)) {
            this.listeners.remove(schedulerListener);
        }
    }

    protected void firePutToSleep(Object object) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).processPutToSleep(object);
        }
    }

    protected void fireWakeUp(Object object) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).processWakeUp(object);
        }
    }

    protected void fireTerminated(Object object) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).processTerminated(object);
        }
    }

    protected void fireActivated(Object object) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).processActivated(object);
        }
    }

    protected void fireDeactivated(Object object) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).processDeactivated(object);
        }
    }

    protected void firePriorityChanged(Object object, int n) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).processPriorityChanged(object, n);
        }
    }

    protected void fireClientPropertySet(Object object, Object object2) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).processClientPropertySet(object, object2);
        }
    }
}

