/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.interpreter;

import ch.karatojava.interpreter.ExceptionHandler;
import ch.karatojava.interpreter.InterpreterException;
import ch.karatojava.interpreter.InterpreterListener;
import java.util.ArrayList;

public interface RunnableInterface {
    public void setExceptionHandler(ExceptionHandler var1);

    public ExceptionHandler getExceptionHandler();

    public void play() throws InterpreterException;

    public void pause();

    public State getState();

    public void stop();

    public void setWaitInterval(int var1);

    public int getWaitInterval();

    public void addInterpreterListener(InterpreterListener var1);

    public void removeInterpreterListener(InterpreterListener var1);

    public void checkThreadState();

    public static class State {
        public static final State IDLE = new State("idle", new State[]{RUNNING});
        public static final State RUNNING = new State("running", new State[]{IDLE, PAUSING});
        public static final State PAUSING = new State("pausing", new State[]{RUNNING});
        protected String name;
        protected ArrayList<State> possibleNextStates;

        protected State(String string, State[] stateArray) {
            this.name = string;
            this.possibleNextStates = new ArrayList();
            for (int i = 0; i < stateArray.length; ++i) {
                this.possibleNextStates.add(stateArray[i]);
            }
        }

        public boolean isNextStatePossible(State state) {
            return this.possibleNextStates.contains(state);
        }

        public String toString() {
            return "RunnableInterface.State." + this.name;
        }
    }
}

