/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.interpreter;

import ch.karatojava.interpreter.InterpreterListener;
import ch.karatojava.interpreter.RunnableInterface;
import java.util.ArrayList;
import java.util.List;

public class InterpreterListenerSupport {
    protected List<InterpreterListener> listeners = new ArrayList<InterpreterListener>();
    protected InterpreterListener[] listenersArray = new InterpreterListener[this.listeners.size()];
    protected RunnableInterface interpreter;

    public InterpreterListenerSupport(RunnableInterface runnableInterface) {
        this.listeners.toArray(this.listenersArray);
        this.interpreter = runnableInterface;
    }

    public void addInterpreterListener(InterpreterListener interpreterListener) {
        this.listeners.add(interpreterListener);
        this.listenersArray = new InterpreterListener[this.listeners.size()];
        this.listeners.toArray(this.listenersArray);
    }

    public void removeInterpreterListener(InterpreterListener interpreterListener) {
        this.listeners.remove(interpreterListener);
        this.listenersArray = new InterpreterListener[this.listeners.size()];
        this.listeners.toArray(this.listenersArray);
    }

    public void fireGotReady() {
        for (int i = 0; i < this.listenersArray.length; ++i) {
            this.listenersArray[i].gotReady(this.interpreter);
        }
    }

    public void firePlaying() {
        for (int i = 0; i < this.listenersArray.length; ++i) {
            this.listenersArray[i].playing(this.interpreter);
        }
    }

    public void firePausing() {
        for (int i = 0; i < this.listenersArray.length; ++i) {
            this.listenersArray[i].pausing(this.interpreter);
        }
    }

    public void fireStepped() {
        for (int i = 0; i < this.listenersArray.length; ++i) {
            this.listenersArray[i].stepped(this.interpreter);
        }
    }

    public void fireBeginCompositeStep() {
        for (int i = 0; i < this.listenersArray.length; ++i) {
            this.listenersArray[i].beginCompositeStep(this.interpreter);
        }
    }

    public void fireEndCompositeStep() {
        for (int i = 0; i < this.listenersArray.length; ++i) {
            this.listenersArray[i].endCompositeStep(this.interpreter);
        }
    }

    public void fireStopped() {
        for (int i = 0; i < this.listenersArray.length; ++i) {
            this.listenersArray[i].stopped(this.interpreter);
        }
    }

    public void fireErrorStop() {
        for (int i = 0; i < this.listenersArray.length; ++i) {
            this.listenersArray[i].errorStop(this.interpreter);
        }
    }
}

