/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.editor;

import ch.karatojava.editor.EditorIoToolbar;
import ch.karatojava.editor.EditorToolbarUiFactoryInterface;
import ch.karatojava.editor.ExampleFileFilter;
import ch.karatojava.util.ExceptionActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;

public class EditorToolbarUiFactory
implements EditorToolbarUiFactoryInterface {
    private static final String NONAME = "untitled";
    private static final int H_STRUT = 4;
    protected EditorIoToolbar editorToolbar;

    @Override
    public void setEditorToolbar(EditorIoToolbar editorIoToolbar) {
        this.editorToolbar = editorIoToolbar;
    }

    @Override
    public JFileChooser getFileChooser() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setMultiSelectionEnabled(false);
        return jFileChooser;
    }

    @Override
    public ExampleFileFilter getFileFilter() {
        return new ExampleFileFilter("txt", "Text files");
    }

    @Override
    public int getStrut() {
        return 4;
    }

    @Override
    public String getNoNameTitle() {
        return NONAME;
    }

    @Override
    public String getNotEnabledException(EditorIoToolbar.Command command) {
        return "Command not enabled!";
    }

    @Override
    public JButton createButton(EditorIoToolbar.Command command) {
        JButton jButton = null;
        jButton = command == EditorIoToolbar.Command.NEW ? new JButton(this.loadImageIcon("new.gif")) : (command == EditorIoToolbar.Command.LOAD ? new JButton(this.loadImageIcon("load.gif")) : (command == EditorIoToolbar.Command.SAVE ? new JButton(this.loadImageIcon("save.gif")) : (command == EditorIoToolbar.Command.SAVEAS ? new JButton(this.loadImageIcon("saveas.gif")) : new JButton("unknown"))));
        jButton.setBorderPainted(false);
        return jButton;
    }

    @Override
    public TitledBorder createTitledBorder() {
        return new TitledBorder(BorderFactory.createLineBorder(UIManager.getColor("TitledBorder.titleColor"), 2), this.getNoNameTitle());
    }

    @Override
    public int askSave() {
        return JOptionPane.showConfirmDialog(JOptionPane.getFrameForComponent(this.editorToolbar), "Do you want to save?", "Save?", 1);
    }

    @Override
    public int askOverwrite(String string) {
        return JOptionPane.showConfirmDialog(JOptionPane.getFrameForComponent(this.editorToolbar), "There exists a file with the name \n" + string + ".\n" + "Do want to overwrite the existing file?", "Overwrite?", 1);
    }

    @Override
    public void reportException(Exception exception) {
        ExceptionActionListener.reportException(this.editorToolbar, "Fatal error", new Exception("Could not save file! \nContent may be lost."));
    }

    private ImageIcon loadImageIcon(String string) {
        return new ImageIcon(EditorToolbarUiFactory.class.getResource("/editoricons/" + string));
    }
}

