/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.fsmgui.view;

import ch.ethz.fsmgui.FSMEvent;
import ch.ethz.fsmgui.FSMModelListener;
import ch.ethz.fsmgui.FSMViewListener;
import ch.ethz.fsmgui.model.FSMModelInterface;
import ch.ethz.fsmgui.model.FSMStateInterface;
import ch.ethz.fsmgui.view.CircleLayouter;
import ch.ethz.fsmgui.view.Component3DRenderer;
import ch.ethz.fsmgui.view.ComponentContrastRenderer;
import ch.ethz.fsmgui.view.ComponentDiodeRenderer;
import ch.ethz.fsmgui.view.ComponentRenderer;
import ch.ethz.fsmgui.view.OrganicLayouter;
import ch.ethz.fsmgui.view.State;
import ch.ethz.fsmgui.view.Transition;
import ch.ethz.fsmgui.view.TransitionLabel;
import ch.ethz.fsmgui.view.ZoomNDragablePane;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.JPanel;

public class FSMView
extends JPanel
implements FSMModelListener {
    private static final long serialVersionUID = 1L;
    private final boolean PAULI_PRINCIPLE = true;
    private boolean LIVE_UPDATE = true;
    private boolean FIT_OWED = false;
    private boolean FIT_INTO_GRID = false;
    public boolean TOPOLOGY_CHANGED = true;
    public boolean DRAWN_FIRST_TIME = false;
    public boolean REPAINT_SOPHISTICATED = true;
    public boolean REPAINT_SOPHISTICATED_ALWAYS = true;
    int repaintSophisticatedTransLabelLimit = 12;
    private FSMModelInterface model;
    public Vector<State> states = new Vector();
    private Hashtable<FSMStateInterface, State> stateMap = new Hashtable();
    private Vector<Transition> transitions = new Vector();
    private State selectedState = null;
    private Transition selectedTransition = null;
    private ComponentRenderer componentRenderer;
    private Hashtable<String, ComponentRenderer> renderers = new Hashtable();
    private Vector<FSMViewListener> fsmViewListeners = new Vector();
    private Rectangle faBounds = new Rectangle(50, 50, 50, 50);
    int nameDist = 20;
    int fitMargin = 10;
    public int minStateDist = 70;
    int labelToStateDist = 8;
    int gridWidth = this.minStateDist + 1;
    protected ZoomNDragablePane zdPane = new ZoomNDragablePane();
    private Color bgrColor = Color.white;
    private Point deliveryPoint = new Point();
    private int[] statesX;
    private int[] statesY;
    private int movingStateIndex;
    private boolean[] stateDist = null;
    private boolean[] radDist = null;
    private double[] cos;
    private double[] sin;

    public void registerRenderer(String string, ComponentRenderer componentRenderer) {
        this.renderers.put(string, componentRenderer);
    }

    public void chooseRenderer(String string) {
        this.componentRenderer = this.renderers.get(string);
        this.radDist = this.fillDistArray((int)this.componentRenderer.getStateDiameter(0.0) / 2 + this.labelToStateDist, this.radDist);
        for (int i = 0; i < this.states.size(); ++i) {
            this.states.elementAt(i).setFont(null);
        }
        this.TOPOLOGY_CHANGED = true;
    }

    public String getChosenRendererKey() {
        return this.componentRenderer.getKey();
    }

    public ComponentRenderer getRenderer(String string) {
        if (string != null) {
            return this.renderers.get(string);
        }
        return null;
    }

    public void addFSMViewListener(FSMViewListener fSMViewListener) {
        this.fsmViewListeners.add(fSMViewListener);
    }

    public void removeFSMViewListener(FSMViewListener fSMViewListener) {
        this.fsmViewListeners.remove(fSMViewListener);
    }

    private void notifyStateSelection(State state) {
        for (int i = 0; i < this.fsmViewListeners.size(); ++i) {
            this.fsmViewListeners.elementAt(i).stateSelected(state);
        }
    }

    public void setMinStateDist(int n) {
        this.minStateDist = n;
    }

    public int getMinStateDist() {
        return this.minStateDist;
    }

    public void setGridWidth(int n) {
        this.gridWidth = n;
    }

    public int getGridWidth() {
        return this.gridWidth;
    }

    public void alignWithGrid(boolean bl) {
        this.FIT_INTO_GRID = bl;
        if (bl) {
            this.rearrangeStates();
        }
    }

    public boolean isGridAligned() {
        return this.FIT_INTO_GRID;
    }

    public void setScale(double d) {
        this.zdPane.setScale(d);
    }

    public void setTranslation(double d, double d2) {
        this.zdPane.setTranslation(d, d2);
    }

    public void setScaleRef(int n, int n2) {
        this.zdPane.setScaleRef(n, n2);
    }

    public void setTranslationRef(int n, int n2) {
        this.zdPane.setTranslationRef(n, n2);
    }

    public void scale(int n) {
        this.zdPane.scale(n);
    }

    public void translate(int n, int n2) {
        this.zdPane.translate(n, n2);
    }

    public Point2D getModelCoords(Point2D point2D, int n, int n2) {
        this.zdPane.getModelCoords(point2D, n, n2);
        return point2D;
    }

    public Point2D getViewCoords(Point2D point2D, double d, double d2) {
        this.zdPane.getViewCoords(point2D, d, d2);
        return point2D;
    }

    public FSMView(FSMModelInterface fSMModelInterface) {
        this.registerRenderer("3D", new Component3DRenderer(this));
        this.registerRenderer("Contrast", new ComponentContrastRenderer(this));
        this.registerRenderer("Diode", new ComponentDiodeRenderer(this));
        this.chooseRenderer("Contrast");
        this.zdPane.setScaleRange(0.2, 6.0);
        this.fillCosSinArrays();
        this.stateDist = this.fillDistArray(this.minStateDist, this.stateDist);
        this.radDist = this.fillDistArray((int)this.componentRenderer.getStateDiameter(0.0) / 2 + this.labelToStateDist, this.radDist);
        this.setModel(fSMModelInterface);
    }

    public void setModel(FSMModelInterface fSMModelInterface) {
        if (this.model != null) {
            this.model.removeFSMModelListener(this);
        }
        this.model = fSMModelInterface;
        if (this.model != null) {
            fSMModelInterface.addFSMModelListener(this);
        }
        this.adoptFA(fSMModelInterface);
    }

    public FSMModelInterface getModel() {
        return this.model;
    }

    private void adoptFA(FSMModelInterface fSMModelInterface) {
        int n;
        if (fSMModelInterface == null) {
            return;
        }
        this.clear();
        this.LIVE_UPDATE = false;
        this.DRAWN_FIRST_TIME = false;
        boolean bl = false;
        Set set = fSMModelInterface.getAllStates();
        if (set == null) {
            return;
        }
        for (Object object : set) {
            if (("" + object.getX()).equals("NaN") || ("" + object.getY()).equals("NaN")) {
                bl = true;
                object.setPosition(0.0, 0.0);
            }
            this.addState((FSMStateInterface)object);
        }
        for (n = 0; n < this.states.size(); ++n) {
            Object object;
            object = this.states.elementAt(n);
            Set set2 = ((State)object).model.getInputs();
            if (null == set2) continue;
            for (Object e : set2) {
                Iterator iterator = ((State)object).model.getNextStateSet(e).iterator();
                while (iterator.hasNext()) {
                    this.attachTransition(this.addTransition((State)object, e), this.stateMap.get(iterator.next()));
                }
            }
        }
        if (bl) {
            n = 1;
            n = CircleLayouter.layout(this) ? 1 : 0;
            if (n == 0) {
                OrganicLayouter.layout(this);
            }
        } else {
            this.rearrangeStates();
        }
        this.selectTransition(null);
        this.fit();
        this.setLiveUpdate(true);
    }

    public void clear() {
        this.stateMap.clear();
        this.states.clear();
        this.transitions.clear();
        this.updateView(true);
    }

    @Override
    public void notify(FSMEvent fSMEvent) {
        this.REPAINT_SOPHISTICATED = true;
        switch (fSMEvent.getId()) {
            case 1: {
                this.addState(fSMEvent.getState());
                break;
            }
            case 2: {
                this.deleteState(fSMEvent.getState());
                break;
            }
            case 6: {
                this.setStatePosition(fSMEvent.getState(), fSMEvent.getState().getX(), fSMEvent.getState().getY());
                break;
            }
            case 5: {
                this.setStateLabel(fSMEvent.getState(), fSMEvent.getState().getLabel());
                break;
            }
            case 3: {
                this.setStateAccepting(fSMEvent.getState(), fSMEvent.getState().isAccepting());
                break;
            }
            case 4: {
                this.setStartState(this.model.getStartState());
                break;
            }
            case 9: {
                this.clear();
                break;
            }
            case 7: {
                this.addTransition(fSMEvent.getInput(), fSMEvent.getFromState(), fSMEvent.getToState());
                if (this.transitions.size() <= this.repaintSophisticatedTransLabelLimit) break;
                this.REPAINT_SOPHISTICATED_ALWAYS = false;
                break;
            }
            case 8: {
                this.deleteTransition(fSMEvent.getInput(), fSMEvent.getFromState(), fSMEvent.getToState());
                if (this.transitions.size() >= this.repaintSophisticatedTransLabelLimit) break;
                this.REPAINT_SOPHISTICATED_ALWAYS = true;
                break;
            }
            case 12: {
                this.updateView(false);
                break;
            }
            case 13: {
                Hashtable hashtable = fSMEvent.getMarks();
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    Object k = enumeration.nextElement();
                    if (k instanceof FSMStateInterface) {
                        this.markState((FSMStateInterface)k, hashtable.get(k));
                        continue;
                    }
                    if (!(k instanceof Object[])) continue;
                    Object[] objectArray = (Object[])k;
                    this.markTransition((FSMStateInterface)objectArray[0], (FSMStateInterface)objectArray[1], hashtable.get(k));
                }
                break;
            }
            case 14: {
                for (int i = 0; i < this.states.size(); ++i) {
                    State state = this.states.elementAt(i);
                    state.setMark(ComponentRenderer.MARK_NOT_MARKED);
                    for (int j = 0; j < state.outTransitions.size(); ++j) {
                        state.outTransitions.elementAt(j).setMark(ComponentRenderer.MARK_NOT_MARKED);
                    }
                }
                this.updateView(false);
            }
            default: {
                this.updateView(false);
            }
        }
    }

    public void addState(FSMStateInterface fSMStateInterface) {
        if (null == fSMStateInterface) {
            return;
        }
        Rectangle rectangle = this.getFABounds();
        State state = new State(fSMStateInterface);
        this.stateMap.put(fSMStateInterface, state);
        this.states.add(state);
        Point point = ("" + fSMStateInterface.getX()).equals("NaN") || ("" + fSMStateInterface.getY()).equals("NaN") ? this.getNearestFreePoint(state, rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2) : this.getNearestFreePoint(state, (int)fSMStateInterface.getX(), (int)fSMStateInterface.getY());
        state.setCenter(point.x, point.y);
        this.updateView(true);
    }

    public void deleteState(FSMStateInterface fSMStateInterface) {
        if (null == fSMStateInterface) {
            return;
        }
        State state = this.stateMap.remove(fSMStateInterface);
        this.states.remove(state);
        for (int i = 0; i < this.transitions.size(); ++i) {
            Transition transition = this.transitions.elementAt(i);
            if (transition.from != state && transition.to != state) continue;
            this.removeTransition(transition);
            --i;
        }
        this.updateView(true);
    }

    public void setStatePosition(FSMStateInterface fSMStateInterface, double d, double d2) {
        if (null == fSMStateInterface) {
            return;
        }
        State state = this.stateMap.get(fSMStateInterface);
        if (state != null) {
            state.setCenter(d, d2);
        }
        this.updateView(true);
    }

    public void setStateViewPosition(FSMStateInterface fSMStateInterface, int n, int n2) {
        if (null == fSMStateInterface) {
            return;
        }
        State state = this.stateMap.get(fSMStateInterface);
        if (state != null) {
            Point2D point2D = new Point2D.Double();
            this.getModelCoords(point2D, n, n2);
            point2D = this.getNearestFreePoint(state, (int)point2D.getX(), (int)point2D.getY());
            state.setCenter(point2D.getX(), point2D.getY());
            fSMStateInterface.setPosition(point2D.getX(), point2D.getY());
        }
        this.updateView(true);
    }

    public void setStateLabel(FSMStateInterface fSMStateInterface, Object object) {
        if (null == fSMStateInterface) {
            return;
        }
        this.stateMap.get(fSMStateInterface).setLabel(object);
        this.updateView(false);
    }

    public void setStateAccepting(FSMStateInterface fSMStateInterface, boolean bl) {
        if (null == fSMStateInterface) {
            return;
        }
        this.stateMap.get(fSMStateInterface).setAccepting(bl);
        this.updateView(false);
    }

    public void setStartState(FSMStateInterface fSMStateInterface) {
        if (null == fSMStateInterface) {
            return;
        }
        for (int i = 0; i < this.states.size(); ++i) {
            this.states.elementAt(i).setStart(false);
        }
        this.stateMap.get(fSMStateInterface).setStart(true);
        this.updateView(false);
    }

    public void addTransition(Object object, FSMStateInterface fSMStateInterface, FSMStateInterface fSMStateInterface2) {
        if (null == fSMStateInterface || null == fSMStateInterface2) {
            return;
        }
        this.attachTransition(this.addTransition(this.stateMap.get(fSMStateInterface), object), this.stateMap.get(fSMStateInterface2));
        this.updateView(true);
    }

    public void deleteTransition(Object object, FSMStateInterface fSMStateInterface, FSMStateInterface fSMStateInterface2) {
        if (null == fSMStateInterface || null == fSMStateInterface2) {
            return;
        }
        Vector<Transition> vector = this.stateMap.get((Object)fSMStateInterface).outTransitions;
        for (int i = 0; i < vector.size(); ++i) {
            Transition transition = vector.elementAt(i);
            if (transition.to.model != fSMStateInterface2) continue;
            transition.label.removeInput(object);
            if (null != transition.label.getLabelString()) continue;
            this.transitions.remove(transition);
            transition.from.removeOutTransition(transition);
            transition.to.removeInTransition(transition);
        }
        this.updateView(true);
    }

    public void markState(FSMStateInterface fSMStateInterface, Object object) {
        if (null == fSMStateInterface) {
            return;
        }
        State state = this.stateMap.get(fSMStateInterface);
        if (null != state) {
            state.setMark(object);
        }
        this.updateView(false);
    }

    public void markTransition(FSMStateInterface fSMStateInterface, FSMStateInterface fSMStateInterface2, Object object) {
        Transition transition;
        if (fSMStateInterface != null && fSMStateInterface2 != null && null != (transition = this.getTransition(this.stateMap.get(fSMStateInterface), this.stateMap.get(fSMStateInterface2)))) {
            transition.setMark(object);
            this.updateView(false);
        }
    }

    public String smallestFreeQLabel() {
        int n;
        int[] nArray = new int[this.states.size() + 1];
        for (n = 0; n < this.states.size(); ++n) {
            int n2 = this.states.size();
            try {
                n2 = Integer.parseInt(this.states.elementAt(n).getLabel().substring(1));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n2 >= this.states.size()) continue;
            nArray[n2] = 1;
        }
        for (n = 0; n < this.states.size(); ++n) {
            if (nArray[n] != 0) continue;
            return "q" + n;
        }
        return "q" + this.states.size();
    }

    public String uniqueStateLabel(String string) {
        State state = null;
        for (int i = 0; i < this.states.size(); ++i) {
            state = this.states.elementAt(i);
            if (!state.getLabel().equals(string)) continue;
            return this.uniqueStateLabel("#" + string);
        }
        return string;
    }

    public void rearrangeStates() {
        Object[] objectArray = this.states.toArray();
        this.states.clear();
        for (int i = 0; i < objectArray.length; ++i) {
            this.states.add((State)objectArray[i]);
            FSMStateInterface fSMStateInterface = ((State)objectArray[i]).model;
            Point point = this.getNearestFreePoint(this.stateMap.get(fSMStateInterface), (int)fSMStateInterface.getX(), (int)fSMStateInterface.getY());
            if (null == point || (int)fSMStateInterface.getX() == point.x && (int)fSMStateInterface.getY() == point.y) continue;
            fSMStateInterface.setPosition(point.x, point.y);
        }
        this.fit();
        this.updateView(true);
    }

    public boolean onMouseOver(State state, int n, int n2) {
        return this.componentRenderer.onMouseOver(state, (double)n, (double)n2);
    }

    public void grabState(State state, double d, double d2) {
        for (int i = 0; i < this.states.size(); ++i) {
            this.states.elementAt(i).release();
        }
        state.grab(d, d2);
    }

    public void selectState(State state, boolean bl) {
        this.selectedState = state;
        if (bl) {
            for (int i = 0; i < this.states.size(); ++i) {
                this.states.elementAt(i).setSelected(false);
            }
            this.notifyStateSelection(state);
        }
        if (state != null) {
            this.selectedState.setSelected(bl);
        }
    }

    public State getSelectedState() {
        return this.selectedState;
    }

    public Transition getSelectedTransition() {
        return this.selectedTransition;
    }

    public void dehighlightStates() {
        for (int i = 0; i < this.states.size(); ++i) {
            State state = this.states.elementAt(i);
            state.setBorderHighlighted(false);
            state.setCenterHighlighted(false);
            state.SHOW_WHOLE_LABEL = false;
        }
        this.updateView(false);
    }

    public void dehighlightTransitions() {
        for (int i = 0; i < this.transitions.size(); ++i) {
            Transition transition = this.transitions.elementAt(i);
            transition.setHighlighted(false);
        }
        this.updateView(false);
    }

    public State getStateAt(double d, double d2) {
        State state = null;
        State state2 = null;
        for (int i = 0; i < this.states.size(); ++i) {
            state = this.states.elementAt(i);
            if (!this.componentRenderer.contains(state, d, d2)) continue;
            state2 = state;
        }
        return state2;
    }

    public State getState(FSMStateInterface fSMStateInterface) {
        if (fSMStateInterface == null) {
            return null;
        }
        return this.stateMap.get(fSMStateInterface);
    }

    public State getState(int n) {
        return this.states.elementAt(n);
    }

    public int getNofStates() {
        return this.stateMap.size();
    }

    protected Object[] getStates() {
        return this.states.toArray();
    }

    public int getNofTransitions() {
        return this.transitions.size();
    }

    public Transition getTransition(int n) {
        return this.transitions.elementAt(n);
    }

    protected void calcTransitionCoords(Transition transition) {
        this.componentRenderer.calcTransitionCoords(transition);
    }

    public void moveState(State state, double d, double d2) {
        if (null != state) {
            double d3 = d - state.mouseRefX;
            double d4 = d2 - state.mouseRefY;
            Point point = this.getNearestFreePoint(state, (int)d3, (int)d4);
            if (null != point) {
                state.setCenter(point.x, point.y);
            }
            this.updateView(true);
        }
    }

    public Transition addTransition(State state, Object object) {
        Transition transition = null;
        if (null != state) {
            transition = new Transition(state, object);
            this.transitions.add(transition);
            state.addOutTransition(transition);
            this.selectTransition(transition);
            this.updateView(true);
        }
        return transition;
    }

    public Transition addTransition(State state) {
        return this.addTransition(state, null);
    }

    public void removeTransition(Transition transition) {
        if (null != transition) {
            transition.from.removeOutTransition(transition);
            if (null != transition.to) {
                transition.to.removeInTransition(transition);
            }
            this.transitions.remove(transition);
            this.updateView(true);
        }
    }

    public void selectTransition(Transition transition) {
        this.selectedTransition = transition;
        for (int i = 0; i < this.transitions.size(); ++i) {
            this.transitions.elementAt(i).setSelected(false);
        }
        if (null != transition) {
            transition.setSelected(true);
        }
        this.updateView(false);
    }

    public Transition getTransition(FSMStateInterface fSMStateInterface, FSMStateInterface fSMStateInterface2) {
        if (fSMStateInterface != null && fSMStateInterface2 != null) {
            return this.getTransition(this.stateMap.get(fSMStateInterface), this.stateMap.get(fSMStateInterface2));
        }
        return null;
    }

    public Transition getTransition(State state, State state2) {
        if (state != null && state2 != null) {
            for (int i = 0; i < state.outTransitions.size(); ++i) {
                if (state.outTransitions.elementAt((int)i).to != state2) continue;
                return state.outTransitions.elementAt(i);
            }
        }
        return null;
    }

    public Transition getTransitionHeadAt(double d, double d2) {
        Transition transition = null;
        Transition transition2 = null;
        for (int i = 0; i < this.transitions.size(); ++i) {
            transition = this.transitions.elementAt(i);
            if (!this.componentRenderer.contains(transition, d, d2)) continue;
            transition2 = transition;
        }
        return transition2;
    }

    public Transition getTransitionLabelAt(double d, double d2) {
        Transition transition = null;
        Transition transition2 = null;
        for (int i = 0; i < this.transitions.size(); ++i) {
            transition = this.transitions.elementAt(i);
            if (!this.componentRenderer.contains(transition.label, d, d2)) continue;
            transition2 = transition;
        }
        return transition2;
    }

    public Transition getTransitionAt(int n, int n2) {
        Transition transition = this.getTransitionLabelAt(n, n2);
        if (null == transition) {
            return this.getTransitionHeadAt(n, n2);
        }
        return transition;
    }

    public void moveTransition(double d, double d2, Transition transition) {
        if (null != transition) {
            if (null != transition.to) {
                transition.to.removeInTransition(transition);
                transition.setToState(null);
            }
            transition.setTo(d, d2);
            this.updateView(true);
        }
    }

    public void attachTransition(Transition transition, State state) {
        if (null == state) {
            this.removeTransition(transition);
        } else if (null != transition) {
            state.addInTransition(transition);
            for (int i = 0; i < transition.from.outTransitions.size(); ++i) {
                Transition transition2 = transition.from.outTransitions.elementAt(i);
                if (state != transition2.to) continue;
                transition2.from.removeOutTransition(transition2);
                state.removeInTransition(transition2);
                this.transitions.remove(transition2);
                transition.label.addFATLabel(transition2.label);
                break;
            }
            transition.setToState(state);
            this.selectTransition(null);
        }
        this.updateView(true);
    }

    public void toTop(Transition transition) {
        if (null != transition) {
            this.transitions.remove(transition);
            this.transitions.add(transition);
        }
    }

    public State getStartState() {
        if (null != this.model.getStartState()) {
            return this.stateMap.get(this.model.getStartState());
        }
        return null;
    }

    public double getStateDiameter() {
        return this.componentRenderer.getStateDiameter(0.0);
    }

    public Rectangle getFABounds() {
        if (this.states != null && this.states.size() > 0) {
            State state = this.states.elementAt(0);
            Rectangle2D rectangle2D = this.componentRenderer.getStateBounds(state);
            double d = rectangle2D.getX();
            double d2 = d + rectangle2D.getWidth();
            double d3 = rectangle2D.getY();
            double d4 = d3 + rectangle2D.getHeight();
            for (int i = 1; i < this.states.size(); ++i) {
                state = this.states.elementAt(i);
                rectangle2D = this.componentRenderer.getStateBounds(state);
                d = Math.min(d, rectangle2D.getX());
                d2 = Math.max(d2, rectangle2D.getX() + rectangle2D.getWidth());
                d3 = Math.min(d3, rectangle2D.getY());
                d4 = Math.max(d4, rectangle2D.getY() + rectangle2D.getHeight());
            }
            this.faBounds.setRect((int)d, (int)d3, (int)(d2 - d), (int)(d4 - d3));
            return this.faBounds;
        }
        this.faBounds.setRect((int)(this.zdPane.getTranslationX() * this.zdPane.getScale() + (double)(this.getWidth() / 2)), (int)(this.zdPane.getTranslationY() * this.zdPane.getScale() + (double)(this.getHeight() / 2)), 0.0, 0.0);
        return this.faBounds;
    }

    public void fit() {
        this.fitSilently();
        this.updateView(true);
    }

    public void fitSilently() {
        Rectangle rectangle = this.getFABounds();
        if (rectangle.width > 0) {
            double d = rectangle.x - this.fitMargin;
            double d2 = rectangle.x + rectangle.width + this.fitMargin;
            double d3 = rectangle.y - this.fitMargin;
            double d4 = rectangle.y + rectangle.height + this.fitMargin + this.nameDist;
            this.zdPane.setScale(Math.min((double)this.getWidth() / (d2 - d), (double)this.getHeight() / (d4 - d3)));
            this.zdPane.setScale(Math.min(1.0, this.zdPane.getScale()));
            this.zdPane.setTranslation(-d * this.zdPane.getScale() + ((double)this.getWidth() - (d2 - d) * this.zdPane.getScale()) / 2.0, -d3 * this.zdPane.getScale() + ((double)this.getHeight() - (d4 - d3) * this.zdPane.getScale()) / 2.0);
            this.FIT_OWED = this.zdPane.getScale() == 0.0;
        }
    }

    public Color getMyBackground() {
        return this.bgrColor;
    }

    public void setMyBackground(Color color) {
        this.bgrColor = color;
    }

    public void setLiveUpdate(boolean bl) {
        this.LIVE_UPDATE = bl;
        this.updateView(true);
    }

    public void updateView(boolean bl) {
        if (bl) {
            this.TOPOLOGY_CHANGED = true;
        }
        if (this.LIVE_UPDATE) {
            this.repaint();
        }
    }

    @Override
    public void paint(Graphics graphics) {
        this.paintComponent(graphics);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        this.drawAll(graphics);
    }

    private void drawAll(Graphics graphics) {
        int n;
        int n2;
        super.paintComponent(graphics);
        this.componentRenderer.drawBackground(this.getWidth(), this.getHeight(), (Graphics2D)graphics);
        if (this.FIT_OWED) {
            this.fitSilently();
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.zdPane.transform(graphics2D);
        if (!this.DRAWN_FIRST_TIME) {
            this.TOPOLOGY_CHANGED = true;
            this.DRAWN_FIRST_TIME = true;
        }
        if (this.REPAINT_SOPHISTICATED_ALWAYS) {
            this.REPAINT_SOPHISTICATED = true;
        }
        for (n2 = 0; n2 < this.states.size(); ++n2) {
            this.componentRenderer.drawState(this.states.elementAt(n2), graphics2D);
        }
        for (n2 = 0; n2 < this.transitions.size(); ++n2) {
            this.componentRenderer.drawTransition(this.transitions.elementAt(n2), graphics2D);
        }
        for (n = 0; n < this.transitions.size(); ++n) {
            Transition transition = this.transitions.elementAt(n);
            if (transition.type != Transition.CUBIC) continue;
            this.componentRenderer.drawTransitionLabel(this.transitions.elementAt((int)n).label, graphics2D);
        }
        this.fillStateArray(null);
        for (n = 0; n < this.transitions.size(); ++n) {
            Transition transition = this.transitions.elementAt(n);
            if (transition.type != Transition.LINE && transition.type != Transition.QUAD) continue;
            this.componentRenderer.drawTransitionLabel(this.transitions.elementAt((int)n).label, graphics2D);
        }
        for (n = 0; n < this.states.size(); ++n) {
            this.componentRenderer.markState(this.states.elementAt(n), graphics2D);
        }
        if (this.model != null) {
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int n3 = fontMetrics.stringWidth(this.model.getName());
            Rectangle rectangle = this.getFABounds();
            graphics2D.setColor(this.componentRenderer.getTextColor());
            graphics2D.drawString(this.model.getName(), rectangle.x + rectangle.width / 2 - n3 / 2, rectangle.y + rectangle.height + this.nameDist);
        }
        this.TOPOLOGY_CHANGED = false;
        this.REPAINT_SOPHISTICATED = false;
    }

    public final Point getNearestFreePoint(State state, int n, int n2) {
        this.fillStateArray(state);
        if (this.FIT_INTO_GRID) {
            Point point = this.gridFit(this.gridWidth, n, n2);
            if (this.freePoint(point.x, point.y)) {
                return point;
            }
            Rectangle rectangle = this.getFABounds();
            int n3 = Math.max(rectangle.width, rectangle.height) / this.gridWidth + 2;
            for (int i = 1; i < n3; ++i) {
                int n4 = (int)(Math.PI * 4 * Math.sqrt(2.0) * (double)i);
                for (int j = 0; j < n4; ++j) {
                    double d = (double)j * Math.PI * 2.0 / (double)n4;
                    point = this.gridFit(this.gridWidth, (int)((double)n + this.cos[(int)(d * 100.0)] * (double)i * (double)this.gridWidth), (int)((double)n2 + this.sin[(int)(d * 100.0)] * (double)i * (double)this.gridWidth));
                    if (!this.freePoint(point.x, point.y)) continue;
                    return point;
                }
            }
            this.deliveryPoint.setLocation(n, n2);
            return this.deliveryPoint;
        }
        if (this.stateDist.length != this.minStateDist * this.minStateDist) {
            this.stateDist = this.fillDistArray(this.minStateDist, this.stateDist);
        }
        int n5 = n;
        int n6 = n2;
        int n7 = this.getWidth();
        int n8 = this.getHeight();
        if (this.freePoint(n, n2)) {
            return new Point(n, n2);
        }
        int n9 = (int)Math.sqrt(Math.max(n7 - n, n) * Math.max(n7 - n, n) + Math.max(n8 - n2, n2) * Math.max(n8 - n2, n2));
        for (int i = 1; i < n9; ++i) {
            for (int j = 0; j < (int)((double)(2 * i) * Math.PI); ++j) {
                double d = (double)j / (double)i;
                n5 = (int)((double)n + this.cos[(int)(d * 100.0)] * (double)i);
                n6 = (int)((double)n2 + this.sin[(int)(d * 100.0)] * (double)i);
                if (!this.freePoint(n5, n6)) continue;
                return new Point(n5, n6);
            }
        }
        this.deliveryPoint.setLocation(n, n2);
        return this.deliveryPoint;
    }

    public final Point gridFit(int n, int n2, int n3) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = (double)n2 < d ? -1.0 : 1.0;
        double d4 = (double)n3 < d2 ? -1.0 : 1.0;
        double d5 = Math.abs(((double)n2 - d) % (double)n);
        if (d5 > 0.0) {
            n2 = d5 < (double)(n / 2) ? (int)((double)n2 - d3 * d5) : (int)((double)n2 + d3 * ((double)n - d5));
        }
        if ((d5 = Math.abs(((double)n3 - d2) % (double)n)) > 0.0) {
            n3 = d5 < (double)(n / 2) ? (int)((double)n3 - d4 * d5) : (int)((double)n3 + d4 * ((double)n - d5));
        }
        this.deliveryPoint.setLocation(n2, n3);
        return this.deliveryPoint;
    }

    private final boolean freePoint(int n, int n2) {
        double d = this.minStateDist;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < this.statesX.length; ++i) {
            if (i == this.movingStateIndex) continue;
            d2 = n > this.statesX[i] ? (double)(n - this.statesX[i]) : (double)(this.statesX[i] - n);
            d3 = n2 > this.statesY[i] ? (double)(n2 - this.statesY[i]) : (double)(this.statesY[i] - n2);
            if (!(d2 < d) || !(d3 < d) || this.stateDist[(int)(d2 * d + d3)]) continue;
            return false;
        }
        return true;
    }

    final boolean labelStateFreePoint(TransitionLabel transitionLabel) {
        double d = this.componentRenderer.getStateDiameter(0.0) / 2.0 + (double)this.labelToStateDist;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < this.statesX.length; ++i) {
            d2 = transitionLabel.x > (double)this.statesX[i] ? (double)((int)(transitionLabel.x - (double)this.statesX[i])) : (double)((int)((double)this.statesX[i] - transitionLabel.x));
            d3 = transitionLabel.y > (double)this.statesY[i] ? (double)((int)(transitionLabel.y - (double)this.statesY[i])) : (double)((int)((double)this.statesY[i] - transitionLabel.y));
            if (!(d2 < d) || !(d3 < d) || this.radDist[(int)(d2 * d + d3)]) continue;
            return false;
        }
        return true;
    }

    final boolean labelTransFreePoint(TransitionLabel transitionLabel) {
        for (int i = 0; i < this.transitions.size(); ++i) {
            Transition transition = this.transitions.elementAt(i);
            if (transition.label == transitionLabel || transitionLabel.fat.from == transition.from && transitionLabel.fat.to == transition.to) continue;
            if (this.componentRenderer.getTransitionLabelBounds(transitionLabel).intersects(this.componentRenderer.getTransitionLabelBounds(transition.label))) {
                return false;
            }
            if (transitionLabel.fat.from == transition.from || transitionLabel.fat.from == transition.to || transitionLabel.fat.to == transition.to || transitionLabel.fat.to == transition.from || !transition.getCurve().intersects(this.componentRenderer.getTransitionLabelBounds(transitionLabel))) continue;
            return false;
        }
        return true;
    }

    private final void fillStateArray(State state) {
        this.statesX = new int[this.states.size()];
        this.statesY = new int[this.states.size()];
        this.movingStateIndex = -1;
        for (int i = 0; i < this.states.size(); ++i) {
            State state2 = this.states.elementAt(i);
            if (state2 == state) {
                this.movingStateIndex = i;
            }
            this.statesX[i] = (int)state2.getCenterX();
            this.statesY[i] = (int)state2.getCenterY();
        }
    }

    private final boolean[] fillDistArray(int n, boolean[] blArray) {
        int n2 = n;
        int n3 = n;
        int n4 = n * n;
        blArray = new boolean[n2 * n3];
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                blArray[i * n2 + j] = j * j + i * i > n4;
            }
        }
        return blArray;
    }

    private final void fillCosSinArrays() {
        this.cos = new double[628];
        this.sin = new double[628];
        for (int i = 0; i < this.sin.length; ++i) {
            this.cos[i] = Math.cos((double)i / 100.0);
            this.sin[i] = Math.sin((double)i / 100.0);
        }
    }

    public final void print() {
    }
}

