/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.fsmgui.view;

import ch.ethz.fsmgui.view.ComponentRenderer;
import ch.ethz.fsmgui.view.FSMView;
import ch.ethz.fsmgui.view.State;
import ch.ethz.fsmgui.view.Transition;
import ch.ethz.fsmgui.view.TransitionLabel;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.Vector;

public abstract class ComponentRendererAutoCalcTrans
implements ComponentRenderer {
    int CONV_TRANS_GAP = 25;
    int SELFSIZE = 50;
    double SELFANGLE = Math.toRadians(25.0);
    double HEADLENGTH = 12.0;
    FSMView fsmView;
    protected static String RenderingHint_WithBGR = "w";

    @Override
    public String getKey() {
        return "";
    }

    @Override
    public void setFSMView(FSMView fSMView) {
        this.fsmView = fSMView;
    }

    @Override
    public abstract void drawBackground(int var1, int var2, Graphics2D var3);

    @Override
    public abstract Color getTextColor();

    protected double getStateStrokeWidth() {
        return 0.0;
    }

    protected double getTransitionHeadLength() {
        return this.HEADLENGTH;
    }

    @Override
    public abstract double getStateDiameter(double var1);

    @Override
    public abstract Rectangle2D getStateBounds(State var1);

    @Override
    public abstract void drawState(State var1, Graphics2D var2);

    @Override
    public abstract void markState(State var1, Graphics2D var2);

    @Override
    public abstract void drawTransition(Transition var1, Graphics2D var2);

    @Override
    public void calcTransitionCoords(Transition transition) {
        double d = this.getStateDiameter(0.0) / 2.0;
        double d2 = this.getStateStrokeWidth() / 2.0;
        double d3 = this.getTransitionHeadLength();
        if (null == transition.to) {
            transition.type = Transition.LINE;
            transition.angleHead = transition.angle = Math.atan2(transition.toX - transition.from.centerX, transition.toY - transition.from.centerY);
            transition.fromX = transition.from.centerX + (d + d2) * Math.sin(transition.angle);
            transition.fromY = transition.from.centerY + (d + d2) * Math.cos(transition.angle);
            transition.toX -= (double)((int)((d3 / 2.0 + d2) * Math.sin(transition.angle)));
            transition.toY -= (double)((int)((d3 / 2.0 + d2) * Math.cos(transition.angle)));
        } else if (transition.from == transition.to) {
            transition.type = Transition.CUBIC;
            transition.angle = this.getSelfTransitionAngle(transition);
            transition.angleHead = transition.angle + this.SELFANGLE;
            transition.fromX = transition.from.centerX - (d + d2) * Math.sin(transition.angle - this.SELFANGLE);
            transition.fromY = transition.from.centerY - (d + d2) * Math.cos(transition.angle - this.SELFANGLE);
            transition.toX = transition.to.centerX - (d + d3 / 2.0 + d2) * Math.sin(transition.angle + this.SELFANGLE);
            transition.toY = transition.to.centerY - (d + d3 / 2.0 + d2) * Math.cos(transition.angle + this.SELFANGLE);
            transition.ctrlFromX = transition.fromX - (double)this.SELFSIZE * Math.sin(transition.angle - this.SELFANGLE);
            transition.ctrlFromY = transition.fromY - (double)this.SELFSIZE * Math.cos(transition.angle - this.SELFANGLE);
            transition.ctrlToX = transition.toX - (double)this.SELFSIZE * Math.sin(transition.angle + this.SELFANGLE);
            transition.ctrlToY = transition.toY - (double)this.SELFSIZE * Math.cos(transition.angle + this.SELFANGLE);
        } else if (this.converseTransition(transition)) {
            transition.type = Transition.QUAD;
            transition.angle = Math.atan2(transition.to.centerX - transition.from.centerX, transition.to.centerY - transition.from.centerY);
            double d4 = transition.from.centerX + (transition.to.centerX - transition.from.centerX) / 2.0;
            double d5 = transition.from.centerY + (transition.to.centerY - transition.from.centerY) / 2.0;
            transition.ctrlFromX = d4 + (double)this.CONV_TRANS_GAP * Math.cos(transition.angle);
            transition.ctrlFromY = d5 - (double)this.CONV_TRANS_GAP * Math.sin(transition.angle);
            double d6 = Math.atan2(transition.ctrlFromX - transition.from.centerX, transition.ctrlFromY - transition.from.centerY);
            double d7 = Math.atan2(transition.to.centerX - transition.ctrlFromX, transition.to.centerY - transition.ctrlFromY);
            transition.fromX = transition.from.centerX + (d + d2) * Math.sin(d6);
            transition.fromY = transition.from.centerY + (d + d2) * Math.cos(d6);
            transition.toX = transition.to.centerX - (d + d3 / 2.0 + d2) * Math.sin(d7);
            transition.toY = transition.to.centerY - (d + d3 / 2.0 + d2) * Math.cos(d7);
            transition.angleHead = d7;
        } else {
            transition.type = Transition.LINE;
            transition.angleHead = transition.angle = Math.atan2(transition.to.centerX - transition.from.centerX, transition.to.centerY - transition.from.centerY);
            transition.fromX = transition.from.centerX + (d + d2) * Math.sin(transition.angle);
            transition.fromY = transition.from.centerY + (d + d2) * Math.cos(transition.angle);
            transition.toX = transition.to.centerX - (d + d3 / 2.0 + d2) * Math.sin(transition.angle);
            transition.toY = transition.to.centerY - (d + d3 / 2.0 + d2) * Math.cos(transition.angle);
        }
    }

    @Override
    public Rectangle2D getTransitionLabelBounds(TransitionLabel transitionLabel) {
        this.updateTransitionLabelBounds(transitionLabel);
        return transitionLabel.bounds;
    }

    protected abstract void updateTransitionLabelBounds(TransitionLabel var1);

    @Override
    public abstract void drawTransitionLabel(TransitionLabel var1, Graphics2D var2);

    protected double getAdjustX(TransitionLabel transitionLabel, double d) {
        return 0.0;
    }

    protected double getAdjustY(TransitionLabel transitionLabel, double d) {
        return 0.0;
    }

    @Override
    public void calcTransitionLabelCoords(TransitionLabel transitionLabel) {
        this.updateTransitionLabelBounds(transitionLabel);
        double d = transitionLabel.fat.fromX + (transitionLabel.fat.toX - transitionLabel.fat.fromX) / 2.0;
        double d2 = transitionLabel.fat.fromY + (transitionLabel.fat.toY - transitionLabel.fat.fromY) / 2.0;
        if (transitionLabel.fat.type == Transition.CUBIC) {
            double d3 = transitionLabel.fat.ctrlFromX + (transitionLabel.fat.ctrlToX - transitionLabel.fat.ctrlFromX) * 0.5;
            double d4 = transitionLabel.fat.ctrlFromY + (transitionLabel.fat.ctrlToY - transitionLabel.fat.ctrlFromY) * 0.5;
            transitionLabel.x = d3 - (d3 - d) * 0.25;
            transitionLabel.y = d4 - (d4 - d2) * 0.25;
            transitionLabel.angle = Math.atan2(d3 - d, d4 - d2);
            transitionLabel.x += this.getAdjustX(transitionLabel, transitionLabel.angle);
            transitionLabel.y += this.getAdjustY(transitionLabel, transitionLabel.angle);
        } else {
            double d5 = transitionLabel.fat.ctrlFromX - (transitionLabel.fat.ctrlFromX - d) * 0.5;
            double d6 = transitionLabel.fat.ctrlFromY - (transitionLabel.fat.ctrlFromY - d2) * 0.5;
            double d7 = d - d5;
            double d8 = d2 - d6;
            double d9 = transitionLabel.fat.fromX - d;
            double d10 = transitionLabel.fat.fromY - d2;
            double d11 = 0.0;
            if (transitionLabel.fat.type == Transition.QUAD) {
                d11 = transitionLabel.fat.angle + Math.toRadians(90.0);
            } else if (transitionLabel.fat.type == Transition.LINE) {
                d11 = transitionLabel.fat.angle > Math.toRadians(0.0) && transitionLabel.fat.angle < Math.toRadians(180.0) ? transitionLabel.fat.angle + Math.toRadians(90.0) : transitionLabel.fat.angle - Math.toRadians(90.0);
            }
            double d12 = this.getAdjustX(transitionLabel, d11);
            double d13 = this.getAdjustY(transitionLabel, d11);
            if (transitionLabel.fat.type == Transition.QUAD) {
                transitionLabel.x = d5;
                transitionLabel.y = d6;
            } else if (transitionLabel.fat.type == Transition.LINE) {
                transitionLabel.x = transitionLabel.fat.fromX + (transitionLabel.fat.toX - transitionLabel.fat.fromX) * 0.5;
                transitionLabel.y = transitionLabel.fat.fromY + (transitionLabel.fat.toY - transitionLabel.fat.fromY) * 0.5;
            }
            transitionLabel.x += d12;
            transitionLabel.y += d13;
            if (this.fsmView.REPAINT_SOPHISTICATED) {
                int n = 10;
                double d14 = d12 / (double)n;
                double d15 = d13 / (double)n;
                double d16 = 1.0 / Math.max(Math.abs(transitionLabel.fat.toX - transitionLabel.fat.fromX), Math.abs(transitionLabel.fat.toY - transitionLabel.fat.fromY));
                double d17 = 1.0;
                for (double d18 = 0.0; !(!(d18 < 0.5) || this.fsmView.labelTransFreePoint(transitionLabel) && this.fsmView.labelStateFreePoint(transitionLabel)); d18 += d16) {
                    d12 = this.getAdjustX(transitionLabel, d11);
                    d13 = this.getAdjustY(transitionLabel, d11);
                    for (int i = 0; !(i >= n || this.fsmView.labelTransFreePoint(transitionLabel) && this.fsmView.labelStateFreePoint(transitionLabel)); ++i) {
                        if (transitionLabel.fat.type == Transition.QUAD) {
                            transitionLabel.x = d5 + d7 * d18 * d18 + d9 * d17 * d18;
                            transitionLabel.y = d6 + d8 * d18 * d18 + d10 * d17 * d18;
                        } else if (transitionLabel.fat.type == Transition.LINE) {
                            transitionLabel.x = transitionLabel.fat.fromX + (transitionLabel.fat.toX - transitionLabel.fat.fromX) * (d17 * d18 + 0.5);
                            transitionLabel.y = transitionLabel.fat.fromY + (transitionLabel.fat.toY - transitionLabel.fat.fromY) * (d17 * d18 + 0.5);
                        }
                        transitionLabel.x += d12;
                        transitionLabel.y += d13;
                        d12 -= d14;
                        d13 -= d15;
                    }
                    transitionLabel.removeRenderingHint(RenderingHint_WithBGR);
                    if (Math.abs(d12) < Math.abs((transitionLabel.bounds.width * 0.5 + 0.0) * Math.sin(d11)) || Math.abs(d13) < Math.abs((transitionLabel.bounds.height * 0.5 + 0.0) * Math.cos(d11))) {
                        transitionLabel.addRenderingHint(RenderingHint_WithBGR);
                    }
                    d17 = -d17;
                }
            }
        }
    }

    @Override
    public abstract boolean onMouseOver(State var1, double var2, double var4);

    @Override
    public abstract void onMouseOver(Transition var1, double var2, double var4);

    @Override
    public abstract void onMouseOver(TransitionLabel var1, double var2, double var4);

    @Override
    public abstract boolean contains(State var1, double var2, double var4);

    @Override
    public abstract boolean contains(Transition var1, double var2, double var4);

    @Override
    public abstract boolean contains(TransitionLabel var1, double var2, double var4);

    protected boolean converseTransition(Transition transition) {
        if (null != transition.to && transition.to != transition.from) {
            for (int i = 0; i < transition.from.inTransitions.size(); ++i) {
                if (transition.to != transition.from.inTransitions.elementAt((int)i).from) continue;
                return true;
            }
        }
        return false;
    }

    protected double getSelfTransitionAngle(Transition transition) {
        Vector<Double> vector = new Vector<Double>();
        if (transition.from.isStart()) {
            vector.add(new Double(4.71238898038469));
        }
        this.addOutTransitionAngles(transition, vector);
        this.addInTransitionAngles(transition, vector);
        return this.getMiddleOfLargestGap(vector);
    }

    protected void addOutTransitionAngles(Transition transition, Vector<Double> vector) {
        Vector<Transition> vector2 = transition.from.outTransitions;
        Double d = new Double(9.9);
        vector.add(d);
        block0: for (int i = 0; i < vector2.size(); ++i) {
            Transition transition2 = vector2.elementAt(i);
            if (transition2.to == transition.from) continue;
            this.calcTransitionCoords(transition2);
            if (transition2.angle < 0.0) {
                transition2.angle += Math.PI * 2;
            }
            for (int j = 0; j < vector.size(); ++j) {
                if (!(transition2.angle < vector.elementAt(j))) continue;
                vector.add(j, new Double(transition2.angle));
                continue block0;
            }
        }
        vector.remove(d);
    }

    protected void addInTransitionAngles(Transition transition, Vector<Double> vector) {
        Vector<Transition> vector2 = transition.from.inTransitions;
        Double d = new Double(9.9);
        vector.add(d);
        block0: for (int i = 0; i < vector2.size(); ++i) {
            Transition transition2 = vector2.elementAt(i);
            if (transition2.from == transition.from) continue;
            this.calcTransitionCoords(transition2);
            Double d2 = new Double((transition2.angle + Math.PI) % (Math.PI * 2));
            if (d2 < 0.0) {
                d2 = new Double(d2 + Math.PI * 2);
            }
            for (int j = 0; j < vector.size(); ++j) {
                if (!(d2 < vector.elementAt(j))) continue;
                vector.add(j, d2);
                continue block0;
            }
        }
        vector.remove(d);
    }

    protected double getMiddleOfLargestGap(Vector vector) {
        double d;
        if (vector.size() == 0) {
            return 0.0;
        }
        if (vector.size() == 1) {
            return (Double)vector.elementAt(0);
        }
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 1; i < vector.size(); ++i) {
            d = (Double)vector.elementAt(i) - (Double)vector.elementAt(i - 1);
            if (!(d > d2)) continue;
            d2 = d;
            d3 = (Double)vector.elementAt(i - 1);
        }
        d = (Double)vector.elementAt(0) + Math.PI * 2 - (Double)vector.elementAt(vector.size() - 1);
        if (d > d2) {
            d2 = d;
            d3 = (Double)vector.elementAt(vector.size() - 1);
        }
        return (Math.PI + d3 + d2 / 2.0) % (Math.PI * 2);
    }

    protected GeneralPath makePath(float[] fArray) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.reset();
        generalPath.moveTo(fArray[0], fArray[1]);
        for (int i = 2; i < fArray.length - 1; i += 2) {
            generalPath.lineTo(fArray[i], fArray[i + 1]);
        }
        generalPath.closePath();
        return generalPath;
    }
}

