/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.fsmgui.view;

import ch.ethz.fsmgui.view.ComponentRendererAutoCalcTrans;
import ch.ethz.fsmgui.view.FSMView;
import ch.ethz.fsmgui.view.State;
import ch.ethz.fsmgui.view.Transition;
import ch.ethz.fsmgui.view.TransitionLabel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;

public class ComponentContrastRenderer
extends ComponentRendererAutoCalcTrans {
    public static String key = "Contrast";
    public static Color BGR = new Color(255, 255, 255);
    public static Color TEXT = Color.black;
    public static Color STATE_LINE = Color.black;
    public static Color STATE_HIGHLIGHTED = new Color(110, 175, 245);
    public static Color STATE_SELECTED = new Color(215, 195, 160);
    public static Color STATE_TEXT = Color.black;
    public static Color STATE_MARKED_RED_LINE = Color.black;
    public static Color STATE_MARKED_RED = new Color(235, 135, 135);
    public static Color STATE_MARKED_RED_HIGHLIGHTED;
    public static Color STATE_MARKED_RED_SELECTED;
    public static Color STATE_MARKED_GREEN_LINE;
    public static Color STATE_MARKED_GREEN;
    public static Color STATE_MARKED_GREEN_HIGHLIGHTED;
    public static Color STATE_MARKED_GREEN_SELECTED;
    public static Color STATE_MARKED_BLUE_LINE;
    public static Color STATE_MARKED_BLUE;
    public static Color STATE_MARKED_BLUE_HIGHLIGHTED;
    public static Color STATE_MARKED_BLUE_SELECTED;
    public static Color TRANSITION;
    public static Color TRANSITION_HIGHLIGHTED;
    public static Color TRANSITION_SELECTED;
    public static Color TRANSITION_TEXT;
    public static Color TRANSITION_MARKED_RED;
    public static Color TRANSITION_MARKED_RED_HIGHLIGHTED;
    public static Color TRANSITION_MARKED_RED_SELECTED;
    public static Color TRANSITION_MARKED_GREEN;
    public static Color TRANSITION_MARKED_GREEN_HIGHLIGHTED;
    public static Color TRANSITION_MARKED_GREEN_SELECTED;
    public static Color TRANSITION_MARKED_BLUE;
    public static Color TRANSITION_MARKED_BLUE_HIGHLIGHTED;
    public static Color TRANSITION_MARKED_BLUE_SELECTED;
    protected double stateRadius = 23.0;
    double sensitive_Border_Overlap = 8.0;
    double strokeWidth = 1.5333333333333332;
    BasicStroke stateStroke = new BasicStroke((float)this.strokeWidth, 0, 0);
    double acptBord;
    double selBorder = this.acptBord = this.strokeWidth + this.stateRadius * 0.26666666666666666;
    double MAX_LABEL_LENGTH = 2.0 * this.stateRadius - 2.0 * this.selBorder;
    double startNickAngle = Math.toRadians(0.0);
    double startMarkWidth = 80.0;
    double saDepth = 12.0;
    double saWidth = 7.2;
    double saTail = 12.0;
    double[] startSymbolCoords = new double[]{0.0, 0.0, -this.saDepth - 1.0, -this.saWidth / 2.0, -this.saDepth, -this.strokeWidth / 2.0, -this.saDepth - this.saTail, -this.strokeWidth / 2.0, -this.saDepth - this.saTail, this.strokeWidth / 2.0, -this.saDepth, this.strokeWidth / 2.0, -this.saDepth - 1.0, this.saWidth / 2.0};
    float transWidth = (float)this.strokeWidth;
    float markedTransWidth = (float)(this.strokeWidth + 1.0);
    BasicStroke transStroke = new BasicStroke(this.transWidth, 0, 0);
    BasicStroke markedTransStroke = new BasicStroke(this.markedTransWidth, 0, 0);
    double HEADWIDTH = 7.2;
    double SENS_HEADWIDTH = 25.0;
    double SENS_HEADLENGTH = 25.0;
    double EDGEMIDDLEDIFF = 2.0;
    double[] head = new double[]{0.0, -this.HEADLENGTH / 2.0, -this.HEADWIDTH / 2.0, this.HEADLENGTH / 2.0 + this.EDGEMIDDLEDIFF, 0.0, this.HEADLENGTH / 2.0, this.HEADWIDTH / 2.0, this.HEADLENGTH / 2.0 + this.EDGEMIDDLEDIFF};
    double[] sensHead = new double[]{0.0, -this.SENS_HEADLENGTH / 2.0, -this.SENS_HEADWIDTH / 2.0, this.SENS_HEADLENGTH / 2.0, this.SENS_HEADWIDTH / 2.0, this.SENS_HEADLENGTH / 2.0};
    FontMetrics fm = null;
    double labelMargin = 5.0;
    double sensitive_TransLabel_Border_Overlap = 6.0;
    double labelCorner = 8.0;
    private double fromLineOffset = 1.0;

    protected static Color getStateColor(Object object, boolean bl, boolean bl2) {
        if (object == MARK_MARKED || object == MARK_RED) {
            if (bl2) {
                return STATE_MARKED_RED_HIGHLIGHTED;
            }
            if (bl) {
                return STATE_MARKED_RED_SELECTED;
            }
            return STATE_MARKED_RED;
        }
        if (object == MARK_GREEN) {
            if (bl2) {
                return STATE_MARKED_GREEN_HIGHLIGHTED;
            }
            if (bl) {
                return STATE_MARKED_GREEN_SELECTED;
            }
            return STATE_MARKED_GREEN;
        }
        if (object == MARK_BLUE) {
            if (bl2) {
                return STATE_MARKED_BLUE_HIGHLIGHTED;
            }
            if (bl) {
                return STATE_MARKED_BLUE_SELECTED;
            }
            return STATE_MARKED_BLUE;
        }
        if (bl2) {
            return STATE_HIGHLIGHTED;
        }
        if (bl) {
            return STATE_SELECTED;
        }
        return BGR;
    }

    protected static Color getTransitionColor(Object object, boolean bl, boolean bl2) {
        if (object == MARK_MARKED || object == MARK_RED) {
            if (bl2) {
                return TRANSITION_MARKED_RED_HIGHLIGHTED;
            }
            if (bl) {
                return TRANSITION_MARKED_RED_SELECTED;
            }
            return TRANSITION_MARKED_RED;
        }
        if (object == MARK_GREEN) {
            if (bl2) {
                return TRANSITION_MARKED_GREEN_HIGHLIGHTED;
            }
            if (bl) {
                return TRANSITION_MARKED_GREEN_SELECTED;
            }
            return TRANSITION_MARKED_GREEN;
        }
        if (object == MARK_BLUE) {
            if (bl2) {
                return TRANSITION_MARKED_BLUE_HIGHLIGHTED;
            }
            if (bl) {
                return TRANSITION_MARKED_BLUE_SELECTED;
            }
            return TRANSITION_MARKED_BLUE;
        }
        if (bl2) {
            return TRANSITION_HIGHLIGHTED;
        }
        if (bl) {
            return TRANSITION_SELECTED;
        }
        return TRANSITION;
    }

    protected static Color getTransitionTextColor(Object object, boolean bl, boolean bl2) {
        return ComponentContrastRenderer.getTransitionColor(object, bl, bl2);
    }

    public static Color darker(Color color, int n) {
        int n2 = color.getRed();
        int n3 = color.getGreen();
        int n4 = color.getBlue();
        return new Color(Math.max(n2 - n, 0), Math.max(n3 - n, 0), Math.max(n4 - n, 0));
    }

    public static Color brighter(Color color, int n) {
        int n2 = color.getRed();
        int n3 = color.getGreen();
        int n4 = color.getBlue();
        return new Color(Math.min(n2 + n, 255), Math.min(n3 + n, 255), Math.min(n4 + n, 255));
    }

    @Override
    protected double getStateStrokeWidth() {
        return this.strokeWidth;
    }

    public ComponentContrastRenderer() {
        this(null);
    }

    public ComponentContrastRenderer(FSMView fSMView) {
        this.fsmView = fSMView;
    }

    @Override
    public String getKey() {
        return key;
    }

    public void setStateRadius(double d) {
        this.stateRadius = d;
        this.selBorder = this.acptBord = this.strokeWidth + this.stateRadius * 0.26666666666666666;
        this.MAX_LABEL_LENGTH = 2.0 * this.stateRadius - 2.0 * this.selBorder;
    }

    public void setBackground(Color color) {
        BGR = color;
    }

    @Override
    public void drawBackground(int n, int n2, Graphics2D graphics2D) {
        graphics2D.setBackground(this.fsmView.getMyBackground());
        graphics2D.clearRect(0, 0, n, n2);
    }

    @Override
    public Color getTextColor() {
        return TEXT;
    }

    @Override
    public double getStateDiameter(double d) {
        return this.stateRadius * 2.0;
    }

    @Override
    public Rectangle2D getStateBounds(State state) {
        if (null == state) {
            return null;
        }
        double d = state.centerX - this.stateRadius;
        double d2 = state.centerY - this.stateRadius;
        double d3 = 2.0 * this.stateRadius;
        double d4 = 2.0 * this.stateRadius;
        Transition transition = state.getSelfTransition();
        if (null != transition) {
            this.calcTransitionCoords(transition);
            Rectangle rectangle = new CubicCurve2D.Double(transition.fromX, transition.fromY, transition.ctrlFromX, transition.ctrlFromY, transition.ctrlToX, transition.ctrlToY, transition.toX, transition.toY).getBounds();
            double d5 = Math.max((double)(rectangle.x + rectangle.width), d + d3);
            double d6 = Math.max((double)(rectangle.y + rectangle.height), d2 + d4);
            d = Math.min((double)rectangle.x, d);
            d2 = Math.min((double)rectangle.y, d2);
            d3 = d5 - d;
            d4 = d6 - d2;
        }
        if (state.isStart()) {
            double d7 = d - Math.min(d, state.centerX - this.startMarkWidth);
            d -= d7;
            d3 += d7;
        }
        return new Rectangle2D.Double(d, d2, d3, d4);
    }

    @Override
    public void drawState(State state, Graphics2D graphics2D) {
        Color color = ComponentContrastRenderer.getStateColor(state.mark, state.SELECTED, state.HIGHLIGHT_BORDER);
        Color color2 = ComponentContrastRenderer.getStateColor(state.mark, state.SELECTED, state.HIGHLIGHT_CENTER);
        state.x = state.centerX - this.stateRadius;
        state.y = state.centerY - this.stateRadius;
        state.width = 2.0 * this.stateRadius;
        state.height = 2.0 * this.stateRadius;
        graphics2D.setPaint(color);
        try {
            graphics2D.fill(new Ellipse2D.Double(state.x, state.y, state.width, state.height));
        }
        catch (Exception exception) {
            System.out.println("Exception in fill ellipse with x " + state.x + " y " + state.y + " w " + state.width + " h " + state.height);
        }
        graphics2D.setPaint(color2);
        graphics2D.fill(new Ellipse2D.Double(state.x + this.selBorder, state.y + this.selBorder, state.width - 2.0 * this.selBorder, state.height - 2.0 * this.selBorder));
        graphics2D.setStroke(this.stateStroke);
        graphics2D.setPaint(STATE_LINE);
        this.drawStateOutline(state, graphics2D);
        if (state.isAccepting()) {
            this.drawAcceptingBlip(state, graphics2D);
        }
        Font font = graphics2D.getFont();
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        if (state.getFontSize(this) == null || state.getFont() == null) {
            String string = state.label;
            float f = graphics2D.getFont().getSize();
            while ((double)fontMetrics.stringWidth(string) > this.MAX_LABEL_LENGTH && (double)f > 6.0) {
                f = (float)((double)f * 0.9);
                graphics2D.setFont(graphics2D.getFont().deriveFont(f));
                fontMetrics = graphics2D.getFontMetrics();
            }
            while ((double)fontMetrics.stringWidth(string) > this.MAX_LABEL_LENGTH) {
                string = string.substring(0, string.length() - 1);
            }
            state.labelOffsX = fontMetrics.stringWidth(string) / 2;
            state.labelOffsY = fontMetrics.getAscent() / 3;
            state.setFontSize(this, f);
            state.setVisibleLabel(string);
            state.setFont(graphics2D.getFont().deriveFont(state.getFontSize(this).floatValue()));
        }
        graphics2D.setFont(state.getFont());
        fontMetrics = graphics2D.getFontMetrics();
        graphics2D.setPaint(STATE_TEXT);
        graphics2D.drawString(state.getVisibleLabel(), (float)(state.centerX - (double)state.labelOffsX), (float)(state.centerY + (double)state.labelOffsY));
        graphics2D.setFont(font);
    }

    public void drawAcceptingBlip(State state, Graphics2D graphics2D) {
        graphics2D.draw(new Ellipse2D.Double(state.x + this.acptBord, state.y + this.acptBord, state.width - 2.0 * this.acptBord, state.height - 2.0 * this.acptBord));
    }

    public void drawStateOutline(State state, Graphics2D graphics2D) {
        graphics2D.draw(new Ellipse2D.Double(state.x, state.y, state.width, state.height));
    }

    @Override
    public void markState(State state, Graphics2D graphics2D) {
        if (null != state && state.isStart()) {
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            this.startMarkWidth = this.stateRadius * Math.cos(this.startNickAngle) + this.saDepth + this.saTail + (double)fontMetrics.stringWidth(" start ");
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(state.centerX - this.stateRadius * Math.cos(this.startNickAngle), state.centerY - this.stateRadius * Math.sin(this.startNickAngle));
            affineTransform.rotate(this.startNickAngle);
            float[] fArray = new float[this.startSymbolCoords.length];
            affineTransform.transform(this.startSymbolCoords, 0, fArray, 0, this.startSymbolCoords.length >> 1);
            graphics2D.setPaint(Color.black);
            graphics2D.fill(this.makePath(fArray));
            graphics2D.setColor(TRANSITION_TEXT);
            graphics2D.drawString("start", (float)(state.centerX - this.stateRadius * Math.cos(this.startNickAngle) - this.saDepth - this.saTail - (double)fontMetrics.stringWidth("start ")), (float)(state.centerY - this.stateRadius * Math.sin(this.startNickAngle) + (double)(fontMetrics.getAscent() / 3)));
        }
        if (state.SHOW_WHOLE_LABEL && (state.getVisibleLabel().length() != state.getLabel().length() || (double)state.getFontSize(this).floatValue() < 8.0)) {
            this.fm = graphics2D.getFontMetrics();
            graphics2D.setColor(BGR);
            graphics2D.fill(state.getWholeLabelBounds(this.fm));
            graphics2D.setColor(Color.gray);
            graphics2D.draw(state.getWholeLabelBounds(this.fm));
            graphics2D.setColor(STATE_TEXT);
            graphics2D.drawString(state.getLabel(), (float)(state.centerX - (double)(this.fm.stringWidth(state.getLabel()) / 2)), (float)(state.centerY + (double)(this.fm.getAscent() / 3)));
        }
    }

    @Override
    public void drawTransition(Transition transition, Graphics2D graphics2D) {
        this.calcTransitionCoords(transition);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(transition.toX, transition.toY);
        affineTransform.rotate(Math.PI - transition.angleHead);
        float[] fArray = new float[this.head.length];
        affineTransform.transform(this.head, 0, fArray, 0, this.head.length >> 1);
        transition.headGP = this.makePath(fArray);
        float[] fArray2 = new float[this.sensHead.length];
        affineTransform.transform(this.sensHead, 0, fArray2, 0, this.sensHead.length >> 1);
        transition.sensHeadGP = this.makePath(fArray2);
        if (transition.mark != MARK_NOT_MARKED) {
            graphics2D.setStroke(this.markedTransStroke);
        } else {
            graphics2D.setStroke(this.transStroke);
        }
        graphics2D.setPaint(ComponentContrastRenderer.getTransitionColor(transition.mark, transition.SELECTED, transition.HIGHLIGHTED));
        if (transition.type == Transition.CUBIC) {
            graphics2D.draw(new CubicCurve2D.Double(transition.fromX, transition.fromY, transition.ctrlFromX, transition.ctrlFromY, transition.ctrlToX, transition.ctrlToY, transition.toX, transition.toY));
            graphics2D.fill(transition.headGP);
        } else if (transition.type == Transition.QUAD) {
            graphics2D.draw(new QuadCurve2D.Double(transition.fromX, transition.fromY, transition.ctrlFromX, transition.ctrlFromY, transition.toX, transition.toY));
            graphics2D.fill(transition.headGP);
        } else if (transition.type == Transition.LINE) {
            graphics2D.draw(new Line2D.Double(transition.fromX, transition.fromY, transition.toX, transition.toY));
            graphics2D.fill(transition.headGP);
        }
    }

    @Override
    public void drawTransitionLabelQuick(TransitionLabel transitionLabel, Graphics2D graphics2D) {
    }

    @Override
    public void drawTransitionLabel(TransitionLabel transitionLabel, Graphics2D graphics2D) {
        if (this.fm == null) {
            this.fm = graphics2D.getFontMetrics();
        }
        transitionLabel.updateLabelString();
        if (null != transitionLabel.labelString) {
            if (this.fsmView.TOPOLOGY_CHANGED) {
                this.calcTransitionLabelCoords(transitionLabel);
                this.updateTransitionLabelBounds(transitionLabel);
            }
            if (transitionLabel.hasRenderingHint(RenderingHint_WithBGR)) {
                graphics2D.setColor(this.fsmView.getMyBackground());
                graphics2D.fill(new RoundRectangle2D.Double(transitionLabel.x - (double)(this.fm.stringWidth(transitionLabel.labelString) / 2), transitionLabel.y - (double)this.fm.getAscent() * 0.5, (double)this.fm.stringWidth(transitionLabel.labelString) + 0.3, (double)this.fm.getAscent() * 1.0, this.labelCorner, this.labelCorner));
            }
            graphics2D.setColor(ComponentContrastRenderer.getTransitionTextColor(transitionLabel.fat.mark, transitionLabel.fat.SELECTED, transitionLabel.fat.HIGHLIGHTED));
            graphics2D.drawString(transitionLabel.labelString, (float)(transitionLabel.x - (double)this.fm.stringWidth(transitionLabel.labelString) * 0.5 + 0.9), (float)(transitionLabel.y + (double)this.fm.getAscent() * 0.35));
        }
    }

    @Override
    protected double getAdjustX(TransitionLabel transitionLabel, double d) {
        return (transitionLabel.bounds.width * 0.5 + this.fromLineOffset) * Math.sin(d);
    }

    @Override
    protected double getAdjustY(TransitionLabel transitionLabel, double d) {
        return (transitionLabel.bounds.height * 0.5 + this.fromLineOffset) * Math.cos(d);
    }

    @Override
    public boolean onMouseOver(State state, double d, double d2) {
        double d3 = d - state.centerX;
        double d4 = d2 - state.centerY;
        double d5 = Math.sqrt(d3 * d3 + d4 * d4);
        boolean bl = false;
        if (d5 < this.stateRadius - this.selBorder) {
            if (!state.HIGHLIGHT_CENTER) {
                bl = true;
            }
            state.HIGHLIGHT_CENTER = true;
            state.HIGHLIGHT_BORDER = false;
            state.SHOW_WHOLE_LABEL = true;
        } else if (d5 < this.stateRadius + this.sensitive_Border_Overlap) {
            if (!state.HIGHLIGHT_BORDER) {
                bl = true;
            }
            state.HIGHLIGHT_BORDER = true;
            state.HIGHLIGHT_CENTER = false;
            state.SHOW_WHOLE_LABEL = false;
        } else {
            state.SHOW_WHOLE_LABEL = false;
        }
        return bl;
    }

    @Override
    public boolean contains(State state, double d, double d2) {
        double d3 = d - state.centerX;
        double d4 = d2 - state.centerY;
        return Math.sqrt(d3 * d3 + d4 * d4) < this.stateRadius + this.sensitive_Border_Overlap;
    }

    @Override
    public void onMouseOver(Transition transition, double d, double d2) {
    }

    @Override
    public boolean contains(Transition transition, double d, double d2) {
        return transition.sensHeadGP.contains(d, d2);
    }

    @Override
    public void onMouseOver(TransitionLabel transitionLabel, double d, double d2) {
    }

    @Override
    public boolean contains(TransitionLabel transitionLabel, double d, double d2) {
        return transitionLabel.sensBounds.contains((int)d, (int)d2);
    }

    @Override
    protected void updateTransitionLabelBounds(TransitionLabel transitionLabel) {
        if (null != transitionLabel.labelString && null != this.fm) {
            transitionLabel.bounds.x = transitionLabel.x - (double)(this.fm.stringWidth(transitionLabel.labelString) / 2) - this.labelMargin;
            transitionLabel.bounds.y = transitionLabel.y - (double)(this.fm.getAscent() / 2) - this.labelMargin;
            transitionLabel.bounds.width = (double)this.fm.stringWidth(transitionLabel.labelString) + 2.0 * this.labelMargin;
            transitionLabel.bounds.height = (double)this.fm.getAscent() + 2.0 * this.labelMargin;
            transitionLabel.sensBounds.x = transitionLabel.x - (double)(this.fm.stringWidth(transitionLabel.labelString) / 2) - this.labelMargin - this.sensitive_TransLabel_Border_Overlap;
            transitionLabel.sensBounds.y = transitionLabel.y - (double)(this.fm.getAscent() / 2) - this.labelMargin - this.sensitive_TransLabel_Border_Overlap;
            transitionLabel.sensBounds.width = (double)this.fm.stringWidth(transitionLabel.labelString) + 2.0 * (this.labelMargin + this.sensitive_TransLabel_Border_Overlap);
            transitionLabel.sensBounds.height = (double)this.fm.getAscent() + 2.0 * (this.labelMargin + this.sensitive_TransLabel_Border_Overlap);
        }
    }

    static {
        STATE_MARKED_RED_SELECTED = STATE_MARKED_RED_HIGHLIGHTED = new Color(255, 50, 50);
        STATE_MARKED_GREEN_LINE = Color.black;
        STATE_MARKED_GREEN = new Color(135, 235, 135);
        STATE_MARKED_GREEN_SELECTED = STATE_MARKED_GREEN_HIGHLIGHTED = new Color(50, 255, 50);
        STATE_MARKED_BLUE_LINE = Color.black;
        STATE_MARKED_BLUE = new Color(135, 135, 235);
        STATE_MARKED_BLUE_SELECTED = STATE_MARKED_BLUE_HIGHLIGHTED = new Color(50, 50, 255);
        TRANSITION = Color.black;
        TRANSITION_HIGHLIGHTED = Color.black;
        TRANSITION_SELECTED = Color.black;
        TRANSITION_TEXT = Color.black;
        TRANSITION_MARKED_RED_HIGHLIGHTED = TRANSITION_MARKED_RED = new Color(190, 80, 80);
        TRANSITION_MARKED_RED_SELECTED = TRANSITION_MARKED_RED;
        TRANSITION_MARKED_GREEN_HIGHLIGHTED = TRANSITION_MARKED_GREEN = new Color(80, 190, 80);
        TRANSITION_MARKED_GREEN_SELECTED = TRANSITION_MARKED_GREEN;
        TRANSITION_MARKED_BLUE_HIGHLIGHTED = TRANSITION_MARKED_BLUE = new Color(80, 80, 190);
        TRANSITION_MARKED_BLUE_SELECTED = TRANSITION_MARKED_BLUE;
    }
}

