/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.fsmgui.view;

import ch.ethz.fsmgui.view.ComponentRendererAutoCalcTrans;
import ch.ethz.fsmgui.view.FSMView;
import ch.ethz.fsmgui.view.State;
import ch.ethz.fsmgui.view.Transition;
import ch.ethz.fsmgui.view.TransitionLabel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.io.Serializable;

public class Component3DRenderer
extends ComponentRendererAutoCalcTrans {
    public static String key = "3D";
    public static int LIGHT = 75;
    public static Color BGR = new Color(0, 0, 10);
    public static Color TEXT = new Color(125, 205, 225);
    public static Color STATE = new Color(105, 125, 130);
    public static Color STATE_HIGHLIGHTED = new Color(125, 205, 225);
    public static Color STATE_SELECTED = new Color(78, 129, 151);
    public static Color STATE_TEXT = new Color(40, 0, 45);
    public static Color STATE_TEXT_HIGHLIGHTED = new Color(90, 60, 95);
    public static Color STATE_TEXT_SELECTED = STATE_TEXT;
    public static Color STATE_MARKED_RED = new Color(170, 65, 80);
    public static Color STATE_MARKED_RED_HIGHLIGHTED;
    public static Color STATE_MARKED_RED_SELECTED;
    public static Color STATE_MARKED_RED_TEXT;
    public static Color STATE_MARKED_RED_TEXT_HIGHLIGHTED;
    public static Color STATE_MARKED_RED_TEXT_SELECTED;
    public static Color STATE_MARKED_GREEN;
    public static Color STATE_MARKED_GREEN_HIGHLIGHTED;
    public static Color STATE_MARKED_GREEN_SELECTED;
    public static Color STATE_MARKED_GREEN_TEXT;
    public static Color STATE_MARKED_GREEN_TEXT_HIGHLIGHTED;
    public static Color STATE_MARKED_GREEN_TEXT_SELECTED;
    public static Color STATE_MARKED_BLUE;
    public static Color STATE_MARKED_BLUE_HIGHLIGHTED;
    public static Color STATE_MARKED_BLUE_SELECTED;
    public static Color STATE_MARKED_BLUE_TEXT;
    public static Color STATE_MARKED_BLUE_TEXT_HIGHLIGHTED;
    public static Color STATE_MARKED_BLUE_TEXT_SELECTED;
    public static Color TRANSITION;
    public static Color TRANSITION_HIGHLIGHTED;
    public static Color TRANSITION_SELECTED;
    public static Color TRANSITION_TEXT;
    public static Color TRANSITION_TEXT_HIGHLIGHTED;
    public static Color TRANSITION_TEXT_SELECTED;
    public static Color TRANSITION_MARKED_RED;
    public static Color TRANSITION_MARKED_RED_HIGHLIGHTED;
    public static Color TRANSITION_MARKED_RED_SELECTED;
    public static Color TRANSITION_MARKED_RED_TEXT;
    public static Color TRANSITION_MARKED_RED_TEXT_HIGHLIGHTED;
    public static Color TRANSITION_MARKED_RED_TEXT_SELECTED;
    public static Color TRANSITION_MARKED_GREEN;
    public static Color TRANSITION_MARKED_GREEN_HIGHLIGHTED;
    public static Color TRANSITION_MARKED_GREEN_SELECTED;
    public static Color TRANSITION_MARKED_GREEN_TEXT;
    public static Color TRANSITION_MARKED_GREEN_TEXT_HIGHLIGHTED;
    public static Color TRANSITION_MARKED_GREEN_TEXT_SELECTED;
    public static Color TRANSITION_MARKED_BLUE;
    public static Color TRANSITION_MARKED_BLUE_HIGHLIGHTED;
    public static Color TRANSITION_MARKED_BLUE_SELECTED;
    public static Color TRANSITION_MARKED_BLUE_TEXT;
    public static Color TRANSITION_MARKED_BLUE_TEXT_HIGHLIGHTED;
    public static Color TRANSITION_MARKED_BLUE_TEXT_SELECTED;
    Font font = new Font("Dialog", 0, 12);
    protected double stateRadius = 24.0;
    double border = this.stateRadius * 0.1;
    double acptBord = this.stateRadius * 0.2;
    double selBorder = this.border + this.acptBord + this.stateRadius * 0.06666666666666667;
    double MAX_LABEL_LENGTH = 2.0 * this.stateRadius - 2.0 * this.selBorder;
    double startNickAngle = Math.toRadians(0.0);
    double startMarkWidth = 74.0;
    double smDist = 17.0;
    double nDepth = this.selBorder * 1.7;
    double nAngle = Math.toRadians(9.0);
    double nAngleB = Math.toRadians(13.0);
    double nDepth2 = this.stateRadius - this.stateRadius * Math.cos(this.nAngle) + this.stateRadius * Math.sin(this.nAngle) * ((this.stateRadius - this.border) * Math.cos(this.nAngleB) + this.nDepth - this.stateRadius) / ((this.stateRadius - this.border) * Math.sin(this.nAngleB));
    double[] startSymbolCoords = new double[]{this.nDepth2, 0.0, this.stateRadius - (this.stateRadius + 1.0) * Math.cos(this.nAngle), (this.stateRadius + 3.0) * Math.sin(this.nAngle), -1.0, 0.0, this.stateRadius - (this.stateRadius + 1.0) * Math.cos(this.nAngle), -(this.stateRadius + 3.0) * Math.sin(this.nAngle)};
    double[] startSymbolCoordsUp = new double[]{this.nDepth, 0.0, this.stateRadius - (this.stateRadius - this.border) * Math.cos(this.nAngleB), -(this.stateRadius - this.border) * Math.sin(this.nAngleB), this.stateRadius - this.stateRadius * Math.cos(this.nAngle), -this.stateRadius * Math.sin(this.nAngle), 0.0, 0.0};
    double[] startSymbolCoordsDown = new double[]{this.nDepth, 0.0, this.stateRadius - (this.stateRadius - this.border) * Math.cos(this.nAngleB), (this.stateRadius - this.border) * Math.sin(this.nAngleB), this.stateRadius - this.stateRadius * Math.cos(this.nAngle), this.stateRadius * Math.sin(this.nAngle), 0.0, 0.0};
    float transWidth = 2.5f;
    BasicStroke transStroke = new BasicStroke(this.transWidth, 0, 0);
    float toolTipWidth = 1.5f;
    BasicStroke toolTipStroke = new BasicStroke(this.toolTipWidth, 0, 0);
    double HEADWIDTH = 10.0;
    double SENS_HEADWIDTH = 18.0;
    double SENS_HEADLENGTH = 18.0;
    double[] head = new double[]{0.0, -this.HEADLENGTH / 2.0, -this.HEADWIDTH / 2.0, this.HEADLENGTH / 2.0, this.HEADWIDTH / 2.0, this.HEADLENGTH / 2.0};
    double[] sensHead = new double[]{0.0, -this.SENS_HEADLENGTH / 2.0, -this.SENS_HEADWIDTH / 2.0, this.SENS_HEADLENGTH / 2.0, this.SENS_HEADWIDTH / 2.0, this.SENS_HEADLENGTH / 2.0};
    FontMetrics fm = null;
    double labelMargin = 3.0;
    double labelCorner = 14.0;
    int labelBright = 55;
    int[] stars;
    double density = 0.001;

    protected Color getStateColor(Object object, boolean bl, boolean bl2) {
        if (object == MARK_MARKED || object == MARK_RED) {
            if (bl2) {
                return STATE_MARKED_RED_HIGHLIGHTED;
            }
            if (bl) {
                return STATE_MARKED_RED_SELECTED;
            }
            return STATE_MARKED_RED;
        }
        if (object == MARK_GREEN) {
            if (bl2) {
                return STATE_MARKED_GREEN_HIGHLIGHTED;
            }
            if (bl) {
                return STATE_MARKED_GREEN_SELECTED;
            }
            return STATE_MARKED_GREEN;
        }
        if (object == MARK_BLUE) {
            if (bl2) {
                return STATE_MARKED_BLUE_HIGHLIGHTED;
            }
            if (bl) {
                return STATE_MARKED_BLUE_SELECTED;
            }
            return STATE_MARKED_BLUE;
        }
        if (bl2) {
            return STATE_HIGHLIGHTED;
        }
        if (bl) {
            return STATE_SELECTED;
        }
        return STATE;
    }

    protected Color getStateTextColor(Object object, boolean bl, boolean bl2) {
        if (object == MARK_MARKED || object == MARK_RED) {
            if (bl2) {
                return STATE_MARKED_RED_TEXT_HIGHLIGHTED;
            }
            if (bl) {
                return STATE_MARKED_RED_TEXT_SELECTED;
            }
            return STATE_MARKED_RED_TEXT;
        }
        if (object == MARK_GREEN) {
            if (bl2) {
                return STATE_MARKED_GREEN_TEXT_HIGHLIGHTED;
            }
            if (bl) {
                return STATE_MARKED_GREEN_TEXT_SELECTED;
            }
            return STATE_MARKED_GREEN_TEXT;
        }
        if (object == MARK_BLUE) {
            if (bl2) {
                return STATE_MARKED_BLUE_TEXT_HIGHLIGHTED;
            }
            if (bl) {
                return STATE_MARKED_BLUE_TEXT_SELECTED;
            }
            return STATE_MARKED_BLUE_TEXT;
        }
        if (bl2) {
            return STATE_TEXT_HIGHLIGHTED;
        }
        if (bl) {
            return STATE_TEXT_SELECTED;
        }
        return STATE_TEXT;
    }

    protected Color getTransitionColor(Object object, boolean bl, boolean bl2) {
        if (object == MARK_MARKED || object == MARK_RED) {
            if (bl2) {
                return TRANSITION_MARKED_RED_HIGHLIGHTED;
            }
            if (bl) {
                return TRANSITION_MARKED_RED_SELECTED;
            }
            return TRANSITION_MARKED_RED;
        }
        if (object == MARK_GREEN) {
            if (bl2) {
                return TRANSITION_MARKED_GREEN_HIGHLIGHTED;
            }
            if (bl) {
                return TRANSITION_MARKED_GREEN_SELECTED;
            }
            return TRANSITION_MARKED_GREEN;
        }
        if (object == MARK_BLUE) {
            if (bl2) {
                return TRANSITION_MARKED_BLUE_HIGHLIGHTED;
            }
            if (bl) {
                return TRANSITION_MARKED_BLUE_SELECTED;
            }
            return TRANSITION_MARKED_BLUE;
        }
        if (bl2) {
            return TRANSITION_HIGHLIGHTED;
        }
        if (bl) {
            return TRANSITION_SELECTED;
        }
        return TRANSITION;
    }

    protected Color getTransitionLabelColor(Object object, boolean bl, boolean bl2) {
        return Component3DRenderer.brighter(this.getTransitionColor(object, bl, bl2), this.labelBright);
    }

    protected Color getTransitionTextColor(Object object, boolean bl, boolean bl2) {
        if (object == MARK_MARKED || object == MARK_RED) {
            if (bl2) {
                return TRANSITION_MARKED_RED_TEXT_HIGHLIGHTED;
            }
            if (bl) {
                return TRANSITION_MARKED_RED_TEXT_SELECTED;
            }
            return TRANSITION_MARKED_RED_TEXT;
        }
        if (object == MARK_GREEN) {
            if (bl2) {
                return TRANSITION_MARKED_GREEN_TEXT_HIGHLIGHTED;
            }
            if (bl) {
                return TRANSITION_MARKED_GREEN_TEXT_SELECTED;
            }
            return TRANSITION_MARKED_GREEN_TEXT;
        }
        if (object == MARK_BLUE) {
            if (bl2) {
                return TRANSITION_MARKED_BLUE_TEXT_HIGHLIGHTED;
            }
            if (bl) {
                return TRANSITION_MARKED_BLUE_TEXT_SELECTED;
            }
            return TRANSITION_MARKED_BLUE_TEXT;
        }
        if (bl2) {
            return TRANSITION_TEXT_HIGHLIGHTED;
        }
        if (bl) {
            return TRANSITION_TEXT_SELECTED;
        }
        return TRANSITION_TEXT;
    }

    public static Color darker(Color color, int n) {
        int n2 = color.getRed();
        int n3 = color.getGreen();
        int n4 = color.getBlue();
        return new Color(Math.max(n2 - n, 0), Math.max(n3 - n, 0), Math.max(n4 - n, 0));
    }

    public static Color brighter(Color color, int n) {
        int n2 = color.getRed();
        int n3 = color.getGreen();
        int n4 = color.getBlue();
        return new Color(Math.min(n2 + n, 255), Math.min(n3 + n, 255), Math.min(n4 + n, 255));
    }

    public Component3DRenderer() {
        this(null);
    }

    public Component3DRenderer(FSMView fSMView) {
        this.fsmView = fSMView;
    }

    @Override
    public String getKey() {
        return key;
    }

    public void setStateRadius(double d) {
        this.stateRadius = d;
        this.acptBord = this.stateRadius * 0.2;
        this.selBorder = this.border + this.acptBord + this.stateRadius * 0.06666666666666667;
        this.MAX_LABEL_LENGTH = 2.0 * this.stateRadius - 2.0 * this.selBorder;
    }

    public void setBackground(Color color) {
        BGR = color;
    }

    @Override
    public void drawBackground(int n, int n2, Graphics2D graphics2D) {
        graphics2D.setColor(BGR);
        graphics2D.fillRect(0, 0, n, n2);
        this.stardust(n, n2, graphics2D);
    }

    protected void stardust(int n, int n2, Graphics2D graphics2D) {
        int n3;
        if (this.stars == null || this.stars.length != 3 * (int)((double)(n * n2) * this.density)) {
            this.stars = new int[3 * (int)((double)(n * n2) * this.density)];
            for (n3 = 0; n3 < this.stars.length - 2; n3 += 3) {
                this.stars[n3] = 70 + (int)(Math.random() * 150.0);
                this.stars[n3 + 1] = (int)(Math.random() * (double)n);
                this.stars[n3 + 2] = (int)(Math.random() * (double)n2);
            }
        }
        for (n3 = 0; n3 < this.stars.length - 2; n3 += 3) {
            graphics2D.setColor(new Color(this.stars[n3], this.stars[n3], this.stars[n3]));
            graphics2D.drawLine(this.stars[n3 + 1], this.stars[n3 + 2], this.stars[n3 + 1], this.stars[n3 + 2]);
        }
    }

    @Override
    public Color getTextColor() {
        return TEXT;
    }

    @Override
    public double getStateDiameter(double d) {
        return this.stateRadius * 2.0;
    }

    @Override
    public Rectangle2D getStateBounds(State state) {
        double d = state.centerX - this.stateRadius;
        double d2 = state.centerY - this.stateRadius;
        double d3 = 2.0 * this.stateRadius;
        double d4 = 2.0 * this.stateRadius;
        Transition transition = state.getSelfTransition();
        if (null != transition) {
            this.calcTransitionCoords(transition);
            Rectangle rectangle = new CubicCurve2D.Double(transition.fromX, transition.fromY, transition.ctrlFromX, transition.ctrlFromY, transition.ctrlToX, transition.ctrlToY, transition.toX, transition.toY).getBounds();
            double d5 = Math.max((double)(rectangle.x + rectangle.width), d + d3);
            double d6 = Math.max((double)(rectangle.y + rectangle.height), d2 + d4);
            d = Math.min((double)rectangle.x, d);
            d2 = Math.min((double)rectangle.y, d2);
            d3 = d5 - d;
            d4 = d6 - d2;
        }
        if (state.isStart()) {
            double d7 = d - Math.min(d, state.centerX - this.startMarkWidth);
            d -= d7;
            d3 += d7;
        }
        return new Rectangle2D.Double((int)d, (int)d2, (int)d3, (int)d4);
    }

    @Override
    public void drawState(State state, Graphics2D graphics2D) {
        Object object;
        Object object2;
        Serializable serializable;
        Color color = this.getStateColor(state.mark, state.SELECTED, state.HIGHLIGHT_BORDER);
        Color color2 = this.getStateColor(state.mark, state.SELECTED, state.HIGHLIGHT_CENTER);
        Color color3 = this.getStateTextColor(state.mark, state.SELECTED, state.HIGHLIGHT_CENTER);
        state.x = state.centerX - this.stateRadius;
        state.y = state.centerY - this.stateRadius;
        state.width = 2.0 * this.stateRadius;
        state.height = 2.0 * this.stateRadius;
        GradientPaint gradientPaint = new GradientPaint((float)state.x, (float)state.y, Component3DRenderer.brighter(color, LIGHT), (float)(state.x + state.width), (float)(state.y + state.height), Component3DRenderer.darker(color, LIGHT));
        GradientPaint gradientPaint2 = new GradientPaint((float)state.x, (float)state.y, Component3DRenderer.darker(color, LIGHT), (float)(state.x + state.width), (float)(state.y + state.height), Component3DRenderer.brighter(color, LIGHT));
        GradientPaint gradientPaint3 = new GradientPaint((float)state.x, (float)state.y, Component3DRenderer.darker(color2, LIGHT), (float)(state.x + state.width), (float)(state.y + state.height), Component3DRenderer.brighter(color2, LIGHT));
        graphics2D.setPaint(gradientPaint);
        graphics2D.fill(new Ellipse2D.Double(state.x, state.y, state.width, state.height));
        if (state.isAccepting()) {
            graphics2D.setPaint(gradientPaint);
            graphics2D.fill(new Ellipse2D.Double(state.x + this.border, state.y + this.border, state.width - 2.0 * this.border, state.height - 2.0 * this.border));
            graphics2D.setPaint(gradientPaint2);
            graphics2D.fill(new Ellipse2D.Double(state.x + this.border + this.acptBord * 1.0 / 3.0, state.y + this.border + this.acptBord * 1.0 / 3.0, state.width - 2.0 * (this.border + this.acptBord * 1.0 / 3.0), state.height - 2.0 * (this.border + this.acptBord * 1.0 / 3.0)));
            graphics2D.setPaint(gradientPaint);
            graphics2D.fill(new Ellipse2D.Double(state.x + this.border + this.acptBord * 2.0 / 3.0, state.y + this.border + this.acptBord * 2.0 / 3.0, state.width - 2.0 * (this.border + this.acptBord * 2.0 / 3.0), state.height - 2.0 * (this.border + this.acptBord * 2.0 / 3.0)));
            graphics2D.setPaint(gradientPaint2);
            graphics2D.fill(new Ellipse2D.Double(state.x + this.border + this.acptBord, state.y + this.border + this.acptBord, state.width - 2.0 * (this.border + this.acptBord), state.height - 2.0 * (this.border + this.acptBord)));
        } else {
            graphics2D.setPaint(gradientPaint2);
            graphics2D.fill(new Ellipse2D.Double(state.x + this.border, state.y + this.border, state.width - 2.0 * this.border, state.height - 2.0 * this.border));
        }
        graphics2D.setPaint(gradientPaint3);
        graphics2D.fill(new Ellipse2D.Double(state.x + this.selBorder, state.y + this.selBorder, state.width - 2.0 * this.selBorder, state.height - 2.0 * this.selBorder));
        if (state.isStart()) {
            serializable = new AffineTransform();
            ((AffineTransform)serializable).translate(state.centerX - this.stateRadius * Math.cos(this.startNickAngle), state.centerY - this.stateRadius * Math.sin(this.startNickAngle));
            ((AffineTransform)serializable).rotate(this.startNickAngle);
            object2 = new float[this.startSymbolCoords.length];
            object = new float[this.startSymbolCoordsUp.length];
            float[] fArray = new float[this.startSymbolCoordsDown.length];
            ((AffineTransform)serializable).transform(this.startSymbolCoords, 0, (float[])object2, 0, this.startSymbolCoords.length >> 1);
            ((AffineTransform)serializable).transform(this.startSymbolCoordsUp, 0, (float[])object, 0, this.startSymbolCoordsUp.length >> 1);
            ((AffineTransform)serializable).transform(this.startSymbolCoordsDown, 0, fArray, 0, this.startSymbolCoordsDown.length >> 1);
            graphics2D.setPaint(gradientPaint2);
            graphics2D.fill(this.makePath((float[])object));
            graphics2D.setPaint(gradientPaint);
            graphics2D.fill(this.makePath(fArray));
            graphics2D.setPaint(BGR);
            graphics2D.fill(this.makePath((float[])object2));
            ((AffineTransform)serializable).translate(-2.0, 0.0);
            ((AffineTransform)serializable).transform(this.startSymbolCoords, 0, (float[])object2, 0, this.startSymbolCoords.length >> 1);
            graphics2D.setColor(TRANSITION);
            graphics2D.fill(this.makePath((float[])object2));
        }
        serializable = graphics2D.getFont();
        object2 = graphics2D.getFontMetrics();
        if (state.getFontSize(this) == null || state.getFont() == null) {
            object = state.label;
            float f = graphics2D.getFont().getSize();
            while ((double)((FontMetrics)object2).stringWidth((String)object) > this.MAX_LABEL_LENGTH && (double)f > 6.0) {
                f = (float)((double)f * 0.9);
                graphics2D.setFont(graphics2D.getFont().deriveFont(f));
                object2 = graphics2D.getFontMetrics();
            }
            while ((double)((FontMetrics)object2).stringWidth((String)object) > this.MAX_LABEL_LENGTH) {
                object = ((String)object).substring(0, ((String)object).length() - 1);
            }
            state.labelOffsX = ((FontMetrics)object2).stringWidth((String)object) / 2;
            state.labelOffsY = ((FontMetrics)object2).getAscent() / 3;
            state.setFontSize(this, f);
            state.setVisibleLabel((String)object);
            state.setFont(graphics2D.getFont().deriveFont(state.getFontSize(this).floatValue()));
        }
        graphics2D.setFont(state.getFont());
        object2 = graphics2D.getFontMetrics();
        graphics2D.setPaint(color3);
        graphics2D.drawString(state.getVisibleLabel(), (float)(state.centerX - (double)state.labelOffsX), (float)(state.centerY + (double)state.labelOffsY));
        graphics2D.setFont((Font)serializable);
    }

    @Override
    public void markState(State state, Graphics2D graphics2D) {
        if (null != state && state.isStart()) {
            graphics2D.setFont(this.font);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            this.startMarkWidth = this.stateRadius * Math.cos(this.startNickAngle) + this.smDist + (double)fontMetrics.stringWidth(" start ");
            graphics2D.setStroke(this.transStroke);
            graphics2D.setColor(TRANSITION);
            graphics2D.draw(new Line2D.Double(state.centerX - this.stateRadius * Math.cos(this.startNickAngle) - this.smDist - 2.0, state.centerY, state.centerX - this.stateRadius * Math.cos(this.startNickAngle), state.centerY));
            graphics2D.setColor(Component3DRenderer.brighter(TRANSITION, this.labelBright));
            graphics2D.fill(new RoundRectangle2D.Double(state.centerX - this.stateRadius * Math.cos(this.startNickAngle) - this.smDist - (double)fontMetrics.stringWidth(" start "), state.centerY - this.stateRadius * Math.sin(this.startNickAngle) - (double)fontMetrics.getAscent() * 0.7, fontMetrics.stringWidth(" start "), fontMetrics.getAscent() + fontMetrics.getDescent(), 7.0, 7.0));
            graphics2D.setColor(TRANSITION_TEXT);
            graphics2D.drawString("start", (int)(state.centerX - this.stateRadius * Math.cos(this.startNickAngle) - this.smDist - (double)fontMetrics.stringWidth("start ")), (int)(state.centerY - this.stateRadius * Math.sin(this.startNickAngle) + (double)(fontMetrics.getAscent() / 3)));
        }
        if (state.SHOW_WHOLE_LABEL && (state.getVisibleLabel().length() != state.getLabel().length() || (double)state.getFontSize(this).floatValue() < 8.0)) {
            this.fm = graphics2D.getFontMetrics();
            graphics2D.setColor(this.getStateColor(state.mark, state.SELECTED, false));
            graphics2D.fill(state.getWholeLabelBounds(this.fm));
            graphics2D.setColor(this.getStateColor(state.mark, state.SELECTED, true));
            graphics2D.setStroke(this.toolTipStroke);
            graphics2D.draw(state.getWholeLabelBounds(this.fm));
            graphics2D.setColor(STATE_TEXT);
            graphics2D.drawString(state.getLabel(), (float)(state.centerX - (double)(this.fm.stringWidth(state.getLabel()) / 2)), (float)(state.centerY + (double)(this.fm.getAscent() / 3)));
        }
    }

    @Override
    public void drawTransition(Transition transition, Graphics2D graphics2D) {
        this.calcTransitionCoords(transition);
        graphics2D.setStroke(this.transStroke);
        graphics2D.setPaint(this.getTransitionColor(transition.mark, transition.SELECTED, transition.HIGHLIGHTED));
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(transition.toX, transition.toY);
        affineTransform.rotate(Math.PI - transition.angleHead);
        float[] fArray = new float[this.head.length];
        affineTransform.transform(this.head, 0, fArray, 0, this.head.length >> 1);
        transition.headGP = this.makePath(fArray);
        float[] fArray2 = new float[this.sensHead.length];
        affineTransform.transform(this.sensHead, 0, fArray2, 0, this.sensHead.length >> 1);
        transition.sensHeadGP = this.makePath(fArray2);
        if (transition.type == Transition.CUBIC) {
            graphics2D.draw(new CubicCurve2D.Double(transition.fromX, transition.fromY, transition.ctrlFromX, transition.ctrlFromY, transition.ctrlToX, transition.ctrlToY, transition.toX, transition.toY));
            graphics2D.fill(transition.headGP);
        } else if (transition.type == Transition.QUAD) {
            graphics2D.draw(new QuadCurve2D.Double(transition.fromX, transition.fromY, transition.ctrlFromX, transition.ctrlFromY, transition.toX, transition.toY));
            graphics2D.fill(transition.headGP);
        } else if (transition.type == Transition.LINE) {
            graphics2D.draw(new Line2D.Double(transition.fromX, transition.fromY, transition.toX, transition.toY));
            graphics2D.fill(transition.headGP);
        }
    }

    @Override
    public void drawTransitionLabelQuick(TransitionLabel transitionLabel, Graphics2D graphics2D) {
    }

    @Override
    public void drawTransitionLabel(TransitionLabel transitionLabel, Graphics2D graphics2D) {
        graphics2D.setFont(this.font);
        if (this.fm == null) {
            this.fm = graphics2D.getFontMetrics();
        }
        transitionLabel.updateLabelString();
        if (null != transitionLabel.labelString) {
            this.calcTransitionLabelCoords(transitionLabel);
            this.updateTransitionLabelBounds(transitionLabel);
            graphics2D.setPaint(this.getTransitionLabelColor(transitionLabel.fat.mark, transitionLabel.fat.SELECTED, transitionLabel.fat.HIGHLIGHTED));
            graphics2D.fill(new RoundRectangle2D.Double(transitionLabel.bounds.x, transitionLabel.bounds.y, transitionLabel.bounds.width, transitionLabel.bounds.height, this.labelCorner, this.labelCorner));
            graphics2D.setColor(this.getTransitionTextColor(transitionLabel.fat.mark, transitionLabel.fat.SELECTED, transitionLabel.fat.HIGHLIGHTED));
            graphics2D.drawString(transitionLabel.labelString, (float)(transitionLabel.x - (double)this.fm.stringWidth(transitionLabel.labelString) * 0.5 + 0.47), (float)(transitionLabel.y + (double)this.fm.getAscent() * 0.4));
        }
    }

    @Override
    public boolean onMouseOver(State state, double d, double d2) {
        double d3 = d - state.centerX;
        double d4 = d2 - state.centerY;
        double d5 = Math.sqrt(d3 * d3 + d4 * d4);
        boolean bl = false;
        if (d5 < this.stateRadius - this.selBorder) {
            if (!state.HIGHLIGHT_CENTER) {
                bl = true;
            }
            state.HIGHLIGHT_CENTER = true;
            state.HIGHLIGHT_BORDER = false;
            state.SHOW_WHOLE_LABEL = true;
        } else if (d5 < this.stateRadius) {
            if (!state.HIGHLIGHT_BORDER) {
                bl = true;
            }
            state.HIGHLIGHT_BORDER = true;
            state.HIGHLIGHT_CENTER = false;
            state.SHOW_WHOLE_LABEL = false;
        } else {
            state.SHOW_WHOLE_LABEL = false;
        }
        return bl;
    }

    @Override
    public boolean contains(State state, double d, double d2) {
        double d3 = d - state.centerX;
        double d4 = d2 - state.centerY;
        return Math.sqrt(d3 * d3 + d4 * d4) < this.stateRadius;
    }

    @Override
    public void onMouseOver(Transition transition, double d, double d2) {
    }

    @Override
    public boolean contains(Transition transition, double d, double d2) {
        return transition.sensHeadGP.contains(d, d2);
    }

    @Override
    public void onMouseOver(TransitionLabel transitionLabel, double d, double d2) {
    }

    @Override
    public boolean contains(TransitionLabel transitionLabel, double d, double d2) {
        return transitionLabel.bounds.contains((int)d, (int)d2);
    }

    @Override
    protected void updateTransitionLabelBounds(TransitionLabel transitionLabel) {
        if (null != transitionLabel.labelString && null != this.fm) {
            transitionLabel.bounds.x = transitionLabel.x - (double)(this.fm.stringWidth(transitionLabel.labelString) / 2) - this.labelMargin;
            transitionLabel.bounds.y = transitionLabel.y - (double)(this.fm.getAscent() / 2) - this.labelMargin;
            transitionLabel.bounds.width = (double)this.fm.stringWidth(transitionLabel.labelString) + 2.0 * this.labelMargin;
            transitionLabel.bounds.height = (double)this.fm.getAscent() + 2.0 * this.labelMargin;
        }
    }

    static {
        STATE_MARKED_RED_SELECTED = STATE_MARKED_RED_HIGHLIGHTED = new Color(230, 150, 160);
        STATE_MARKED_RED_TEXT = new Color(0, 25, 20);
        STATE_MARKED_RED_TEXT_SELECTED = STATE_MARKED_RED_TEXT_HIGHLIGHTED = new Color(40, 65, 60);
        STATE_MARKED_GREEN = new Color(75, 165, 75);
        STATE_MARKED_GREEN_SELECTED = STATE_MARKED_GREEN_HIGHLIGHTED = new Color(175, 240, 140);
        STATE_MARKED_GREEN_TEXT = STATE_TEXT;
        STATE_MARKED_GREEN_TEXT_HIGHLIGHTED = STATE_TEXT_HIGHLIGHTED;
        STATE_MARKED_GREEN_TEXT_SELECTED = STATE_TEXT_HIGHLIGHTED;
        STATE_MARKED_BLUE = new Color(70, 130, 180);
        STATE_MARKED_BLUE_SELECTED = STATE_MARKED_BLUE_HIGHLIGHTED = new Color(75, 190, 255);
        STATE_MARKED_BLUE_TEXT = new Color(25, 20, 0);
        STATE_MARKED_BLUE_TEXT_SELECTED = STATE_MARKED_BLUE_TEXT_HIGHLIGHTED = new Color(65, 60, 40);
        TRANSITION = new Color(110, 120, 105);
        TRANSITION_SELECTED = TRANSITION_HIGHLIGHTED = new Color(137, 165, 132);
        TRANSITION_TEXT_HIGHLIGHTED = TRANSITION_TEXT = new Color(30, 20, 20);
        TRANSITION_TEXT_SELECTED = TRANSITION_TEXT;
        TRANSITION_MARKED_RED = STATE_MARKED_RED;
        TRANSITION_MARKED_RED_SELECTED = TRANSITION_MARKED_RED_HIGHLIGHTED = Component3DRenderer.brighter(STATE_MARKED_RED, 40);
        TRANSITION_MARKED_RED_TEXT = STATE_MARKED_RED_TEXT;
        TRANSITION_MARKED_RED_TEXT_HIGHLIGHTED = STATE_MARKED_RED_TEXT_HIGHLIGHTED;
        TRANSITION_MARKED_RED_TEXT_SELECTED = STATE_MARKED_RED_TEXT_HIGHLIGHTED;
        TRANSITION_MARKED_GREEN = STATE_MARKED_GREEN;
        TRANSITION_MARKED_GREEN_SELECTED = TRANSITION_MARKED_GREEN_HIGHLIGHTED = Component3DRenderer.brighter(STATE_MARKED_GREEN, 40);
        TRANSITION_MARKED_GREEN_TEXT = STATE_MARKED_GREEN_TEXT;
        TRANSITION_MARKED_GREEN_TEXT_HIGHLIGHTED = STATE_MARKED_GREEN_TEXT_HIGHLIGHTED;
        TRANSITION_MARKED_GREEN_TEXT_SELECTED = STATE_MARKED_GREEN_TEXT_HIGHLIGHTED;
        TRANSITION_MARKED_BLUE = STATE_MARKED_BLUE;
        TRANSITION_MARKED_BLUE_SELECTED = TRANSITION_MARKED_BLUE_HIGHLIGHTED = Component3DRenderer.brighter(STATE_MARKED_BLUE, 40);
        TRANSITION_MARKED_BLUE_TEXT = STATE_MARKED_BLUE_TEXT;
        TRANSITION_MARKED_BLUE_TEXT_HIGHLIGHTED = STATE_MARKED_BLUE_TEXT_HIGHLIGHTED;
        TRANSITION_MARKED_BLUE_TEXT_SELECTED = STATE_MARKED_BLUE_TEXT_HIGHLIGHTED;
    }
}

