/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.fsmgui.controller.popups;

import ch.ethz.fsmgui.controller.FSMControllerInterface;
import ch.ethz.fsmgui.model.FSMStateInterface;
import ch.ethz.fsmgui.view.FSMView;
import ch.karatojava.util.ExceptionActionListener;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Point;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class StatePopup
extends ExceptionActionListener {
    protected static final String ACTION_DELETE = "delete";
    protected static final String ACTION_ACCEPTING = "accepting";
    protected static final String ACTION_START = "start";
    protected static final String ACTION_CHANGE_LABEL = "changeLabel";
    protected FSMView fascape;
    protected FSMControllerInterface controller;
    protected FSMStateInterface state;
    protected JPopupMenu menu;
    protected JMenuItem deleteItem;
    protected JCheckBoxMenuItem acceptItem;
    protected JCheckBoxMenuItem startItem;
    protected JMenuItem changeItem;
    private Frame parent;
    protected StateLabelDialog stateLabelDialog;

    public StatePopup(FSMControllerInterface fSMControllerInterface, Frame frame) {
        this.fascape = fSMControllerInterface.getView();
        this.controller = fSMControllerInterface;
        this.parent = frame;
        this.menu = new JPopupMenu();
        this.deleteItem = new JMenuItem("Delete");
        this.deleteItem.setActionCommand(ACTION_DELETE);
        this.deleteItem.addActionListener(this);
        this.acceptItem = new JCheckBoxMenuItem("Accepting");
        this.acceptItem.setActionCommand(ACTION_ACCEPTING);
        this.acceptItem.addActionListener(this);
        this.startItem = new JCheckBoxMenuItem("Start");
        this.startItem.setActionCommand(ACTION_START);
        this.startItem.addActionListener(this);
        this.changeItem = new JMenuItem("Change label");
        this.changeItem.setActionCommand(ACTION_CHANGE_LABEL);
        this.changeItem.addActionListener(this);
    }

    public JPopupMenu getPopup(FSMStateInterface fSMStateInterface) {
        this.state = fSMStateInterface;
        this.menu.removeAll();
        if (!fSMStateInterface.isStartState()) {
            this.menu.add(this.deleteItem);
        }
        this.menu.add(this.acceptItem);
        this.acceptItem.setState(fSMStateInterface.isAccepting());
        this.menu.add(this.startItem);
        this.startItem.setState(fSMStateInterface.isStartState());
        if (fSMStateInterface.isStartState()) {
            this.startItem.setEnabled(false);
        } else {
            this.startItem.setEnabled(true);
        }
        this.menu.add(this.changeItem);
        return this.menu;
    }

    public void delete(ActionEvent actionEvent) {
        this.controller.getFSMEditorOperations().deleteState(this.state);
    }

    public void accepting(ActionEvent actionEvent) {
        this.controller.getFSMEditorOperations().setStateAccepting(this.state, !this.state.isAccepting());
    }

    public void start(ActionEvent actionEvent) {
        this.controller.getFSMEditorOperations().setStartState(this.state);
    }

    public void changeLabel(ActionEvent actionEvent) {
        if (null == this.stateLabelDialog) {
            this.stateLabelDialog = new StateLabelDialog(this.parent);
        }
        this.stateLabelDialog.setVisible(true);
    }

    private class StateLabelDialog
    extends Dialog
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        TextField t;

        StateLabelDialog(Frame frame) {
            super(frame, "Change statelabel", true);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    StateLabelDialog.this.dispose();
                }
            });
            this.setLayout(new FlowLayout());
            this.t = new TextField(15);
            this.t.setText(StatePopup.this.state.getLabel().toString());
            this.add(this.t);
            this.t.addActionListener(this);
            JButton jButton = new JButton("ok");
            this.add(jButton);
            jButton.addActionListener(this);
            this.pack();
            Point point = StatePopup.this.fascape.getLocationOnScreen();
            this.setLocation(point.x + StatePopup.this.fascape.getWidth() / 2 - this.getWidth() / 2, point.y + StatePopup.this.fascape.getHeight() / 2 - this.getHeight() / 2);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            StatePopup.this.controller.getFSMEditorOperations().setStateLabel(StatePopup.this.state, this.t.getText());
            this.dispose();
        }
    }
}

