/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.fsmgui.controller;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class ZoomNDragablePane {
    double scale = 1.0;
    double refScale;
    double dScaleDist = 150.0;
    double maxScale = 8.0;
    double minScale = 0.125;
    double dx = 0.0;
    double dy = 0.0;
    double refDx;
    double refDy;
    boolean limited = true;
    Rectangle viewRect;
    Rectangle objectRect;
    double transRefX;
    double transRefY;
    double scaleRefX;
    double scaleRefY;

    public void limited(int n, int n2, int n3, int n4) {
        this.limited = true;
        this.viewRect = new Rectangle(0, 0, n, n2);
        this.objectRect = new Rectangle(0, 0, n3, n4);
        this.maxScale = 1.0;
    }

    public boolean isLimited() {
        return this.viewRect != null && this.objectRect != null;
    }

    public void reset() {
        this.scale = 1.0;
        this.dx = 1.0;
        this.dy = 1.0;
    }

    public void setScale(double d) {
        this.scale = d;
    }

    public double getScale() {
        return this.scale;
    }

    public void setTranslation(double d, double d2) {
        this.dx = d;
        this.dy = d2;
    }

    public double getTranslationX() {
        return this.dx;
    }

    public double getTranslationY() {
        return this.dy;
    }

    public void setDoubleScaleDistance(int n) {
        this.dScaleDist = n;
    }

    public void setScaleRange(double d, double d2) {
        this.minScale = d;
        this.maxScale = d2;
    }

    public void setTranslationRef(int n, int n2) {
        this.transRefX = n;
        this.transRefY = n2;
        this.refDx = this.dx;
        this.refDy = this.dy;
    }

    public void setTranslationRef(double d, double d2) {
        this.transRefX = d;
        this.transRefY = d2;
        this.refDx = this.dx;
        this.refDy = this.dy;
    }

    public void translate(int n, int n2) {
        this.dx = this.refDx + (double)n - this.transRefX;
        this.dy = this.refDy + (double)n2 - this.transRefY;
        if (this.limited) {
            this.limitDrag();
        }
    }

    public void setScaleRef(int n, int n2) {
        this.scaleRefX = n;
        this.scaleRefY = n2;
        this.refScale = this.scale;
    }

    public void setScaleRef(double d, double d2) {
        this.scaleRefX = d;
        this.scaleRefY = d2;
        this.refScale = this.scale;
    }

    public void scale(int n) {
        double d = this.scaleRefY < (double)n ? this.refScale * (1.0 + 2.0 * ((double)n - this.scaleRefY) / this.dScaleDist) : this.refScale * (1.0 - 0.5 * (this.scaleRefY - (double)n) / this.dScaleDist);
        if (d < this.minScale) {
            d = this.minScale;
        }
        if (d > this.maxScale) {
            d = this.maxScale;
        }
        Point2D point2D = this.getModelCoords(this.scaleRefX, this.scaleRefY);
        this.scale = d;
        if (this.limited) {
            d = this.limitZoom();
        }
        double d2 = this.scaleRefX - (point2D.getX() * d + this.dx);
        double d3 = this.scaleRefY - (point2D.getY() * d + this.dy);
        this.dx += d2;
        this.dy += d3;
        if (this.limited) {
            this.limitDrag();
        }
    }

    public void adjustLimitations() {
        this.limitZoom();
        this.limitDrag();
    }

    private double limitZoom() {
        double d;
        if (this.scale < 1.0 && (d = Math.max((double)this.objectRect.width * this.scale / (double)this.viewRect.width, (double)this.objectRect.height * this.scale / (double)this.viewRect.height)) < 1.0) {
            this.scale = Math.min(this.scale / d, 1.0);
        }
        return this.scale;
    }

    private void limitDrag() {
        double d = this.getViewCoords(this.objectRect.x, 0.0).getX() - (double)this.viewRect.x;
        double d2 = this.getViewCoords(this.objectRect.width + this.objectRect.x, 0.0).getX() - (double)this.viewRect.width - (double)this.viewRect.x;
        double d3 = this.getViewCoords(0.0, this.objectRect.y).getY() - (double)this.viewRect.y;
        double d4 = this.getViewCoords(0.0, this.objectRect.height + this.objectRect.y).getY() - (double)this.viewRect.height - (double)this.viewRect.y;
        if ((double)this.objectRect.width * this.scale < (double)this.viewRect.width) {
            this.dx = (d - d2) / 2.0;
        } else if (d > 0.0) {
            this.dx -= d;
        } else if (d2 < 0.0) {
            this.dx -= Math.max(this.getViewCoords(this.objectRect.x, 0.0).getX() - (double)this.viewRect.x, d2);
        }
        if ((double)this.objectRect.height * this.scale < (double)this.viewRect.height) {
            this.dy = (d3 - d4) / 2.0;
        } else if (d3 > 0.0) {
            this.dy -= d3;
        } else if (d4 < 0.0) {
            this.dy -= Math.max(this.getViewCoords(0.0, this.objectRect.y).getY() - (double)this.viewRect.y, d4);
        }
    }

    public Point2D getModelCoords(double d, double d2) {
        double d3 = (d - this.dx) / this.scale;
        double d4 = (d2 - this.dy) / this.scale;
        return new Point2D.Double(d3, d4);
    }

    public Point2D getViewCoords(double d, double d2) {
        double d3 = d * this.scale + this.dx;
        double d4 = d2 * this.scale + this.dy;
        return new Point2D.Double(d3, d4);
    }

    public GeneralPath makeTransformedPath(float[] fArray) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.reset();
        generalPath.moveTo((float)((double)fArray[0] * this.scale + this.dx), (float)((double)fArray[1] * this.scale + this.dy));
        for (int i = 2; i < fArray.length - 1; i += 2) {
            generalPath.lineTo((float)((double)fArray[i] * this.scale + this.dx), (float)((double)fArray[i + 1] * this.scale + this.dy));
        }
        generalPath.closePath();
        return generalPath;
    }

    public void transform(Graphics2D graphics2D) {
        graphics2D.translate((int)this.dx, (int)this.dy);
        graphics2D.scale(this.scale, this.scale);
    }
}

