/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.fsmgui.controller;

import ch.ethz.fsmgui.EditorAction;
import ch.ethz.fsmgui.FSMEvent;
import ch.ethz.fsmgui.model.Alphabet;
import ch.ethz.fsmgui.model.FSMModelInterface;
import ch.ethz.fsmgui.model.FSMStateInterface;
import ch.ethz.fsmgui.view.FSMView;
import ch.ethz.fsmgui.view.State;
import ch.ethz.fsmgui.view.Transition;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;

public class FSMEditorOperations {
    FSMModelInterface model;
    FSMView view;
    Stack<EditorAction> undoList = new Stack();
    Stack<EditorAction> redoList = new Stack();

    public FSMEditorOperations(FSMModelInterface fSMModelInterface, FSMView fSMView) {
        this.model = fSMModelInterface;
        this.view = fSMView;
    }

    public void setModel(FSMModelInterface fSMModelInterface) {
        this.model = fSMModelInterface;
    }

    public void addState(FSMStateInterface fSMStateInterface) {
        EditorAction editorAction = new EditorAction(this.model, FSMEvent.createDeleteStateEvent(fSMStateInterface), FSMEvent.createAddStateEvent(fSMStateInterface));
        this.model.addState(fSMStateInterface);
        this.addUndoEditorAction(editorAction);
    }

    public void addStartState(FSMStateInterface fSMStateInterface) {
        EditorAction editorAction = new EditorAction(this.model, FSMEvent.createDeleteStateEvent(fSMStateInterface), FSMEvent.createAddStateEvent(fSMStateInterface));
        this.model.addState(fSMStateInterface);
        editorAction.addRedoEvent(FSMEvent.createSetStartStateEvent(fSMStateInterface));
        editorAction.addUndoEvent(FSMEvent.createSetStartStateEvent(null));
        this.model.setStartState(fSMStateInterface);
        this.addUndoEditorAction(editorAction);
    }

    public void deleteState(FSMStateInterface fSMStateInterface) {
        EditorAction editorAction = new EditorAction(this.model);
        for (FSMStateInterface fSMStateInterface2 : this.model.getAllStates()) {
            Set set = fSMStateInterface2.getInputs();
            if (null == set) continue;
            for (Character c : set) {
                Set set2 = fSMStateInterface2.getNextStateSet(c);
                for (FSMStateInterface fSMStateInterface3 : set2) {
                    if (fSMStateInterface3 != fSMStateInterface && fSMStateInterface2 != fSMStateInterface) continue;
                    editorAction.addUndoEvent(FSMEvent.createAddTransitionEvent(fSMStateInterface2, fSMStateInterface3, c));
                }
            }
        }
        editorAction.addUndoEvent(FSMEvent.createAddStateEvent(fSMStateInterface));
        editorAction.addRedoEvent(FSMEvent.createDeleteStateEvent(fSMStateInterface));
        this.addUndoEditorAction(editorAction);
        this.model.removeState(fSMStateInterface);
    }

    public void setStateAccepting(FSMStateInterface fSMStateInterface, boolean bl) {
        EditorAction editorAction = new EditorAction(this.model, FSMEvent.createSetAcceptingEvent(fSMStateInterface, !bl), FSMEvent.createSetAcceptingEvent(fSMStateInterface, bl));
        this.addUndoEditorAction(editorAction);
        fSMStateInterface.setAccepting(bl);
    }

    public void setStateLabel(FSMStateInterface fSMStateInterface, String string) {
        EditorAction editorAction = new EditorAction(this.model, FSMEvent.createSetStateLabelEvent(fSMStateInterface, fSMStateInterface.getLabel()), FSMEvent.createSetStateLabelEvent(fSMStateInterface, string));
        this.addUndoEditorAction(editorAction);
        fSMStateInterface.setLabel(string);
    }

    public void setStartState(FSMStateInterface fSMStateInterface) {
        EditorAction editorAction = new EditorAction(this.model, FSMEvent.createSetStartStateEvent(this.model.getStartState()), FSMEvent.createSetStartStateEvent(fSMStateInterface));
        this.addUndoEditorAction(editorAction);
        this.model.setStartState(fSMStateInterface);
    }

    private void deleteTransition(EditorAction editorAction, FSMStateInterface fSMStateInterface, FSMStateInterface fSMStateInterface2, Object object) {
        editorAction.addRedoEvent(FSMEvent.createDeleteTransitionEvent(fSMStateInterface, fSMStateInterface2, object));
        editorAction.addUndoEvent(FSMEvent.createAddTransitionEvent(fSMStateInterface, fSMStateInterface2, object));
        fSMStateInterface.removeTransition(object, fSMStateInterface2);
    }

    private void addTransition(EditorAction editorAction, FSMStateInterface fSMStateInterface, FSMStateInterface fSMStateInterface2, Object object) {
        editorAction.addRedoEvent(FSMEvent.createAddTransitionEvent(fSMStateInterface, fSMStateInterface2, object));
        editorAction.addUndoEvent(FSMEvent.createDeleteTransitionEvent(fSMStateInterface, fSMStateInterface2, object));
        fSMStateInterface.addTransition(object, fSMStateInterface2);
    }

    public void addTransition(FSMStateInterface fSMStateInterface, FSMStateInterface fSMStateInterface2, Object object) {
        EditorAction editorAction = new EditorAction(this.model);
        this.addTransition(editorAction, fSMStateInterface, fSMStateInterface2, object);
        this.addUndoEditorAction(editorAction);
    }

    public void deleteTransition(FSMStateInterface fSMStateInterface, FSMStateInterface fSMStateInterface2, Object object) {
        EditorAction editorAction = new EditorAction(this.model);
        this.deleteTransition(editorAction, fSMStateInterface, fSMStateInterface2, object);
        this.addUndoEditorAction(editorAction);
    }

    public void deleteTransitions(FSMStateInterface fSMStateInterface, Object object) {
        EditorAction editorAction = new EditorAction(this.model);
        Iterator iterator = fSMStateInterface.getNextStateSet(object).iterator();
        while (iterator.hasNext()) {
            this.deleteTransition(editorAction, fSMStateInterface, (FSMStateInterface)iterator.next(), object);
        }
        this.addUndoEditorAction(editorAction);
    }

    public void changeTransition(Transition transition, State state, State state2) {
        int n;
        Transition transition2;
        EditorAction editorAction = new EditorAction(this.model);
        if (state2 != null && null != (transition2 = this.view.getTransition(transition.from.model, state2.model))) {
            for (int i = 0; i < transition2.label.number(); ++i) {
                editorAction.addUndoEvent(FSMEvent.createAddTransitionEvent(transition2.from.model, transition2.to.model, transition2.label.getInput(i)));
            }
        }
        for (n = 0; n < transition.label.number(); ++n) {
            this.deleteTransition(editorAction, transition.from.model, state.model, transition.label.getInput(n));
        }
        if (null != state2) {
            for (n = 0; n < transition.label.number(); ++n) {
                if (transition.from == state2 && Alphabet.EPSILON.equals(transition.label.getInput(n))) continue;
                this.addTransition(editorAction, transition.from.model, state2.model, transition.label.getInput(n));
            }
        }
        this.addUndoEditorAction(editorAction);
    }

    public void setTransitionInput(Transition transition, Object[] objectArray) {
        if (transition != null && objectArray != null) {
            EditorAction editorAction = new EditorAction(this.model);
            if (transition.label.number() < 1) {
                this.addTransitionInput(transition, objectArray);
            } else {
                int n;
                Object object = transition.mark;
                int n2 = transition.label.number();
                for (n = 0; n < n2; ++n) {
                    this.deleteTransition(editorAction, transition.from.model, transition.to.model, transition.label.getInput(0));
                }
                for (n = 0; n < objectArray.length; ++n) {
                    this.addTransition(editorAction, transition.from.model, transition.to.model, objectArray[n]);
                }
                this.addUndoEditorAction(editorAction);
                Transition transition2 = this.view.getTransition(transition.from, transition.to);
                if (transition2 != null) {
                    transition2.mark = object;
                }
            }
        }
    }

    public void addTransitionInput(Transition transition, Object[] objectArray) {
        if (transition != null && objectArray != null) {
            EditorAction editorAction = new EditorAction(this.model);
            for (int i = 0; i < objectArray.length; ++i) {
                this.addTransition(editorAction, transition.from.model, transition.to.model, objectArray[i]);
            }
            this.addUndoEditorAction(editorAction);
        }
    }

    public void addTransitions(Vector vector) {
        if (vector != null) {
            EditorAction editorAction = new EditorAction(this.model);
            for (int i = 0; i < vector.size(); i += 3) {
                this.addTransition(editorAction, (FSMStateInterface)vector.elementAt(i), (FSMStateInterface)vector.elementAt(i + 1), (Character)vector.elementAt(i + 2));
            }
            this.addUndoEditorAction(editorAction);
        }
    }

    public void setFAName(String string) {
        EditorAction editorAction = new EditorAction(this.model, FSMEvent.createSetFSMNameEvent(this.model.getName()), FSMEvent.createSetFSMNameEvent(string));
        this.addUndoEditorAction(editorAction);
        this.model.setName(string);
    }

    public void clear() {
        EditorAction editorAction = new EditorAction(this.model, FSMEvent.createResetModelEvent(this.model.getAllStates()), FSMEvent.createClearAllEvent());
        this.model.clear();
        this.addUndoEditorAction(editorAction);
    }

    public void markState(FSMStateInterface fSMStateInterface, Object object) {
        Hashtable<FSMStateInterface, Object> hashtable = new Hashtable<FSMStateInterface, Object>();
        hashtable.put(fSMStateInterface, object);
        this.view.notify(FSMEvent.createMarkEvent(hashtable));
    }

    public void markTransition(FSMStateInterface fSMStateInterface, FSMStateInterface fSMStateInterface2, Object object) {
        Hashtable<Object[], Object> hashtable = new Hashtable<Object[], Object>();
        Object[] objectArray = new Object[]{fSMStateInterface, fSMStateInterface2};
        hashtable.put(objectArray, object);
        this.view.notify(FSMEvent.createMarkEvent(hashtable));
    }

    public void undo() {
        if (!this.undoList.empty()) {
            this.redoList.push(this.undoList.peek().getRedoEditorAction());
            this.undoList.pop().undo();
        } else {
            System.out.println("nothing to undo");
        }
    }

    public void redo() {
        if (!this.redoList.empty()) {
            this.undoList.push(this.redoList.peek().getRedoEditorAction());
            this.redoList.pop().undo();
        } else {
            System.out.println("nothing to redo");
        }
    }

    public void addUndoEditorAction(EditorAction editorAction) {
        this.undoList.push(editorAction);
        this.redoList.clear();
    }

    public boolean undoListEmpty() {
        return this.undoList.empty();
    }

    public boolean redoListEmpty() {
        return this.redoList.empty();
    }
}

