/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.fsmgui;

import ch.ethz.fsmgui.FSMEvent;
import ch.ethz.fsmgui.model.FSMModelInterface;
import ch.ethz.fsmgui.model.FSMStateInterface;
import java.util.Iterator;
import java.util.Vector;

public class EditorAction {
    FSMModelInterface model;
    Vector<FSMEvent> undo = new Vector();
    Vector<FSMEvent> redo = new Vector();

    public EditorAction(FSMModelInterface fSMModelInterface) {
        this.model = fSMModelInterface;
    }

    public EditorAction(FSMModelInterface fSMModelInterface, FSMEvent fSMEvent, FSMEvent fSMEvent2) {
        this.model = fSMModelInterface;
        this.undo.add(fSMEvent);
        this.redo.add(fSMEvent2);
    }

    public void addUndoEvent(FSMEvent fSMEvent) {
        this.undo.add(0, fSMEvent);
    }

    public void addRedoEvent(FSMEvent fSMEvent) {
        this.redo.add(fSMEvent);
    }

    public EditorAction getRedoEditorAction() {
        EditorAction editorAction = new EditorAction(this.model);
        editorAction.undo = this.redo;
        editorAction.redo = this.undo;
        return editorAction;
    }

    public void undo() {
        block15: for (int i = 0; i < this.undo.size(); ++i) {
            FSMEvent fSMEvent = this.undo.elementAt(i);
            switch (fSMEvent.getId()) {
                case 11: {
                    this.model.setAlphabet(fSMEvent.getAlphabet());
                    continue block15;
                }
                case 1: {
                    this.model.addState(fSMEvent.getState());
                    continue block15;
                }
                case 2: {
                    this.model.removeState(fSMEvent.getState());
                    continue block15;
                }
                case 5: {
                    fSMEvent.getState().setLabel(fSMEvent.getStateLabel());
                    continue block15;
                }
                case 3: {
                    fSMEvent.getState().setAccepting(fSMEvent.isAccepting());
                    continue block15;
                }
                case 4: {
                    this.model.setStartState(fSMEvent.getState());
                    continue block15;
                }
                case 9: {
                    this.model.clear();
                    continue block15;
                }
                case 7: {
                    fSMEvent.getFromState().addTransition(fSMEvent.getInput(), fSMEvent.getToState());
                    continue block15;
                }
                case 8: {
                    fSMEvent.getFromState().removeTransition(fSMEvent.getInput(), fSMEvent.getToState());
                    continue block15;
                }
                case 12: {
                    this.model.setName(fSMEvent.getFSMName());
                    continue block15;
                }
                case 13: {
                    this.model.notifyFSMModelListeners(fSMEvent);
                    continue block15;
                }
                case 14: {
                    this.model.notifyFSMModelListeners(fSMEvent);
                    continue block15;
                }
                case 10: {
                    FSMStateInterface fSMStateInterface;
                    this.model.clear();
                    Iterator iterator = fSMEvent.getStateSet().iterator();
                    while (null != iterator && iterator.hasNext()) {
                        fSMStateInterface = (FSMStateInterface)iterator.next();
                        this.model.addState(fSMStateInterface);
                    }
                    iterator = fSMEvent.getStateSet().iterator();
                    while (null != iterator && iterator.hasNext()) {
                        fSMStateInterface = (FSMStateInterface)iterator.next();
                        for (Character c : fSMStateInterface.getInputs()) {
                            for (FSMStateInterface fSMStateInterface2 : fSMStateInterface.getNextStateSet(c)) {
                                this.model.notifyFSMModelListeners(FSMEvent.createAddTransitionEvent(fSMStateInterface, fSMStateInterface2, c));
                            }
                        }
                    }
                    continue block15;
                }
            }
        }
    }

    public void print() {
        if (this.undo.size() == 0) {
            System.out.println("no FSMEvents");
        }
        for (int i = 0; i < this.undo.size(); ++i) {
            FSMEvent fSMEvent = this.undo.elementAt(i);
            System.out.println("EventID: " + fSMEvent.getId());
        }
    }
}

